/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events.serviceRequests;

import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.Account;
import org.fenixedu.academic.domain.accounting.AccountType;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.PostingRule;
import org.fenixedu.academic.domain.accounting.events.serviceRequests.AcademicServiceRequestEvent_Base;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;

public abstract class AcademicServiceRequestEvent
extends AcademicServiceRequestEvent_Base {
    protected AcademicServiceRequestEvent() {
    }

    protected void init(AdministrativeOffice administrativeOffice, EventType eventType, Person person, AcademicServiceRequest academicServiceRequest) {
        super.init(administrativeOffice, eventType, person);
        this.checkParameters(academicServiceRequest);
        super.setAcademicServiceRequest(academicServiceRequest);
    }

    protected final void checkParameters(AcademicServiceRequest academicServiceRequest) {
        if (academicServiceRequest == null) {
            throw new DomainException("AcademicServiceRequestEvent.academicServiceRequest.cannot.be.null", new String[0]);
        }
    }

    public void setAcademicServiceRequest(AcademicServiceRequest academicServiceRequest) {
        throw new DomainException("error.events.serviceRequests.AcademicServiceRequestEvent.cannot.modify.academicServiceRequest", new String[0]);
    }

    public final Account getToAccount() {
        return this.getAdministrativeOffice().getUnit().getAccountBy(AccountType.INTERNAL);
    }

    protected final Account getFromAccount() {
        return this.getPerson().getAccountBy(AccountType.EXTERNAL);
    }

    public PostingRule getPostingRule() {
        return this.getAdministrativeOffice().getServiceAgreementTemplate().findPostingRuleByEventTypeAndDate(this.getEventType(), this.getWhenOccured());
    }

    protected final ExecutionYear getExecutionYear() {
        return this.getAcademicServiceRequest().getExecutionYear();
    }

    public final boolean isUrgentRequest() {
        return this.getAcademicServiceRequest().isUrgentRequest();
    }

    protected void disconnect() {
        super.setAcademicServiceRequest(null);
        super.disconnect();
    }

    public boolean isAcademicServiceRequestEvent() {
        return true;
    }
}

