/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.util;

import org.fenixedu.academic.util.FenixUtil;

public class EnrolmentEvaluationState
extends FenixUtil {
    public static final int FINAL = 1;
    public static final int TEMPORARY = 2;
    public static final int RECTIFIED = 5;
    public static final int RECTIFICATION = 3;
    public static final int ANNULED = 4;
    public static final EnrolmentEvaluationState FINAL_OBJ = new EnrolmentEvaluationState(1, 2);
    public static final EnrolmentEvaluationState TEMPORARY_OBJ = new EnrolmentEvaluationState(2, 1);
    public static final EnrolmentEvaluationState RECTIFIED_OBJ = new EnrolmentEvaluationState(5, 3);
    public static final EnrolmentEvaluationState RECTIFICATION_OBJ = new EnrolmentEvaluationState(3, 4);
    public static final EnrolmentEvaluationState ANNULED_OBJ = new EnrolmentEvaluationState(4, 0);
    private final Integer state;
    private final int weight;

    private EnrolmentEvaluationState(int state, int weight) {
        this.state = new Integer(state);
        this.weight = weight;
    }

    public static EnrolmentEvaluationState valueOf(Integer state) {
        switch (state) {
            case 1: {
                return FINAL_OBJ;
            }
            case 2: {
                return TEMPORARY_OBJ;
            }
            case 5: {
                return RECTIFIED_OBJ;
            }
            case 3: {
                return RECTIFICATION_OBJ;
            }
            case 4: {
                return ANNULED_OBJ;
            }
        }
        return null;
    }

    public Integer getState() {
        return this.state;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean equals(Object o) {
        if (o instanceof EnrolmentEvaluationState) {
            EnrolmentEvaluationState aux = (EnrolmentEvaluationState)o;
            return this.state.equals(aux.getState());
        }
        return false;
    }

    public String toString() {
        int value = this.state;
        String valueS = null;
        switch (value) {
            case 2: {
                valueS = "TEMPORARY";
                break;
            }
            case 1: {
                valueS = "FINAL";
                break;
            }
            case 5: {
                valueS = "RECTIFIED";
                break;
            }
            case 3: {
                valueS = "RECTIFICATION";
                break;
            }
            case 4: {
                valueS = "ANNULED";
                break;
            }
        }
        return valueS;
    }
}

