/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.resourceAllocationManager;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.EnrolmentPeriod;
import org.fenixedu.academic.domain.EnrolmentPeriodInClasses;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.OccupationPeriod;
import org.fenixedu.academic.domain.OccupationPeriodType;
import org.fenixedu.academic.domain.interfaces.HasExecutionSemester;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.resourceAllocationManager.RAMApplication;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@StrutsFunctionality(app=RAMApplication.RAMPeriodsApp.class, path="show", titleKey="link.periods")
@Mapping(path="/showPeriods", module="resourceAllocationManager")
@Forwards(value={@Forward(name="firstPage", path="/resourceAllocationManager/periods/firstPage.jsp")})
public class ViewPeriodsAction
extends FenixDispatchAction {
    public ActionForward firstPage(ActionMapping mapping, HttpServletRequest request, ContextBean contextBean) {
        RenderUtils.invalidateViewState();
        request.setAttribute("contextBean", (Object)contextBean);
        return mapping.findForward("firstPage");
    }

    @EntryPoint
    public ActionForward firstPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ContextBean contextBean = (ContextBean)this.getRenderedObject();
        if (contextBean == null) {
            contextBean = new ContextBean();
        }
        return this.firstPage(mapping, request, contextBean);
    }

    public static class ContextBean
    implements Serializable,
    HasExecutionSemester {
        private static final long serialVersionUID = 1L;
        private ExecutionSemester executionSemester;
        private ExecutionDegree executionDegree;

        public ContextBean() {
            this.setExecutionSemester(ExecutionSemester.readActualExecutionSemester());
        }

        public ContextBean(ExecutionSemester executionSemester) {
            this.setExecutionSemester(executionSemester);
        }

        public ExecutionSemester getExecutionSemester() {
            return this.executionSemester;
        }

        @Override
        public ExecutionSemester getExecutionPeriod() {
            return this.getExecutionSemester();
        }

        public void setExecutionSemester(ExecutionSemester executionSemester) {
            this.executionSemester = executionSemester;
            this.executionDegree = null;
        }

        public ExecutionDegree getExecutionDegree() {
            return this.executionDegree;
        }

        public void setExecutionDegree(ExecutionDegree executionDegree) {
            this.executionDegree = executionDegree;
        }

        public EnrolmentPeriodInClasses getEnrolmentPeriodInClasses() {
            if (this.executionSemester != null && this.executionDegree != null) {
                for (EnrolmentPeriod enrolmentPeriod : this.executionSemester.getEnrolmentPeriodSet()) {
                    if (!(enrolmentPeriod instanceof EnrolmentPeriodInClasses) || this.executionDegree.getDegreeCurricularPlan() != enrolmentPeriod.getDegreeCurricularPlan()) continue;
                    return (EnrolmentPeriodInClasses)((Object)enrolmentPeriod);
                }
            }
            return null;
        }

        public OccupationPeriod getLessonPeriod() {
            return this.getPeriod(OccupationPeriodType.LESSONS, this.executionSemester);
        }

        public OccupationPeriod getExamPeriod() {
            return this.getPeriod(OccupationPeriodType.EXAMS, this.executionSemester);
        }

        public OccupationPeriod getSpecialSeasonExamPeriod() {
            return this.getPeriod(OccupationPeriodType.EXAMS_SPECIAL_SEASON, null);
        }

        private OccupationPeriod getPeriod(OccupationPeriodType type, ExecutionSemester semester) {
            if (this.executionSemester != null && this.executionDegree != null) {
                return this.executionDegree.getPeriods(type, semester == null ? null : semester.getSemester()).findAny().orElse(null);
            }
            return null;
        }
    }
}

