/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.resourceAllocationManager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.util.LabelValueBean;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.dto.InfoClass;
import org.fenixedu.academic.dto.InfoCurricularYear;
import org.fenixedu.academic.dto.InfoExecutionCourse;
import org.fenixedu.academic.dto.InfoExecutionDegree;
import org.fenixedu.academic.dto.InfoShift;
import org.fenixedu.academic.dto.InfoShiftEditor;
import org.fenixedu.academic.dto.InfoStudent;
import org.fenixedu.academic.dto.ShiftKey;
import org.fenixedu.academic.service.services.exceptions.FenixServiceMultipleException;
import org.fenixedu.academic.service.services.resourceAllocationManager.ChangeStudentsShift;
import org.fenixedu.academic.service.services.resourceAllocationManager.DeleteLessons;
import org.fenixedu.academic.service.services.resourceAllocationManager.EditarTurno;
import org.fenixedu.academic.service.services.resourceAllocationManager.LerAlunosDeTurno;
import org.fenixedu.academic.service.services.resourceAllocationManager.LerDisciplinasExecucaoDeLicenciaturaExecucaoEAnoCurricular;
import org.fenixedu.academic.service.services.resourceAllocationManager.LerTurnosDeDisciplinaExecucao;
import org.fenixedu.academic.service.services.resourceAllocationManager.RemoveClasses;
import org.fenixedu.academic.service.services.resourceAllocationManager.RemoverTurno;
import org.fenixedu.academic.ui.struts.action.exceptions.ExistingActionException;
import org.fenixedu.academic.ui.struts.action.resourceAllocationManager.ExecutionPeriodDA;
import org.fenixedu.academic.ui.struts.action.resourceAllocationManager.base.FenixShiftAndExecutionCourseAndExecutionDegreeAndCurricularYearContextDispatchAction;
import org.fenixedu.academic.ui.struts.action.resourceAllocationManager.utils.RequestUtils;
import org.fenixedu.academic.ui.struts.action.utils.ContextUtils;
import org.fenixedu.academic.ui.struts.config.FenixErrorExceptionHandler;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.annotations.ExceptionHandling;
import org.fenixedu.bennu.struts.annotations.Exceptions;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixframework.FenixFramework;

@Mapping(path="/manageShift", module="resourceAllocationManager", input="/manageShift.do?method=prepareEditShift", formBean="createShiftForm", functionality=ExecutionPeriodDA.class)
@Forwards(value={@Forward(name="EditShift", path="/resourceAllocationManager/manageShift_bd.jsp"), @Forward(name="ViewStudentsEnroled", path="/resourceAllocationManager/viewStudentsEnroledInShift_bd.jsp"), @Forward(name="Continue", path="/resourceAllocationManager/manageShift.do?method=prepareEditShift")})
@Exceptions(value={@ExceptionHandling(handler=FenixErrorExceptionHandler.class, type=ExistingActionException.class, key="resources.Action.exceptions.ExistingActionException", scope="request"), @ExceptionHandling(handler=FenixErrorExceptionHandler.class, type=ChangeStudentsShift.UnableToTransferStudentsException.class, key="message.unable.to.transfer.students", scope="request")})
public class ManageShiftDA
extends FenixShiftAndExecutionCourseAndExecutionDegreeAndCurricularYearContextDispatchAction {
    public ActionForward prepareEditShift(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InfoShift infoShiftToEdit = (InfoShift)request.getAttribute("shift");
        DynaActionForm editShiftForm = (DynaActionForm)form;
        editShiftForm.set("courseInitials", (Object)infoShiftToEdit.getInfoDisciplinaExecucao().getSigla());
        editShiftForm.set("nome", (Object)infoShiftToEdit.getNome());
        editShiftForm.set("lotacao", (Object)infoShiftToEdit.getLotacao());
        editShiftForm.set("comment", (Object)infoShiftToEdit.getComment());
        List<ShiftType> shiftTypes = infoShiftToEdit.getShift().getTypes();
        String[] selectedshiftTypesArray = new String[shiftTypes.size()];
        for (int i = 0; i < shiftTypes.size(); ++i) {
            ShiftType shiftType = shiftTypes.get(i);
            selectedshiftTypesArray[i] = shiftType.getName();
        }
        editShiftForm.set("shiftTiposAula", (Object)selectedshiftTypesArray);
        ManageShiftDA.getExecutionCourses(request);
        this.readAndSetShiftTypes(request, infoShiftToEdit.getInfoDisciplinaExecucao());
        return mapping.findForward("EditShift");
    }

    public ActionForward listExecutionCourseCourseLoads(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DynaActionForm editShiftForm = (DynaActionForm)form;
        InfoShift infoShiftToEdit = (InfoShift)request.getAttribute("shift");
        InfoExecutionCourse infoExecutionCourse = RequestUtils.getExecutionCourseBySigla(request, (String)editShiftForm.get("courseInitials"));
        if (infoShiftToEdit.getInfoDisciplinaExecucao().getExecutionCourse().equals((Object)infoExecutionCourse.getExecutionCourse())) {
            editShiftForm.set("courseInitials", (Object)infoShiftToEdit.getInfoDisciplinaExecucao().getSigla());
            editShiftForm.set("nome", (Object)infoShiftToEdit.getNome());
            List<ShiftType> shiftTypes = infoShiftToEdit.getShift().getTypes();
            String[] selectedshiftTypesArray = new String[shiftTypes.size()];
            for (int i = 0; i < shiftTypes.size(); ++i) {
                ShiftType shiftType = shiftTypes.get(i);
                selectedshiftTypesArray[i] = shiftType.getName();
            }
            editShiftForm.set("shiftTiposAula", (Object)selectedshiftTypesArray);
            editShiftForm.set("lotacao", (Object)infoShiftToEdit.getLotacao());
        } else {
            editShiftForm.set("shiftTiposAula", (Object)new String[0]);
            editShiftForm.set("lotacao", (Object)0);
            editShiftForm.set("nome", (Object)"");
        }
        ManageShiftDA.getExecutionCourses(request);
        this.readAndSetShiftTypes(request, infoExecutionCourse);
        return mapping.findForward("EditShift");
    }

    public ActionForward editShift(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DynaActionForm editShiftForm = (DynaActionForm)form;
        InfoShift infoShiftOld = (InfoShift)request.getAttribute("shift");
        InfoExecutionCourse infoExecutionCourseNew = RequestUtils.getExecutionCourseBySigla(request, (String)editShiftForm.get("courseInitials"));
        InfoShiftEditor infoShiftNew = new InfoShiftEditor();
        infoShiftNew.setExternalId(infoShiftOld.getExternalId());
        infoShiftNew.setInfoDisciplinaExecucao(infoExecutionCourseNew);
        infoShiftNew.setInfoLessons(infoShiftOld.getInfoLessons());
        infoShiftNew.setLotacao((Integer)editShiftForm.get("lotacao"));
        infoShiftNew.setNome((String)editShiftForm.get("nome"));
        infoShiftNew.setComment((String)editShiftForm.get("comment"));
        String[] selectedShiftTypes = (String[])editShiftForm.get("shiftTiposAula");
        if (selectedShiftTypes.length == 0) {
            ActionErrors actionErrors = new ActionErrors();
            actionErrors.add("errors.shift.types.notSelected", new ActionError("errors.shift.types.notSelected"));
            this.saveErrors(request, actionErrors);
            return mapping.getInputForward();
        }
        ArrayList<ShiftType> shiftTypes = new ArrayList<ShiftType>();
        for (String selectedShiftType : selectedShiftTypes) {
            shiftTypes.add(ShiftType.valueOf(selectedShiftType.toString()));
        }
        infoShiftNew.setTipos(shiftTypes);
        try {
            EditarTurno.run(infoShiftOld, infoShiftNew);
        }
        catch (DomainException ex) {
            ActionErrors actionErrors = new ActionErrors();
            actionErrors.add("error", new ActionError(ex.getMessage()));
            this.saveErrors(request, actionErrors);
            return mapping.getInputForward();
        }
        request.setAttribute("execution_course", (Object)infoExecutionCourseNew);
        ContextUtils.setShiftContext(request);
        return this.prepareEditShift(mapping, form, request, response);
    }

    public ActionForward removeClass(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ContextUtils.setClassContext(request);
        InfoClass infoClass = (InfoClass)request.getAttribute("context.classView");
        InfoShift infoShift = (InfoShift)request.getAttribute("shift");
        RemoverTurno.run(infoShift, infoClass);
        ContextUtils.setShiftContext(request);
        request.removeAttribute("context.classView");
        return this.prepareEditShift(mapping, form, request, response);
    }

    public ActionForward removeClasses(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DynaActionForm removeClassesForm = (DynaActionForm)form;
        String[] selectedClasses = (String[])removeClassesForm.get("selectedItems");
        if (selectedClasses.length == 0) {
            ActionErrors actionErrors = new ActionErrors();
            actionErrors.add("errors.classes.notSelected", new ActionError("errors.classes.notSelected"));
            this.saveErrors(request, actionErrors);
            return mapping.getInputForward();
        }
        ArrayList<String> classOIDs = new ArrayList<String>();
        for (String selectedClasse : selectedClasses) {
            classOIDs.add(selectedClasse);
        }
        InfoShift infoShift = (InfoShift)request.getAttribute("shift");
        RemoveClasses.run(infoShift, classOIDs);
        return mapping.findForward("EditShift");
    }

    public ActionForward deleteLessons(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DynaActionForm deleteLessonsForm = (DynaActionForm)form;
        String[] selectedLessons = (String[])deleteLessonsForm.get("selectedItems");
        if (selectedLessons.length == 0) {
            ActionErrors actionErrors = new ActionErrors();
            actionErrors.add("errors.lessons.notSelected", new ActionError("errors.lessons.notSelected"));
            this.saveErrors(request, actionErrors);
            return mapping.getInputForward();
        }
        ArrayList<String> lessonOIDs = new ArrayList<String>();
        for (String selectedLesson : selectedLessons) {
            lessonOIDs.add(selectedLesson);
        }
        try {
            DeleteLessons.run(lessonOIDs);
        }
        catch (FenixServiceMultipleException e) {
            ActionErrors actionErrors = new ActionErrors();
            for (DomainException domainException : e.getExceptionList()) {
                actionErrors.add(domainException.getMessage(), new ActionError(domainException.getMessage(), (Object[])domainException.getArgs()));
            }
            this.saveErrors(request, actionErrors);
        }
        return mapping.findForward("EditShift");
    }

    public ActionForward viewStudentsEnroled(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InfoExecutionCourse infoExecutionCourse;
        List<InfoShift> shifts;
        InfoShift infoShift = (InfoShift)request.getAttribute("shift");
        ShiftKey shiftKey = new ShiftKey(infoShift.getNome(), infoShift.getInfoDisciplinaExecucao());
        List<InfoStudent> students = LerAlunosDeTurno.run(shiftKey);
        Collections.sort(students, new BeanComparator("number"));
        if (students != null && !students.isEmpty()) {
            request.setAttribute("student_list", students);
        }
        if ((shifts = LerTurnosDeDisciplinaExecucao.run(infoExecutionCourse = (InfoExecutionCourse)request.getAttribute("execution_course"))) != null && !shifts.isEmpty()) {
            request.setAttribute("shifts", shifts);
        }
        return mapping.findForward("ViewStudentsEnroled");
    }

    public ActionForward changeStudentsShift(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        User userView = Authenticate.getUser();
        DynaActionForm dynaActionForm = (DynaActionForm)form;
        String oldShiftId = (String)dynaActionForm.get("oldShiftId");
        String newShiftIdString = (String)dynaActionForm.get("newShiftId");
        String[] studentIDs = (String[])dynaActionForm.get("studentIDs");
        HashSet<Registration> registrations = new HashSet<Registration>();
        if (studentIDs != null) {
            for (String studentID : studentIDs) {
                Registration registration = (Registration)FenixFramework.getDomainObject((String)studentID);
                registrations.add(registration);
            }
        }
        ChangeStudentsShift.run(userView, oldShiftId, newShiftIdString, registrations);
        return mapping.findForward("Continue");
    }

    private void readAndSetShiftTypes(HttpServletRequest request, InfoExecutionCourse infoExecutionCourse) {
        ArrayList<LabelValueBean> tiposAula = new ArrayList<LabelValueBean>();
        for (ShiftType shiftType : infoExecutionCourse.getExecutionCourse().getShiftTypes()) {
            tiposAula.add(new LabelValueBean(BundleUtil.getString((String)"resources.EnumerationResources", (String)shiftType.getName(), (String[])new String[0]), shiftType.name()));
        }
        request.setAttribute("tiposAula", tiposAula);
    }

    static List getExecutionCourses(HttpServletRequest request) throws Exception {
        List infoCourseList = new ArrayList();
        InfoCurricularYear infoCurricularYear = (InfoCurricularYear)request.getAttribute("curricular_year");
        InfoExecutionDegree infoExecutionDegree = (InfoExecutionDegree)request.getAttribute("execution_degree");
        AcademicInterval academicInterval = AcademicInterval.getAcademicIntervalFromResumedString((String)request.getAttribute("academicInterval"));
        infoCourseList = LerDisciplinasExecucaoDeLicenciaturaExecucaoEAnoCurricular.run(infoExecutionDegree, academicInterval, infoCurricularYear.getYear());
        request.setAttribute("context.disciplinasExecucao", infoCourseList);
        return infoCourseList;
    }

    @Mapping(path="/manageShiftMultipleItems", module="resourceAllocationManager", input="/manageShift.do?method=prepareEditShift&page=0", formBean="selectMultipleItemsForm", functionality=ExecutionPeriodDA.class)
    @Forwards(value={@Forward(name="EditShift", path="/resourceAllocationManager/manageShift.do?method=prepareEditShift&page=0")})
    public static class ManageShiftMultipleItemsDA
    extends ManageShiftDA {
    }
}

