/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.phd;

import java.util.function.Predicate;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdProcessStateType;
import org.fenixedu.academic.domain.phd.seminar.PublicPresentationSeminarProcessStateType;
import org.fenixedu.academic.util.predicates.InlinePredicate;
import org.fenixedu.academic.util.predicates.OrPredicate;
import org.fenixedu.academic.util.predicates.PredicateContainer;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public enum PhdSeminarPredicateContainer implements PredicateContainer<PhdIndividualProgramProcess>
{
    SEMINAR_PROCESS_STARTED{

        @Override
        public Predicate<PhdIndividualProgramProcess> getPredicate() {
            final PhdSeminarPredicate waitingComissionConstitutionPredicate = new PhdSeminarPredicate(PublicPresentationSeminarProcessStateType.WAITING_FOR_COMMISSION_CONSTITUTION);
            final PhdSeminarPredicate waitingComissionValidationPredicate = new PhdSeminarPredicate(PublicPresentationSeminarProcessStateType.COMMISSION_WAITING_FOR_VALIDATION);
            final PhdSeminarPredicate comissionvalidatedPredicate = new PhdSeminarPredicate(PublicPresentationSeminarProcessStateType.COMMISSION_VALIDATED);
            final PhdSeminarPredicate presentationScheduledPredicate = new PhdSeminarPredicate(PublicPresentationSeminarProcessStateType.PUBLIC_PRESENTATION_DATE_SCHEDULED);
            return new OrPredicate<PhdIndividualProgramProcess>(){
                {
                    this.add((Predicate)waitingComissionConstitutionPredicate);
                    this.add((Predicate)waitingComissionValidationPredicate);
                    this.add((Predicate)comissionvalidatedPredicate);
                    this.add((Predicate)presentationScheduledPredicate);
                }
            };
        }
    }
    ,
    AFTER_FIRST_SEMINAR_REUNION{

        @Override
        public Predicate<PhdIndividualProgramProcess> getPredicate() {
            return new PhdSeminarPredicate(PublicPresentationSeminarProcessStateType.REPORT_WAITING_FOR_VALIDATION){

                @Override
                public boolean test(PhdIndividualProgramProcess process2) {
                    return process2.getThesisProcess() == null && ((PhdSeminarPredicate)this).checkState(process2) && process2.getSeminarProcess().hasState((PhdProcessStateType)this.getValue());
                }
            };
        }
    };


    @Override
    public String getLocalizedName() {
        return BundleUtil.getString((String)"resources.PhdResources", (String)(PhdSeminarPredicateContainer.class.getName() + "." + this.name()), (String[])new String[0]);
    }

    private static class PhdSeminarPredicate
    extends InlinePredicate<PhdIndividualProgramProcess, PublicPresentationSeminarProcessStateType> {
        public PhdSeminarPredicate(PublicPresentationSeminarProcessStateType seminarState) {
            super(seminarState);
        }

        @Override
        public boolean test(PhdIndividualProgramProcess process2) {
            return this.checkState(process2) && this.checkValue(process2);
        }

        private boolean checkState(PhdIndividualProgramProcess process2) {
            return process2.getActiveState().isActive() && process2.getSeminarProcess() != null;
        }

        private boolean checkValue(PhdIndividualProgramProcess process2) {
            return process2.getSeminarProcess().getActiveState().equals(this.getValue());
        }
    }
}

