/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.operator;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.AlumniIdentityCheckRequest;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.service.services.operator.ValidateAlumniIdentity;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.operator.OperatorApplication;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;

@StrutsFunctionality(app=OperatorApplication.class, path="alumni-address-validation", titleKey="alumni.identity.requests", bundle="ManagerResources")
@Mapping(module="operator", path="/alumni")
@Forwards(value={@Forward(name="alumni.closed.identity.requests", path="/operator/alumni/viewClosedIdentityRequests.jsp"), @Forward(name="alumni.view.identity.requests.list", path="/operator/alumni/viewIdentityRequestsList.jsp"), @Forward(name="alumni.validate.request.result", path="/operator/alumni/validateIdentityRequestResult.jsp"), @Forward(name="alumni.validate.request", path="/operator/alumni/validateIdentityRequest.jsp")})
public class AlumniIdentityValidationDA
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward prepareIdentityRequestsList(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("identityRequestsList", AlumniIdentityCheckRequest.readPendingRequests());
        return mapping.findForward("alumni.view.identity.requests.list");
    }

    public ActionForward prepareIdentityValidation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.innerPrepareValidation(mapping, request, (AlumniIdentityCheckRequest)((Object)this.getDomainObject(request, "requestId")), (Person)((Object)this.getDomainObject(request, "personId")));
    }

    private ActionForward innerPrepareValidation(ActionMapping mapping, HttpServletRequest request, AlumniIdentityCheckRequest checkRequest, Person alumniPerson) {
        request.setAttribute("requestBody", (Object)checkRequest);
        request.setAttribute("personBody", (Object)alumniPerson);
        request.setAttribute("operation", (Object)"validate");
        return mapping.findForward("alumni.validate.request");
    }

    public ActionForward showIdentityValidation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("requestBody", this.getDomainObject(request, "requestId"));
        request.setAttribute("personBody", this.getDomainObject(request, "personId"));
        return mapping.findForward("alumni.validate.request");
    }

    public ActionForward confirmIdentity(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AlumniIdentityCheckRequest identityRequest = (AlumniIdentityCheckRequest)((Object)this.getObjectFromViewState("requestBody"));
        ValidateAlumniIdentity.runValidateAlumniIdentity(identityRequest, Boolean.TRUE, this.getLoggedPerson(request));
        request.setAttribute("identityRequestResult", (Object)"identity.validation.ok");
        return mapping.findForward("alumni.validate.request.result");
    }

    public ActionForward refuseIdentity(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AlumniIdentityCheckRequest identityRequest = (AlumniIdentityCheckRequest)((Object)this.getObjectFromViewState("requestBody"));
        ValidateAlumniIdentity.runValidateAlumniIdentity(identityRequest, Boolean.FALSE, this.getLoggedPerson(request));
        request.setAttribute("identityRequestResult", (Object)"identity.validation.nok");
        return mapping.findForward("alumni.validate.request.result");
    }

    public ActionForward viewClosedRequests(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("identityRequestsList", AlumniIdentityCheckRequest.readClosedRequests());
        return mapping.findForward("alumni.closed.identity.requests");
    }

    public ActionForward updateSocialSecurityNumber(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AlumniIdentityCheckRequest checkRequest = (AlumniIdentityCheckRequest)((Object)this.getDomainObject(request, "requestId"));
        Person alumniPerson = (Person)((Object)this.getDomainObject(request, "personId"));
        ValidateAlumniIdentity.runValidateAlumniIdentity(checkRequest, alumniPerson);
        return this.innerPrepareValidation(mapping, request, checkRequest, alumniPerson);
    }
}

