/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.manager.photographs;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Photograph;
import org.fenixedu.academic.dto.photographs.PhotographFilterBean;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.manager.ManagerApplications;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.joda.time.DateTime;

@StrutsFunctionality(app=ManagerApplications.ManagerPeopleApp.class, path="photo-history", titleKey="label.operator.photo.title")
@Mapping(path="/photographs/history", module="manager")
@Forwards(value={@Forward(name="history", path="/manager/photographs/photographHistory.jsp")})
public class PhotographHistoryDA
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward history(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("filter", (Object)new PhotographFilterBean());
        return mapping.findForward("history");
    }

    public ActionForward historyFilter(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PhotographFilterBean filter = (PhotographFilterBean)this.getRenderedObject("historyFilter");
        Set photos = rootDomainObject.getPhotographsSet();
        TreeMap<Person, UserHistory> history = new TreeMap<Person, UserHistory>();
        for (Photograph photograph : photos) {
            if (!filter.accepts(photograph)) continue;
            Person person = photograph.getPerson();
            if (history.containsKey((Object)person)) {
                ((UserHistory)history.get((Object)person)).addPhotograph(photograph);
                continue;
            }
            UserHistory user = new UserHistory(person);
            user.addPhotograph(photograph);
            history.put(person, user);
        }
        request.setAttribute("filter", (Object)new PhotographFilterBean());
        request.setAttribute("history", history.values());
        return mapping.findForward("history");
    }

    public static class UserHistory {
        private final Person person;
        private final SortedSet<Photograph> photographs = new TreeSet<Photograph>();

        public UserHistory(Person person) {
            this.person = person;
        }

        public Person getPerson() {
            return this.person;
        }

        public void addPhotograph(Photograph photograph) {
            this.photographs.add(photograph);
        }

        public Set<Photograph> getPhotographs() {
            return this.photographs;
        }
    }

    public static class DatedRejections {
        private final DateTime date;
        private final List<Photograph> photographs = new ArrayList<Photograph>();

        public DatedRejections(DateTime date) {
            this.date = date;
        }

        public void addPhotograph(Photograph photograph) {
            this.photographs.add(photograph);
        }

        public DateTime getDate() {
            return this.date;
        }

        public List<Photograph> getPhotographs() {
            return this.photographs;
        }
    }
}

