/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.candidacy;

import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.PublicCandidacyHashCode;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcessSelectDegreesBean;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyPersonalDetails;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyState;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityProgram;
import org.fenixedu.academic.domain.caseHandling.Activity;
import org.fenixedu.academic.domain.caseHandling.Process;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.FenixActionForm;
import org.fenixedu.academic.ui.struts.action.casehandling.CaseHandlingDispatchAction;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.commons.spreadsheet.Spreadsheet;
import org.fenixedu.commons.spreadsheet.SpreadsheetXLSExporter;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.jsoup.helper.StringUtil;
import pt.ist.fenixframework.FenixFramework;

public abstract class CandidacyProcessDA
extends CaseHandlingDispatchAction {
    private static final com.google.common.base.Predicate<IndividualCandidacyProcess> IS_CANDIDACY_CANCELED_PREDICATE = new com.google.common.base.Predicate<IndividualCandidacyProcess>(){

        public boolean apply(IndividualCandidacyProcess process2) {
            return !process2.isCandidacyCancelled();
        }
    };
    protected static final com.google.common.base.Predicate<IndividualCandidacyProcess> CAN_EXECUTE_ACTIVITY_PREDICATE = new com.google.common.base.Predicate<IndividualCandidacyProcess>(){

        public boolean apply(IndividualCandidacyProcess process2) {
            return process2.canExecuteActivity(Authenticate.getUser());
        }
    };
    protected final String MESSAGE_YES = "message.yes";
    protected final String MESSAGE_NO = "message.no";
    protected static final DateTimeFormatter dateFormat = DateTimeFormat.forPattern((String)"yyyy/MM/dd");

    protected abstract Class getChildProcessType();

    protected abstract Class getCandidacyPeriodType();

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setExecutionInterval(request);
        return super.execute(mapping, actionForm, request, response);
    }

    @EntryPoint
    public ActionForward intro(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.setStartInformation(actionForm, request, response);
        return this.introForward(mapping);
    }

    protected void setExecutionInterval(HttpServletRequest request) {
        String executionIntervalId = (String)this.getFromRequest(request, "executionIntervalId");
        if (executionIntervalId != null && !StringUtil.isBlank((String)executionIntervalId)) {
            request.setAttribute("executionInterval", (Object)FenixFramework.getDomainObject((String)executionIntervalId));
        }
    }

    protected ExecutionInterval getExecutionInterval(HttpServletRequest request) {
        return (ExecutionInterval)((Object)request.getAttribute("executionInterval"));
    }

    protected boolean hasExecutionInterval(HttpServletRequest request) {
        return this.getExecutionInterval(request) != null;
    }

    protected abstract void setStartInformation(ActionForm var1, HttpServletRequest var2, HttpServletResponse var3);

    protected abstract ActionForward introForward(ActionMapping var1);

    @Override
    public ActionForward listProcesses(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.intro(mapping, form, request, response);
    }

    protected List<Activity> getAllowedActivities(CandidacyProcess process2) {
        List activities = process2.getAllowedActivities(Authenticate.getUser());
        ArrayList<Activity> resultActivities = new ArrayList<Activity>();
        for (Activity activity : activities) {
            if (!activity.isVisibleForAdminOffice().booleanValue()) continue;
            resultActivities.add(activity);
        }
        return resultActivities;
    }

    protected CandidacyProcess getProcess(HttpServletRequest request) {
        return (CandidacyProcess)((Object)super.getProcess(request));
    }

    protected void setCandidacyProcessInformation(HttpServletRequest request, CandidacyProcess process2) {
        if (process2 != null) {
            request.setAttribute("process", (Object)process2);
            request.setAttribute("processActivities", this.getAllowedActivities(process2));
            request.setAttribute("childProcesses", this.getChildProcesses(process2, request));
            request.setAttribute("canCreateChildProcess", this.canCreateProcess(this.getChildProcessType().getName()));
            request.setAttribute("childProcessName", (Object)this.getChildProcessType().getSimpleName());
            request.setAttribute("executionIntervalId", (Object)process2.getCandidacyExecutionInterval().getExternalId());
            request.setAttribute("individualCandidaciesHashCodesNotBounded", this.getIndividualCandidacyHashCodesNotBounded());
            request.setAttribute("hideCancelledCandidacies", (Object)this.getHideCancelledCandidaciesValue(request));
        }
        request.setAttribute("canCreateProcess", this.canCreateProcess(this.getProcessType().getName()));
        request.setAttribute("executionIntervals", ExecutionInterval.readExecutionIntervalsWithCandidacyPeriod(this.getCandidacyPeriodType()));
    }

    protected HideCancelledCandidaciesBean getHideCancelledCandidaciesValue(HttpServletRequest request) {
        Object value = this.getObjectFromViewState("hide.cancelled.candidacies");
        if (value == null) {
            value = this.getFromRequest(request, "hideCancelledCandidacies") != null ? Boolean.valueOf((String)this.getFromRequest(request, "hideCancelledCandidacies")) : null;
        }
        return new HideCancelledCandidaciesBean(value != null ? (Boolean)value : Boolean.FALSE);
    }

    protected com.google.common.base.Predicate<IndividualCandidacyProcess> getChildProcessSelectionPredicate(CandidacyProcess process2, HttpServletRequest request) {
        return Predicates.alwaysTrue();
    }

    protected Collection<IndividualCandidacyProcess> getChildProcesses(CandidacyProcess process2, HttpServletRequest request) {
        HideCancelledCandidaciesBean hideCancelledCandidacies = this.getHideCancelledCandidaciesValue(request);
        com.google.common.base.Predicate predicate = Predicates.and(CAN_EXECUTE_ACTIVITY_PREDICATE, this.getChildProcessSelectionPredicate(process2, request));
        if (hideCancelledCandidacies.getValue().booleanValue()) {
            predicate = Predicates.and(IS_CANDIDACY_CANCELED_PREDICATE, (com.google.common.base.Predicate)predicate);
        }
        return Collections2.filter((Collection)process2.getChildProcessesSet(), (com.google.common.base.Predicate)predicate);
    }

    private List<PublicCandidacyHashCode> getIndividualCandidacyHashCodesNotBounded() {
        ArrayList<PublicCandidacyHashCode> publicCandidacyHashCodeList = new ArrayList<PublicCandidacyHashCode>(CollectionUtils.select((Collection)Bennu.getInstance().getCandidacyHashCodesSet(), (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                PublicCandidacyHashCode hashCode = (PublicCandidacyHashCode)((Object)arg0);
                return hashCode.isFromDegreeOffice() && !hashCode.hasCandidacyProcess();
            }
        }));
        return publicCandidacyHashCodeList;
    }

    protected abstract CandidacyProcess getCandidacyProcess(HttpServletRequest var1, ExecutionInterval var2);

    @Override
    public ActionForward prepareCreateNewProcess(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("candidacyProcessBean", (Object)new CandidacyProcessBean((ExecutionInterval)((Object)ExecutionYear.readCurrentExecutionYear())));
        return mapping.findForward("prepare-create-new-process");
    }

    @Override
    public ActionForward createNewProcess(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        try {
            return super.createNewProcess(mapping, form, request, response);
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
            request.setAttribute("candidacyProcessBean", this.getRenderedObject("candidacyProcessBean"));
            return mapping.findForward("prepare-create-new-process");
        }
    }

    public ActionForward createNewProcessInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("candidacyProcessBean", this.getRenderedObject("candidacyProcessBean"));
        return mapping.findForward("prepare-create-new-process");
    }

    public ActionForward prepareExecuteEditCandidacyPeriod(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        CandidacyProcess process2 = this.getProcess(request);
        request.setAttribute("candidacyProcessBean", (Object)new CandidacyProcessBean(process2));
        return mapping.findForward("prepare-edit-candidacy-period");
    }

    public ActionForward executeEditCandidacyPeriod(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        try {
            this.executeActivity((Process)((Object)this.getProcess(request)), "EditCandidacyPeriod", this.getRenderedObject("candidacyProcessBean"));
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage());
            request.setAttribute("candidacyProcessBean", this.getRenderedObject("candidacyProcessBean"));
            return mapping.findForward("prepare-edit-candidacy-period");
        }
        return this.listProcessAllowedActivities(mapping, actionForm, request, response);
    }

    public ActionForward executeEditCandidacyPeriodInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("candidacyProcessBean", this.getRenderedObject("candidacyProcessBean"));
        return mapping.findForward("prepare-edit-candidacy-period");
    }

    protected String getReportFilename() {
        return BundleUtil.getString((String)"resources.ApplicationResources", (String)("label.candidacy." + this.getProcessType().getSimpleName() + ".report.filename"), (String[])new String[0]) + "_" + new LocalDate().toString("ddMMyyyy") + ".xls";
    }

    protected abstract List<CandidacyDegreeBean> createCandidacyDegreeBeans(HttpServletRequest var1);

    public ActionForward prepareExecuteExportCandidacies(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment; filename=" + this.getReportFilename());
        ServletOutputStream writer = response.getOutputStream();
        this.writeCandidaciesReport(request, this.getProcess(request), writer);
        writer.flush();
        response.flushBuffer();
        return null;
    }

    private void writeCandidaciesReport(HttpServletRequest request, CandidacyProcess process2, ServletOutputStream writer) throws IOException {
        Spreadsheet spreadsheet = new Spreadsheet(BundleUtil.getString((String)"resources.CandidateResources", (String)"title.candidacies", (String[])new String[0]), this.getCandidacyHeader());
        HideCancelledCandidaciesBean hideCancelledCandidacies = this.getHideCancelledCandidaciesValue(request);
        for (IndividualCandidacyProcess individualProcess : process2.getChildProcessesSet()) {
            if (hideCancelledCandidacies.getValue().booleanValue() && individualProcess.isCandidacyCancelled() || !individualProcess.canExecuteActivity(Authenticate.getUser())) continue;
            this.buildIndividualCandidacyReport(spreadsheet, individualProcess);
        }
        new SpreadsheetXLSExporter().exportToXLSSheet(spreadsheet, (OutputStream)writer);
    }

    protected abstract Spreadsheet buildIndividualCandidacyReport(Spreadsheet var1, IndividualCandidacyProcess var2);

    protected List<Object> getCandidacyHeader() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(BundleUtil.getString((String)"resources.CandidateResources", (String)"label.spreadsheet.processCode", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.CandidateResources", (String)"label.spreadsheet.name", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.CandidateResources", (String)"label.spreadsheet.identificationType", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.CandidateResources", (String)"label.spreadsheet.identificationNumber", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.CandidateResources", (String)"label.spreadsheet.nationality", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.CandidateResources", (String)"label.spreadsheet.precedent.institution", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.CandidateResources", (String)"label.spreadsheet.precedent.degree.designation", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.CandidateResources", (String)"label.spreadsheet.precedent.degree.conclusion.date", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.CandidateResources", (String)"label.spreadsheet.precedent.degree.conclusion.grade", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.CandidateResources", (String)"label.spreadsheet.selected.degree", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.CandidateResources", (String)"label.spreadsheet.state", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.CandidateResources", (String)"label.spreadsheet.verified", (String[])new String[0]));
        return result;
    }

    public ActionForward prepareExecuteSelectAvailableDegrees(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        CandidacyProcess process2 = this.getProcess(request);
        CandidacyProcessSelectDegreesBean bean = new CandidacyProcessSelectDegreesBean();
        bean.getDegrees().addAll(process2.getDegreeSet());
        request.setAttribute("candidacyProcessBean", (Object)bean);
        return mapping.findForward("prepare-select-available-degrees");
    }

    public ActionForward executeSelectAvailableDegrees(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        try {
            this.executeActivity((Process)((Object)this.getProcess(request)), "SelectAvailableDegrees", this.getRenderedObject("candidacyProcessBean"));
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage());
            request.setAttribute("candidacyProcessBean", this.getRenderedObject("candidacyProcessBean"));
            return mapping.findForward("prepare-select-available-degrees");
        }
        return this.listProcessAllowedActivities(mapping, actionForm, request, response);
    }

    public static class ChooseDegreeBean
    implements Serializable {
        private static final long serialVersionUID = -7544460988553206034L;
        private Degree degree;
        private CandidacyProcess candidacyProcess;

        public ChooseDegreeBean() {
        }

        public ChooseDegreeBean(CandidacyProcess process2) {
            this.candidacyProcess = process2;
        }

        public Degree getDegree() {
            return this.degree;
        }

        public void setDegree(Degree degree) {
            this.degree = degree;
        }

        public CandidacyProcess getCandidacyProcess() {
            return this.candidacyProcess;
        }

        public void setCandidacyProcess(CandidacyProcess process2) {
            this.candidacyProcess = process2;
        }
    }

    public static class ChooseMobilityProgramBean
    implements Serializable {
        private static final long serialVersionUID = 8772267678901956140L;
        private MobilityProgram mobilityProgram;
        private CandidacyProcess candidacyProcess;

        public ChooseMobilityProgramBean() {
        }

        public ChooseMobilityProgramBean(CandidacyProcess process2) {
            this.candidacyProcess = process2;
        }

        public MobilityProgram getMobilityProgram() {
            return this.mobilityProgram;
        }

        public void setMobilityProgram(MobilityProgram mobilityProgram) {
            this.mobilityProgram = mobilityProgram;
        }

        public CandidacyProcess getCandidacyProcess() {
            return this.candidacyProcess;
        }

        public void setCandidacyProcess(CandidacyProcess process2) {
            this.candidacyProcess = process2;
        }
    }

    public static class CandidacyDegreeBean
    implements Serializable,
    Comparable<CandidacyDegreeBean> {
        private IndividualCandidacyPersonalDetails details;
        private Degree degree;
        private IndividualCandidacyState state;
        private boolean isRegistrationCreated;

        public IndividualCandidacyPersonalDetails getPersonalDetails() {
            return this.details;
        }

        public void setPersonalDetails(IndividualCandidacyPersonalDetails details) {
            this.details = details;
        }

        public Degree getDegree() {
            return this.degree;
        }

        public void setDegree(Degree degree) {
            this.degree = degree;
        }

        public IndividualCandidacyState getState() {
            return this.state;
        }

        public void setState(IndividualCandidacyState state) {
            this.state = state;
        }

        public boolean isRegistrationCreated() {
            return this.isRegistrationCreated;
        }

        public void setRegistrationCreated(boolean isRegistrationCreated) {
            this.isRegistrationCreated = isRegistrationCreated;
        }

        @Override
        public int compareTo(CandidacyDegreeBean other) {
            return IndividualCandidacyPersonalDetails.COMPARATOR_BY_NAME_AND_ID.compare(this.getPersonalDetails(), other.getPersonalDetails());
        }
    }

    public static class CandidacyProcessForm
    extends FenixActionForm {
        private String executionIntervalId;

        public String getExecutionIntervalId() {
            return this.executionIntervalId;
        }

        public void setExecutionIntervalId(String executionIntervalId) {
            this.executionIntervalId = executionIntervalId;
        }
    }

    public static class HideCancelledCandidaciesBean
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Boolean value = Boolean.FALSE;

        public HideCancelledCandidaciesBean(Boolean value) {
            this.value = value;
        }

        public HideCancelledCandidaciesBean() {
        }

        public Boolean getValue() {
            return this.value;
        }

        public Boolean isValue() {
            return this.value;
        }

        public void setValue(Boolean value) {
            this.value = value;
        }

        public Boolean getOptionValue() {
            return this.getValue();
        }

        public void setOptionValue(Boolean value) {
            this.setValue(value);
        }
    }
}

