/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.accounts;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.dto.person.PersonBean;
import org.fenixedu.academic.service.services.person.SearchPerson;
import org.fenixedu.academic.ui.struts.action.accounts.AccountManagementApp;
import org.fenixedu.academic.ui.struts.action.accounts.LoginsManagementDA$callable$deletePeriod;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.util.CollectionPager;
import org.fenixedu.bennu.core.domain.UserLoginPeriod;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@StrutsFunctionality(app=AccountManagementApp.class, path="logins", titleKey="logins.management.title")
@Mapping(module="manager", path="/loginsManagement")
@Forwards(value={@Forward(name="prepareManageLoginTimeIntervals", path="/manager/loginsManagement/manageLoginTimeIntervals.jsp"), @Forward(name="prepareCreateNewLoginTimeInterval", path="/manager/loginsManagement/createNewLoginPeriod.jsp"), @Forward(name="prepareSearchPerson", path="/manager/loginsManagement/searchPersonToManageLogins.jsp"), @Forward(name="prepareEditLoginTimeInterval", path="/manager/loginsManagement/editLoginPeriod.jsp")})
public class LoginsManagementDA
extends FenixDispatchAction {
    public static final Advice advice$deletePeriod = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @EntryPoint
    public ActionForward prepareSearchPerson(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("personBean", (Object)new PersonBean());
        return mapping.findForward("prepareSearchPerson");
    }

    public ActionForward searchPerson(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IViewState viewState = RenderUtils.getViewState((String)"personBeanID");
        PersonBean personBean = (PersonBean)viewState.getMetaObject().getObject();
        SearchPerson.SearchParameters parameters = new SearchPerson.SearchParameters(personBean.getName(), null, personBean.getUsername(), personBean.getDocumentIdNumber(), null, null, null, null, null, null, null, null);
        SearchPerson.SearchPersonPredicate predicate = new SearchPerson.SearchPersonPredicate(parameters);
        CollectionPager<Person> persons = SearchPerson.runSearchPerson(parameters, predicate);
        request.setAttribute("resultPersons", persons.getCollection());
        request.setAttribute("personBean", (Object)personBean);
        return mapping.findForward("prepareSearchPerson");
    }

    public ActionForward prepareManageLoginTimeIntervals(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Person person = this.getPersonFromParameter(request);
        request.setAttribute("person", (Object)person);
        return mapping.findForward("prepareManageLoginTimeIntervals");
    }

    private Person getPersonFromParameter(HttpServletRequest request) {
        String personIDString = request.getParameter("personID");
        return StringUtils.isEmpty((String)personIDString) ? null : (Person)FenixFramework.getDomainObject((String)personIDString);
    }

    public ActionForward prepareEditLoginTimeInterval(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("period", this.getDomainObject(request, "periodID"));
        return mapping.findForward("prepareEditLoginTimeInterval");
    }

    public ActionForward prepareCreateLoginTimeInterval(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("user", this.getDomainObject(request, "userID"));
        return mapping.findForward("prepareCreateNewLoginTimeInterval");
    }

    public ActionForward deleteLoginTimeInterval(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        UserLoginPeriod period = (UserLoginPeriod)this.getDomainObject(request, "periodID");
        request.setAttribute("person", (Object)period.getUser().getPerson());
        this.deletePeriod(period);
        return mapping.findForward("prepareManageLoginTimeIntervals");
    }

    private void deletePeriod(UserLoginPeriod userLoginPeriod) {
        Object object = advice$deletePeriod.perform((Callable)new LoginsManagementDA$callable$deletePeriod(this, userLoginPeriod));
    }

    static /* synthetic */ void advised$deletePeriod(LoginsManagementDA this_, UserLoginPeriod period) {
        period.delete();
    }
}

