/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.spring.controller.teacher.professorship;

import java.util.List;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.TeacherAuthorization;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.ui.spring.controller.AcademicAdministrationSpringApplication;
import org.fenixedu.academic.ui.spring.controller.teacher.authorization.AuthorizationService;
import org.fenixedu.academic.ui.spring.controller.teacher.authorization.SearchBean;
import org.fenixedu.academic.ui.spring.controller.teacher.professorship.CreateProfessorshipBean;
import org.fenixedu.academic.ui.spring.controller.teacher.professorship.ProfessorshipService;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@SpringFunctionality(app=AcademicAdministrationSpringApplication.class, title="teacher.professorships.title", accessGroup="academic(MANAGE_TEACHER_PROFESSORSHIPS)")
@RequestMapping(value={"/teacher/professorships"})
public class ProfessorshipController {
    @Autowired
    private ProfessorshipService professorshipService;
    @Autowired
    private AuthorizationService authorizationService;

    private String view(String string) {
        return "fenixedu-academic/teacher/professorship/" + string;
    }

    @RequestMapping(method={RequestMethod.GET})
    public String home(Model model, @ModelAttribute SearchBean search, @RequestParam(defaultValue="null") TeacherAuthorization authorization) {
        if (search.getPeriod() == null) {
            search.setPeriod(this.authorizationService.getCurrentPeriod());
        }
        model.addAttribute("authorization", (Object)authorization);
        model.addAttribute("departments", this.authorizationService.getDepartments());
        model.addAttribute("periods", this.authorizationService.getExecutionPeriods());
        model.addAttribute("search", (Object)search);
        model.addAttribute("authorizations", this.authorizationService.searchAuthorizations(search));
        return this.view("show");
    }

    @RequestMapping(method={RequestMethod.GET}, value={"{authorization}"})
    public String showCreate(Model model, @PathVariable TeacherAuthorization authorization, @ModelAttribute CreateProfessorshipBean bean) {
        if (bean.getPeriod() == null) {
            bean.setPeriod(authorization.getExecutionSemester());
        }
        List<ExecutionDegree> degrees = this.professorshipService.getDegrees(bean.getPeriod());
        if (bean.getDegree() == null && !degrees.isEmpty()) {
            bean.setDegree(degrees.get(0));
        }
        bean.setCourse(null);
        model.addAttribute("bean", (Object)bean);
        model.addAttribute("authorization", (Object)authorization);
        model.addAttribute("degrees", degrees);
        model.addAttribute("periods", this.authorizationService.getExecutionPeriods(authorization.getTeacher()));
        model.addAttribute("courses", this.professorshipService.getCourses(bean.getDegree(), bean.getPeriod()));
        return this.view("create");
    }

    @RequestMapping(method={RequestMethod.POST}, value={"{authorization}"})
    public String create(Model model, @PathVariable TeacherAuthorization authorization, @ModelAttribute CreateProfessorshipBean bean, RedirectAttributes attrs) {
        try {
            this.professorshipService.create(bean);
            attrs.addAttribute("period", (Object)bean.getPeriod().getExternalId());
            attrs.addAttribute("degree", (Object)bean.getDegree().getExternalId());
            return "redirect:/teacher/professorships/" + authorization.getExternalId();
        }
        catch (DomainException e) {
            model.addAttribute("error", (Object)e.getLocalizedMessage());
            return this.showCreate(model, authorization, bean);
        }
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"{professorship}/{responsibleFor}"})
    @ResponseBody
    public Boolean changeResponsibleFor(@PathVariable Professorship professorship, @PathVariable Boolean responsibleFor) {
        return this.professorshipService.changeResponsibleFor(professorship, responsibleFor);
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"{professorship}"})
    @ResponseBody
    public ResponseEntity<String> deleteProfessorship(@PathVariable Professorship professorship) {
        try {
            this.professorshipService.deleteProfessorship(professorship);
            return new ResponseEntity(HttpStatus.ACCEPTED);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)e.getLocalizedMessage(), HttpStatus.PRECONDITION_FAILED);
        }
    }
}

