/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.report;

import java.io.Serializable;
import java.text.MessageFormat;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.ResidenceEvent;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityEventWithPaymentPlan;
import org.fenixedu.academic.domain.accounting.events.gratuity.StandaloneEnrolmentGratuityEvent;
import org.fenixedu.academic.domain.person.IDDocumentType;
import org.fenixedu.academic.report.FenixReport;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class IRSCustomDeclaration
extends FenixReport {
    private static final long serialVersionUID = 1L;
    private final IRSDeclarationDTO declaration;

    public IRSCustomDeclaration(IRSDeclarationDTO declarationDTO) {
        this.declaration = declarationDTO;
        this.fillReport();
    }

    @Override
    protected void fillReport() {
        this.fillParameters();
    }

    private void fillParameters() {
        this.addParameter("personName", this.declaration.getPersonName());
        this.addParameter("personSocialSecurityNumber", this.declaration.getPersonSocialSecurityNumber());
        this.addParameter("personAddress", this.declaration.getPersonAddress());
        this.addParameter("personAddressArea", this.declaration.getPersonAddressArea());
        this.addParameter("personAddressPostalCode", this.declaration.getPersonAddressPostalCode());
        this.addParameter("studentNumber", this.declaration.getStudentNumber() != null ? this.declaration.getStudentNumber().toString() : null);
        this.addParameter("idDocumentType", this.declaration.getIdDocumentType().getLocalizedName());
        this.addParameter("documentIdNumber", this.declaration.getDocumentIdNumber());
        this.addParameter("civilYear", String.valueOf(this.declaration.getCivilYear()));
        this.addParameter("date", new LocalDate().toString("dd/MM/yyyy", this.getLocale()));
        this.addParameter("gratuityAmount", this.declaration.getGratuityAmount().toPlainString());
        this.addParameter("residenceAmount", this.declaration.getResidenceAmount().toPlainString());
        this.addParameter("otherAmount", this.declaration.getOtherAmount().toPlainString());
        this.addParameter("totalAmount", this.declaration.getTotalAmount().toPlainString());
    }

    @Override
    public String getReportTemplateKey() {
        return this.getClass().getName();
    }

    @Override
    public String getReportFileName() {
        return MessageFormat.format("IRS-{0}-{1}-{2}", String.valueOf(this.declaration.getCivilYear()), this.declaration.getDocumentIdNumber().trim().replace('/', '-').replace('\\', '-'), new DateTime().toString("yyyyMMdd", this.getLocale()));
    }

    public static class IRSDeclarationDTO
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Integer civilYear;
        private Money gratuityAmount = Money.ZERO;
        private Money otherAmount = Money.ZERO;
        private Money residenceAmount = Money.ZERO;
        private String personName;
        private String personSocialSecurityNumber;
        private String personAddress;
        private String personAddressArea;
        private String personAddressPostalCode;
        private Integer studentNumber;
        private IDDocumentType idDocumentType;
        private String documentIdNumber;

        public IRSDeclarationDTO() {
        }

        public IRSDeclarationDTO(Integer civilYear) {
            this();
            this.civilYear = civilYear;
        }

        public IRSDeclarationDTO(Integer year, Person person) {
            this(year);
            this.setPersonAddress(person.getAddress());
            this.setPersonAddressArea(person.getArea());
            this.setPersonAddressPostalCode(person.getPostalCode());
            this.setDocumentIdNumber(person.getDocumentIdNumber());
            this.setPersonName(person.getName());
            this.setIdDocumentType(person.getIdDocumentType());
            this.setPersonSocialSecurityNumber(person.getSocialSecurityNumber());
        }

        public void addGratuityAmount(Money amount) {
            this.gratuityAmount = this.gratuityAmount.add(amount);
        }

        public void addOtherAmount(Money amount) {
            this.otherAmount = this.otherAmount.add(amount);
        }

        public void addResidenceAmount(Money amount) {
            this.residenceAmount = this.residenceAmount.add(amount);
        }

        public Integer getCivilYear() {
            return this.civilYear;
        }

        public void setCivilYear(Integer civilYear) {
            this.civilYear = civilYear;
        }

        public Money getGratuityAmount() {
            return this.gratuityAmount;
        }

        public IRSDeclarationDTO setGratuityAmount(Money gratuityAmount) {
            this.gratuityAmount = gratuityAmount;
            return this;
        }

        public Money getOtherAmount() {
            return this.otherAmount;
        }

        public IRSDeclarationDTO setOtherAmount(Money otherAmount) {
            this.otherAmount = otherAmount;
            return this;
        }

        public Money getResidenceAmount() {
            return this.residenceAmount;
        }

        public String getPersonName() {
            return this.personName;
        }

        public IRSDeclarationDTO setPersonName(String studentName) {
            this.personName = studentName;
            return this;
        }

        public String getPersonAddress() {
            return this.personAddress;
        }

        public IRSDeclarationDTO setPersonAddress(String studentAddress) {
            this.personAddress = studentAddress;
            return this;
        }

        public String getPersonAddressArea() {
            return this.personAddressArea;
        }

        public IRSDeclarationDTO setPersonAddressArea(String studentAddressArea) {
            this.personAddressArea = studentAddressArea;
            return this;
        }

        public String getPersonAddressPostalCode() {
            return this.personAddressPostalCode;
        }

        public IRSDeclarationDTO setPersonAddressPostalCode(String studentAddressPostalCode) {
            this.personAddressPostalCode = studentAddressPostalCode;
            return this;
        }

        public Integer getStudentNumber() {
            return this.studentNumber;
        }

        public IRSDeclarationDTO setStudentNumber(Integer studentNumber) {
            this.studentNumber = studentNumber;
            return this;
        }

        public String getDocumentIdNumber() {
            return this.documentIdNumber;
        }

        public IRSDeclarationDTO setDocumentIdNumber(String studentDocumentIdNumber) {
            this.documentIdNumber = studentDocumentIdNumber;
            return this;
        }

        public IDDocumentType getIdDocumentType() {
            return this.idDocumentType;
        }

        public void setIdDocumentType(IDDocumentType idDocumentType) {
            this.idDocumentType = idDocumentType;
        }

        public String getPersonSocialSecurityNumber() {
            return this.personSocialSecurityNumber;
        }

        public void setPersonSocialSecurityNumber(String personSocialSecurityNumber) {
            this.personSocialSecurityNumber = personSocialSecurityNumber;
        }

        public Money getTotalAmount() {
            return this.getGratuityAmount().add(this.getOtherAmount()).add(this.getResidenceAmount());
        }

        public void addAmount(Event event, int civilYear) {
            if (event instanceof GratuityEventWithPaymentPlan || event instanceof StandaloneEnrolmentGratuityEvent) {
                this.addGratuityAmount(event.getMaxDeductableAmountForLegalTaxes(civilYear));
            } else if (event instanceof ResidenceEvent) {
                this.addResidenceAmount(event.getMaxDeductableAmountForLegalTaxes(civilYear));
            } else {
                this.addOtherAmount(event.getMaxDeductableAmountForLegalTaxes(civilYear));
            }
        }
    }
}

