/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.json.adapters;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.fenixedu.academic.domain.Grouping;
import org.fenixedu.bennu.core.annotation.DefaultJsonAdapter;
import org.fenixedu.bennu.core.json.JsonBuilder;
import org.fenixedu.bennu.core.json.JsonUtils;
import org.fenixedu.bennu.core.json.JsonViewer;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@DefaultJsonAdapter(value=Grouping.class)
public class GroupingJsonAdapter
implements JsonViewer<Grouping> {
    public JsonElement view(Grouping grouping, JsonBuilder ctx) {
        JsonObject object = new JsonObject();
        DateTimeFormatter timeFormatter = DateTimeFormat.forPattern((String)"HH:mm dd/MM/yyyy");
        object.addProperty("externalId", grouping.getExternalId());
        object.addProperty("name", grouping.getName());
        object.addProperty("description", grouping.getProjectDescription());
        object.addProperty("enrolmentBeginDay", (Number)grouping.getEnrolmentBeginDayDateDateTime().getMillis());
        object.addProperty("enrolmentEndDay", (Number)grouping.getEnrolmentEndDayDateDateTime().getMillis());
        object.addProperty("shiftType", grouping.getShiftType() == null ? "" : grouping.getShiftType().toString());
        object.addProperty("atomicEnrolmentPolicy", Boolean.valueOf(grouping.getEnrolmentPolicy().getType() == 1));
        object.addProperty("differentiatedCapacity", grouping.getDifferentiatedCapacity());
        object.addProperty("minimumGroupCapacity", (Number)grouping.getMinimumCapacity());
        object.addProperty("maximumGroupCapacity", (Number)grouping.getMaximumCapacity());
        object.addProperty("idealGroupCapacity", (Number)grouping.getIdealCapacity());
        object.addProperty("maxGroupNumber", (Number)grouping.getGroupMaximumNumber());
        JsonUtils.put((JsonObject)object, (String)"executionCourses", (JsonElement)ctx.view(grouping.getExecutionCourses()));
        return object;
    }
}

