/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.teacher.executionCourse;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.util.WorkingStudentSelectionType;
import org.fenixedu.academic.util.predicates.AndPredicate;
import org.fenixedu.academic.util.predicates.InlinePredicate;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.groups.UserGroup;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class SearchExecutionCourseAttendsBean
implements Serializable {
    private ExecutionCourse executionCourse;
    private Boolean viewPhoto;
    private Collection<Attends.StudentAttendsStateType> attendsStates;
    private Collection<WorkingStudentSelectionType> workingStudentTypes;
    private Collection<DegreeCurricularPlan> degreeCurricularPlans;
    private Collection<Shift> shifts;
    private Collection<Attends> attendsResult;
    private transient Map<Integer, Integer> enrolmentsNumberMap;

    public String getEnumerationResourcesString(String name) {
        return BundleUtil.getString((String)"resources.EnumerationResources", (String)name, (String[])new String[0]);
    }

    public String getApplicationResourcesString(String name) {
        return BundleUtil.getString((String)"resources.ApplicationResources", (String)name, (String[])new String[0]);
    }

    public SearchExecutionCourseAttendsBean(ExecutionCourse executionCourse) {
        this.setExecutionCourse(executionCourse);
        this.setViewPhoto(false);
        this.setAttendsStates(Arrays.asList(Attends.StudentAttendsStateType.values()));
        this.setWorkingStudentTypes(Arrays.asList(WorkingStudentSelectionType.values()));
        this.setShifts(this.getExecutionCourse().getAssociatedShifts());
        this.setDegreeCurricularPlans(this.getExecutionCourse().getAttendsDegreeCurricularPlans());
        this.attendsResult = new ArrayList<Attends>();
    }

    public ExecutionCourse getExecutionCourse() {
        return this.executionCourse;
    }

    public void setExecutionCourse(ExecutionCourse executionCourse) {
        this.executionCourse = executionCourse;
    }

    public Boolean getViewPhoto() {
        return this.viewPhoto;
    }

    public void setViewPhoto(Boolean viewPhoto) {
        this.viewPhoto = viewPhoto;
    }

    public Collection<Attends.StudentAttendsStateType> getAttendsStates() {
        return this.attendsStates;
    }

    public void setAttendsStates(Collection<Attends.StudentAttendsStateType> attendsStates) {
        this.attendsStates = attendsStates;
    }

    public Collection<DegreeCurricularPlan> getDegreeCurricularPlans() {
        ArrayList<DegreeCurricularPlan> dcps = new ArrayList<DegreeCurricularPlan>();
        for (DegreeCurricularPlan degreeCurricularPlan : this.degreeCurricularPlans) {
            dcps.add(degreeCurricularPlan);
        }
        return dcps;
    }

    public void setShifts(Collection<Shift> shifts) {
        ArrayList<Shift> drShifts = new ArrayList<Shift>();
        for (Shift shift : shifts) {
            drShifts.add(shift);
        }
        this.shifts = drShifts;
    }

    public Collection<Shift> getShifts() {
        ArrayList<Shift> shifts = new ArrayList<Shift>();
        for (Shift shift : this.shifts) {
            shifts.add(shift);
        }
        return shifts;
    }

    public void setDegreeCurricularPlans(Collection<DegreeCurricularPlan> degreeCurricularPlans) {
        ArrayList<DegreeCurricularPlan> dcps = new ArrayList<DegreeCurricularPlan>();
        for (DegreeCurricularPlan dcp : degreeCurricularPlans) {
            dcps.add(dcp);
        }
        this.degreeCurricularPlans = dcps;
    }

    public Collection<WorkingStudentSelectionType> getWorkingStudentTypes() {
        return this.workingStudentTypes;
    }

    public void setWorkingStudentTypes(Collection<WorkingStudentSelectionType> workingStudentTypes) {
        this.workingStudentTypes = workingStudentTypes;
    }

    public Collection<Attends> getAttendsResult() {
        ArrayList<Attends> attends = new ArrayList<Attends>();
        for (Attends attendRef : this.attendsResult) {
            attends.add(attendRef);
        }
        return attends;
    }

    public void setAttendsResult(Collection<Attends> atts) {
        ArrayList<Attends> results = new ArrayList<Attends>();
        for (Attends attend : atts) {
            results.add(attend);
        }
        this.attendsResult = results;
    }

    public Map<Integer, Integer> getEnrolmentsNumberMap() {
        return this.enrolmentsNumberMap;
    }

    public void setEnrolmentsNumberMap(Map<Integer, Integer> enrolmentsNumberMap) {
        this.enrolmentsNumberMap = enrolmentsNumberMap;
    }

    public Predicate<Attends> getFilters() {
        ArrayList filters = new ArrayList();
        if (this.getAttendsStates().size() < Attends.StudentAttendsStateType.values().length) {
            filters.add(new InlinePredicate<Attends, Collection<Attends.StudentAttendsStateType>>(this.getAttendsStates()){

                @Override
                public boolean test(Attends attends) {
                    return ((Collection)this.getValue()).contains((Object)attends.getAttendsStateType());
                }
            });
        }
        if (this.getWorkingStudentTypes().size() < WorkingStudentSelectionType.values().length) {
            filters.add(new InlinePredicate<Attends, Collection<WorkingStudentSelectionType>>(this.getWorkingStudentTypes()){

                @Override
                public boolean test(Attends attends) {
                    return ((Collection)this.getValue()).contains((Object)this.getWorkingStudentType(attends));
                }

                private WorkingStudentSelectionType getWorkingStudentType(Attends attends) {
                    if (attends.getRegistration().getStudent().hasWorkingStudentStatuteInPeriod(attends.getExecutionPeriod())) {
                        return WorkingStudentSelectionType.WORKING_STUDENT;
                    }
                    return WorkingStudentSelectionType.NOT_WORKING_STUDENT;
                }
            });
        }
        if (this.shifts.size() < this.getExecutionCourse().getAssociatedShifts().size()) {
            filters.add(new InlinePredicate<Attends, Collection<Shift>>(this.getShifts()){

                @Override
                public boolean test(Attends attends) {
                    for (Shift shift : (Collection)this.getValue()) {
                        if (!shift.getStudentsSet().contains((Object)attends.getRegistration())) continue;
                        return true;
                    }
                    return false;
                }
            });
        }
        if (this.degreeCurricularPlans.size() < this.getExecutionCourse().getAttendsDegreeCurricularPlans().size()) {
            filters.add(new InlinePredicate<Attends, Collection<DegreeCurricularPlan>>(this.getDegreeCurricularPlans()){

                @Override
                public boolean test(Attends attends) {
                    return ((Collection)this.getValue()).contains((Object)attends.getStudentCurricularPlanFromAttends().getDegreeCurricularPlan());
                }
            });
        }
        return new AndPredicate<Attends>(filters);
    }

    public Group getAttendsGroup() {
        ArrayList<Person> persons = new ArrayList<Person>();
        for (Attends attends : this.getAttendsResult()) {
            persons.add(attends.getRegistration().getStudent().getPerson());
        }
        return UserGroup.of(Person.convertToUsers(persons));
    }

    public String getLabel() {
        String attendTypeValues = "";
        String degreeNameValues = "";
        String shiftsValues = "";
        String workingStudentsValues = "";
        for (Attends.StudentAttendsStateType attendType : this.attendsStates) {
            if (!attendTypeValues.isEmpty()) {
                attendTypeValues = attendTypeValues + ", ";
            }
            attendTypeValues = attendTypeValues + this.getEnumerationResourcesString(attendType.getQualifiedName());
        }
        for (DegreeCurricularPlan degree : this.degreeCurricularPlans) {
            if (!degreeNameValues.isEmpty()) {
                degreeNameValues = degreeNameValues + ", ";
            }
            degreeNameValues = degreeNameValues + degree.getName();
        }
        for (Shift shift : this.shifts) {
            if (!shiftsValues.isEmpty()) {
                shiftsValues = shiftsValues + ", ";
            }
            shiftsValues = shiftsValues + shift.getPresentationName();
        }
        for (WorkingStudentSelectionType workingStudent : this.workingStudentTypes) {
            if (!workingStudentsValues.isEmpty()) {
                workingStudentsValues = workingStudentsValues + ", ";
            }
            workingStudentsValues = workingStudentsValues + this.getEnumerationResourcesString(workingStudent.getQualifiedName());
        }
        return String.format("%s : %s \n%s : %s \n%s : %s \n%s", this.getApplicationResourcesString("label.selectStudents"), attendTypeValues, this.getApplicationResourcesString("label.attends.courses"), degreeNameValues, this.getApplicationResourcesString("label.selectShift"), shiftsValues, workingStudentsValues);
    }

    public String getSearchElementsAsParameters() {
        String parameters = "";
        parameters = parameters + "&amp;executionCourse=" + this.getExecutionCourse().getExternalId();
        if (this.viewPhoto.booleanValue()) {
            parameters = parameters + "&amp;viewPhoto=true";
        }
        if (this.getAttendsStates() != null) {
            parameters = parameters + "&amp;attendsStates=";
            for (Attends.StudentAttendsStateType attendsStateType : this.getAttendsStates()) {
                parameters = parameters + attendsStateType.toString() + ":";
            }
        }
        if (this.getWorkingStudentTypes() != null) {
            parameters = parameters + "&amp;workingStudentTypes=";
            for (WorkingStudentSelectionType workingStudentType : this.getWorkingStudentTypes()) {
                parameters = parameters + workingStudentType.toString() + ":";
            }
        }
        if (this.getDegreeCurricularPlans() != null) {
            parameters = parameters + "&amp;degreeCurricularPlans=";
            for (DegreeCurricularPlan degreeCurricularPlan : this.getDegreeCurricularPlans()) {
                parameters = parameters + degreeCurricularPlan.getExternalId() + ":";
            }
        }
        if (this.getShifts() != null) {
            parameters = parameters + "&amp;shifts=";
            for (Shift shift : this.getShifts()) {
                parameters = parameters + shift.getExternalId() + ":";
            }
        }
        return parameters;
    }
}

