/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.student;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.OptionalEnrolment;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degreeStructure.OptionalCurricularCourse;
import org.fenixedu.academic.domain.enrolment.CurriculumModuleMoveWrapper;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;

public class OptionalCurricularCoursesLocationBean
implements Serializable {
    private StudentCurricularPlan studentCurricularPlan;
    private List<EnrolmentLocationBean> enrolmentBeans;
    private List<OptionalEnrolmentLocationBean> optionalEnrolmentBeans;

    public OptionalCurricularCoursesLocationBean(StudentCurricularPlan studentCurricularPlan) {
        this.setStudentCurricularPlan(studentCurricularPlan);
        this.setEnrolmentBeans(new ArrayList<EnrolmentLocationBean>());
        this.setOptionalEnrolmentBeans(new ArrayList<OptionalEnrolmentLocationBean>());
    }

    public StudentCurricularPlan getStudentCurricularPlan() {
        return this.studentCurricularPlan;
    }

    public void setStudentCurricularPlan(StudentCurricularPlan studentCurricularPlan) {
        this.studentCurricularPlan = studentCurricularPlan;
    }

    public List<EnrolmentLocationBean> getEnrolmentBeans() {
        return this.enrolmentBeans;
    }

    public void setEnrolmentBeans(List<EnrolmentLocationBean> enrolmentBeans) {
        this.enrolmentBeans = enrolmentBeans;
    }

    public List<OptionalEnrolmentLocationBean> getOptionalEnrolmentBeans() {
        return this.optionalEnrolmentBeans;
    }

    public void setOptionalEnrolmentBeans(List<OptionalEnrolmentLocationBean> optionalEnrolmentBeans) {
        this.optionalEnrolmentBeans = optionalEnrolmentBeans;
    }

    public void addEnrolment(Enrolment enrolment) {
        if (enrolment.isOptional()) {
            this.getOptionalEnrolmentBeans().add(new OptionalEnrolmentLocationBean((OptionalEnrolment)((Object)enrolment)));
        } else {
            this.getEnrolmentBeans().add(new EnrolmentLocationBean(enrolment));
        }
    }

    public void addEnrolments(Collection<Enrolment> enrolments) {
        for (Enrolment enrolment : enrolments) {
            this.addEnrolment(enrolment);
        }
    }

    public Set<IDegreeModuleToEvaluate> getIDegreeModulesToEvaluate(ExecutionSemester executionPeriod) {
        HashSet<IDegreeModuleToEvaluate> result = new HashSet<IDegreeModuleToEvaluate>();
        for (EnrolmentLocationBean enrolmentLocationBean : this.enrolmentBeans) {
            result.add(CurriculumModuleMoveWrapper.create(enrolmentLocationBean.getCurriculumGroup(this.getStudentCurricularPlan()), executionPeriod));
        }
        for (OptionalEnrolmentLocationBean optionalEnrolmentLocationBean : this.optionalEnrolmentBeans) {
            result.add(CurriculumModuleMoveWrapper.create(optionalEnrolmentLocationBean.getCurriculumGroup(), executionPeriod));
        }
        return result;
    }

    public static class OptionalEnrolmentLocationBean
    implements Serializable {
        private OptionalEnrolment enrolment;
        private CurriculumGroup curriculumGroup;

        public OptionalEnrolmentLocationBean(OptionalEnrolment enrolment) {
            this.setEnrolment(enrolment);
        }

        public OptionalEnrolment getEnrolment() {
            return this.enrolment;
        }

        public void setEnrolment(OptionalEnrolment enrolment) {
            this.enrolment = enrolment;
        }

        public CurriculumGroup getCurriculumGroup() {
            return this.curriculumGroup;
        }

        public void setCurriculumGroup(CurriculumGroup curriculumGroup) {
            this.curriculumGroup = curriculumGroup;
        }

        public StudentCurricularPlan getStudentCurricularPlan() {
            return this.getEnrolment().getStudentCurricularPlan();
        }

        public Student getStudent() {
            return this.getStudentCurricularPlan().getRegistration().getStudent();
        }
    }

    public static class EnrolmentLocationBean
    implements Serializable {
        private Enrolment enrolment;
        private OptionalCurricularCourse optionalCurricularCourse;

        public EnrolmentLocationBean(Enrolment enrolment) {
            this.setEnrolment(enrolment);
        }

        public Enrolment getEnrolment() {
            return this.enrolment;
        }

        public void setEnrolment(Enrolment enrolment) {
            this.enrolment = enrolment;
        }

        public OptionalCurricularCourse getOptionalCurricularCourse() {
            return this.optionalCurricularCourse;
        }

        public void setOptionalCurricularCourse(OptionalCurricularCourse optionalCurricularCourse) {
            this.optionalCurricularCourse = optionalCurricularCourse;
        }

        public CurriculumGroup getCurriculumGroup(StudentCurricularPlan studentCurricularPlan) {
            ArrayList<CurriculumGroup> curriculumGroups = new ArrayList<CurriculumGroup>(studentCurricularPlan.getCurricularCoursePossibleGroupsWithoutNoCourseGroupCurriculumGroups((CurricularCourse)((Object)this.getOptionalCurricularCourse())));
            Collections.sort(curriculumGroups, CurriculumGroup.COMPARATOR_BY_NAME_AND_ID);
            return curriculumGroups.isEmpty() ? null : (CurriculumGroup)((Object)curriculumGroups.iterator().next());
        }

        public StudentCurricularPlan getStudentCurricularPlan() {
            return this.getEnrolment().getStudentCurricularPlan();
        }

        public Student getStudent() {
            return this.getStudentCurricularPlan().getRegistration().getStudent();
        }
    }
}

