/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.resourceAllocationManager;

import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.OccupationPeriodReference;
import org.fenixedu.academic.domain.OccupationPeriodType;
import org.fenixedu.academic.dto.resourceAllocationManager.OccupationPeriodBean;
import org.fenixedu.bennu.core.domain.Bennu;

public class PeriodsManagementBean
implements Serializable {
    private static final long serialVersionUID = -6463983445360741454L;
    private final String availablePeriodTypes;
    private ExecutionYear executionYear;
    private List<OccupationPeriodBean> periods = new ArrayList<OccupationPeriodBean>();
    private List<ExecutionDegree> degrees;
    private OccupationPeriodType newPeriodType;
    private int idCounter = 0;

    public PeriodsManagementBean() {
        this.setExecutionYear(ExecutionYear.readCurrentExecutionYear());
        this.availablePeriodTypes = PeriodsManagementBean.computeAvailablePeriodTypes();
    }

    private static String computeAvailablePeriodTypes() {
        EnumSet<OccupationPeriodType> types = EnumSet.of(OccupationPeriodType.LESSONS);
        if (EvaluationSeason.readNormalSeason() != null && EvaluationSeason.readImprovementSeason() != null) {
            types.add(OccupationPeriodType.EXAMS);
            types.add(OccupationPeriodType.GRADE_SUBMISSION);
        }
        if (EvaluationSeason.readSpecialSeason() != null) {
            types.add(OccupationPeriodType.EXAMS_SPECIAL_SEASON);
            types.add(OccupationPeriodType.GRADE_SUBMISSION_SPECIAL_SEASON);
        }
        return types.stream().map(Enum::name).collect(Collectors.joining(","));
    }

    public String getAvailablePeriodTypes() {
        return this.availablePeriodTypes;
    }

    public Collection<ExecutionYear> getYears() {
        ArrayList<ExecutionYear> years = new ArrayList<ExecutionYear>(Bennu.getInstance().getExecutionYearsSet());
        Collections.sort(years);
        return years;
    }

    public ExecutionYear getExecutionYear() {
        return this.executionYear;
    }

    public void setExecutionYear(ExecutionYear executionYear) {
        this.executionYear = executionYear;
        this.populatePeriodsForExecutionYear();
    }

    public List<OccupationPeriodBean> getPeriods() {
        return this.periods;
    }

    public void setPeriods(List<OccupationPeriodBean> periods) {
        this.periods = periods;
    }

    public List<ExecutionDegree> getDegrees() {
        return this.degrees;
    }

    public void setDegrees(List<ExecutionDegree> degrees) {
        this.degrees = degrees;
    }

    public OccupationPeriodType getNewPeriodType() {
        return this.newPeriodType;
    }

    public void setNewPeriodType(OccupationPeriodType newPeriodType) {
        this.newPeriodType = newPeriodType;
    }

    public OccupationPeriodBean getBeanById(String idStr) {
        final int id = Integer.parseInt(idStr);
        return (OccupationPeriodBean)Iterables.find(this.getPeriods(), (Predicate)new Predicate<OccupationPeriodBean>(){

            public boolean apply(OccupationPeriodBean bean) {
                return bean.getId() == id;
            }
        });
    }

    public void removePeriod(String parameter) {
        OccupationPeriodBean bean = this.getBeanById(parameter);
        this.periods.remove(bean);
        bean.deletePeriod();
    }

    public void addNewBean() {
        this.periods.add(0, new OccupationPeriodBean(this.idCounter++));
    }

    private void populatePeriodsForExecutionYear() {
        this.periods.clear();
        HashMultimap map = HashMultimap.create();
        this.setDegrees(new ArrayList<ExecutionDegree>(this.executionYear.getExecutionDegreesSet()));
        Collections.sort(this.degrees, ExecutionDegree.EXECUTION_DEGREE_COMPARATORY_BY_DEGREE_TYPE_AND_NAME);
        for (ExecutionDegree degree : this.degrees) {
            Set references = degree.getOccupationPeriodReferencesSet();
            for (OccupationPeriodReference reference : references) {
                OccupationPeriodBean bean = null;
                for (OccupationPeriodBean periodBean : map.get((Object)reference.getPeriodType())) {
                    if (!periodBean.getOccupationPeriod().isEqualTo(reference.getOccupationPeriod())) continue;
                    bean = periodBean;
                    break;
                }
                if (bean == null) {
                    bean = new OccupationPeriodBean(reference, this.idCounter++);
                    map.put((Object)reference.getPeriodType(), (Object)bean);
                }
                bean.addReference(reference);
            }
        }
        this.periods.addAll(map.values());
        Collections.sort(this.periods);
    }

    public void duplicatePeriod(String oldId) {
        OccupationPeriodBean bean = this.getBeanById(oldId);
        this.periods.add(bean.duplicate(this.idCounter++, this.newPeriodType));
        Collections.sort(this.periods);
    }

    public void removeNewBean() {
        if (this.periods.iterator().next().getNewObject()) {
            this.periods.remove(0);
        }
    }

    public boolean getHasNewObject() {
        return !this.periods.isEmpty() && this.periods.iterator().next().getNewObject();
    }
}

