/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.phd;

import java.io.Serializable;
import org.fenixedu.academic.dto.alumni.formation.IFormation;
import org.fenixedu.academic.util.Month;
import org.joda.time.DateTimeFieldType;
import org.joda.time.LocalDate;
import org.joda.time.Partial;

public class YearMonth
implements Serializable,
IFormation {
    Integer year;
    Integer firstYear;
    Month month;

    public YearMonth() {
    }

    public YearMonth(int year, int month) {
        this.setYear(year);
        this.setMonth(Month.values()[month - 1]);
    }

    public YearMonth(LocalDate date) {
        this.setYear(date.getYear());
        this.setMonth(Month.values()[date.getMonthOfYear() - 1]);
    }

    public YearMonth(Partial date) {
        this.setYear(date.get(DateTimeFieldType.year()));
        this.setMonth(Month.values()[date.get(DateTimeFieldType.monthOfYear()) - 1]);
    }

    public YearMonth(Integer year, Month month) {
        this.setYear(year);
        this.setMonth(month);
    }

    public Month getMonth() {
        return this.month;
    }

    public int getNumberOfMonth() {
        return this.getMonth().getNumberOfMonth();
    }

    public void setMonth(Month month) {
        this.month = month;
    }

    public Integer getYear() {
        return this.year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public String getYearString() {
        return this.year.toString();
    }

    public void setYearString(String year) {
        this.year = Integer.valueOf(year);
    }

    @Override
    public int getFirstYear() {
        return this.firstYear;
    }

    public void setFirstYear(int firstYear) {
        this.firstYear = firstYear;
    }

    public void addMonth() {
        if (this.getNumberOfMonth() == 12) {
            this.setMonth(Month.values()[0]);
            this.setYear(this.getYear() + 1);
        } else {
            this.setMonth(Month.values()[this.getNumberOfMonth()]);
        }
    }

    public void subtractMonth() {
        if (this.getNumberOfMonth() == 1) {
            this.setMonth(Month.values()[11]);
            this.setYear(this.getYear() - 1);
        } else {
            this.setMonth(Month.values()[this.getNumberOfMonth() - 2]);
        }
    }

    public Partial getPartial() {
        return new Partial().with(DateTimeFieldType.monthOfYear(), this.getNumberOfMonth()).with(DateTimeFieldType.year(), this.getYear().intValue());
    }

    public boolean equals(Object obj) {
        return ((YearMonth)obj).getYear().equals(this.getYear()) && ((YearMonth)obj).getMonth().equals((Object)this.getMonth());
    }
}

