/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto;

import java.util.Calendar;
import java.util.List;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.academic.dto.InfoRoomOccupation;
import org.fenixedu.academic.dto.InfoShift;
import org.fenixedu.academic.dto.InfoShowOccupation;
import org.fenixedu.academic.util.DayType;
import org.fenixedu.academic.util.DiaSemana;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.academic.util.renderer.GanttDiagramEvent;
import org.fenixedu.commons.i18n.I18N;
import org.fenixedu.spaces.domain.occupation.Occupation;
import org.joda.time.Interval;

public class InfoOccupation
extends InfoShowOccupation
implements GanttDiagramEvent {
    Interval interval;
    Occupation occupation;

    public InfoOccupation(Occupation occupation, Interval interval) {
        this.occupation = occupation;
        this.interval = interval;
    }

    @Override
    public InfoShift getInfoShift() {
        return null;
    }

    @Override
    public ShiftType getTipo() {
        return null;
    }

    @Override
    public InfoRoomOccupation getInfoRoomOccupation() {
        return null;
    }

    @Override
    public DiaSemana getDiaSemana() {
        return DiaSemana.fromJodaWeekDay(this.interval.getStart().getDayOfWeek());
    }

    @Override
    public Calendar getInicio() {
        return this.interval.getStart().toCalendar(I18N.getLocale());
    }

    @Override
    public Calendar getFim() {
        return this.interval.getEnd().toCalendar(I18N.getLocale());
    }

    @Override
    public List<Interval> getGanttDiagramEventSortedIntervals() {
        return this.occupation.getIntervals();
    }

    @Override
    public MultiLanguageString getGanttDiagramEventName() {
        return new MultiLanguageString(this.occupation.getSubject());
    }

    @Override
    public int getGanttDiagramEventOffset() {
        return 0;
    }

    @Override
    public String getGanttDiagramEventPeriod() {
        return this.occupation.getSummary();
    }

    @Override
    public String getGanttDiagramEventObservations() {
        return this.occupation.getSpaces().stream().map(space -> space.getName()).collect(Collectors.joining(" "));
    }

    @Override
    public String getGanttDiagramEventIdentifier() {
        return this.occupation.getRequest().getExternalId();
    }

    @Override
    public Integer getGanttDiagramEventMonth() {
        return this.interval.getStart().getMonthOfYear();
    }

    @Override
    public String getGanttDiagramEventUrlAddOns() {
        return null;
    }

    @Override
    public boolean isGanttDiagramEventIntervalsLongerThanOneDay() {
        return false;
    }

    @Override
    public boolean isGanttDiagramEventToMarkWeekendsAndHolidays() {
        return false;
    }

    @Override
    public DayType getGanttDiagramEventDayType(Interval interval) {
        return null;
    }

    public Occupation getOccupation() {
        return this.occupation;
    }

    public String getTitle() {
        return this.occupation.getSubject();
    }

    public String getDescription() {
        return this.occupation.getDescription();
    }

    @Override
    public String getExternalId() {
        return this.occupation.getExternalId();
    }
}

