/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.studentCurriculum;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.ExternalCurricularCourse;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.IEnrolment;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degreeStructure.EctsTableIndex;
import org.fenixedu.academic.domain.degreeStructure.RegimeType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationStateType;
import org.fenixedu.academic.domain.studentCurriculum.CreditsDismissal;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.studentCurriculum.Dismissal;
import org.fenixedu.academic.domain.studentCurriculum.EnrolmentWrapper;
import org.fenixedu.academic.domain.studentCurriculum.ExternalEnrolment_Base;
import org.fenixedu.academic.domain.studentCurriculum.OptionalDismissal;
import org.fenixedu.academic.domain.thesis.Thesis;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import org.joda.time.YearMonthDay;

public class ExternalEnrolment
extends ExternalEnrolment_Base
implements IEnrolment {
    public static final Comparator<ExternalEnrolment> COMPARATOR_BY_NAME = new Comparator<ExternalEnrolment>(){

        @Override
        public int compare(ExternalEnrolment o1, ExternalEnrolment o2) {
            int result = o1.getName().compareTo(o2.getName());
            return result != 0 ? result : o1.getExternalId().compareTo(o2.getExternalId());
        }
    };
    public static final Comparator<ExternalEnrolment> COMPARATOR_BY_EXECUTION_PERIOD_AND_EVALUATION_DATE = new Comparator<ExternalEnrolment>(){

        @Override
        public int compare(ExternalEnrolment o1, ExternalEnrolment o2) {
            ComparatorChain comparatorChain = new ComparatorChain();
            comparatorChain.addComparator(COMPARATOR_BY_EXECUTION_PERIOD_AND_ID);
            comparatorChain.addComparator(COMPARATOR_BY_APPROVEMENT_DATE);
            return comparatorChain.compare((Object)o1, (Object)o2);
        }
    };

    protected ExternalEnrolment() {
        this.setRootDomainObject(Bennu.getInstance());
        this.setCreationDateDateTime(new DateTime());
        if (AccessControl.getPerson() != null) {
            this.setCreatedBy(AccessControl.getPerson().getUsername());
        }
    }

    public ExternalEnrolment(Registration registration, ExternalCurricularCourse externalCurricularCourse, Grade grade, ExecutionSemester executionSemester, YearMonthDay evaluationDate, Double ectsCredits) {
        this();
        this.checkConstraints(registration, externalCurricularCourse, executionSemester, grade, ectsCredits);
        this.checkIfCanCreateExternalEnrolment(registration, externalCurricularCourse);
        this.setRegistration(registration);
        this.setExternalCurricularCourse(externalCurricularCourse);
        this.setGrade(grade);
        this.setExecutionPeriod(executionSemester);
        this.setEvaluationDate(evaluationDate);
        this.setEctsCredits(ectsCredits);
    }

    private void checkIfCanCreateExternalEnrolment(Registration registration, ExternalCurricularCourse externalCurricularCourse) {
        for (ExternalEnrolment externalEnrolment : registration.getExternalEnrolmentsSet()) {
            if (externalEnrolment.getExternalCurricularCourse() != externalCurricularCourse) continue;
            throw new DomainException("error.studentCurriculum.ExternalEnrolment.already.exists.externalEnrolment.for.externalCurricularCourse", externalCurricularCourse.getName());
        }
    }

    private void checkConstraints(Registration registration, ExternalCurricularCourse externalCurricularCourse, ExecutionSemester executionSemester, Grade grade, Double ectsCredits) {
        if (registration == null) {
            throw new DomainException("error.externalEnrolment.student.cannot.be.null", new String[0]);
        }
        if (externalCurricularCourse == null) {
            throw new DomainException("error.externalEnrolment.externalCurricularCourse.cannot.be.null", new String[0]);
        }
        if (executionSemester == null) {
            throw new DomainException("error.externalEnrolment.executionPeriod.cannot.be.null", new String[0]);
        }
        if (grade == null || grade.isEmpty()) {
            throw new DomainException("error.externalEnrolment.invalid.grade", new String[0]);
        }
        if (ectsCredits == null) {
            throw new DomainException("error.externalEnrolment.ectsCredits.cannot.be.null", new String[0]);
        }
    }

    public void edit(Registration registration, Grade grade, ExecutionSemester executionSemester, YearMonthDay evaluationDate, Double ectsCredits) {
        if (registration != this.getRegistration()) {
            this.checkIfCanCreateExternalEnrolment(registration, this.getExternalCurricularCourse());
        }
        this.checkConstraints(registration, this.getExternalCurricularCourse(), executionSemester, grade, ectsCredits);
        this.setRegistration(registration);
        this.setGrade(grade);
        this.setExecutionPeriod(executionSemester);
        this.setEvaluationDate(evaluationDate);
        this.setEctsCredits(ectsCredits);
    }

    @Override
    public MultiLanguageString getName() {
        return new MultiLanguageString(this.getExternalCurricularCourse().getName());
    }

    @Override
    public String getCode() {
        return this.getExternalCurricularCourse().getCode();
    }

    public String getFullPathName() {
        return this.getExternalCurricularCourse().getFullPathName();
    }

    @Override
    public String getDescription() {
        return this.getFullPathName();
    }

    @Override
    public void delete() {
        this.checkRulesToDelete();
        this.setExecutionPeriod(null);
        this.setExternalCurricularCourse(null);
        this.setRegistration(null);
        this.setRootDomainObject(null);
        this.getNotNeedToEnrollCurricularCoursesSet().clear();
        super.deleteDomainObject();
    }

    private void checkRulesToDelete() {
        if (!this.getEnrolmentWrappersSet().isEmpty()) {
            throw new DomainException("error.Enrolment.is.origin.in.some.Equivalence", new String[0]);
        }
    }

    @Override
    public final boolean isApproved() {
        return true;
    }

    @Override
    public final boolean isEnroled() {
        return true;
    }

    @Override
    public final boolean isExternalEnrolment() {
        return true;
    }

    @Override
    public final boolean isEnrolment() {
        return false;
    }

    @Override
    public Integer getFinalGrade() {
        String grade = this.getGradeValue();
        return StringUtils.isEmpty((String)grade) || !StringUtils.isNumeric((String)grade) ? null : Integer.valueOf(grade);
    }

    @Override
    public final ExecutionYear getExecutionYear() {
        return this.getExecutionPeriod() != null ? this.getExecutionPeriod().getExecutionYear() : null;
    }

    @Override
    public final YearMonthDay getApprovementDate() {
        return this.getEvaluationDate() == null && this.hasExecutionPeriod() ? this.getExecutionPeriod().getEndDateYearMonthDay() : this.getEvaluationDate();
    }

    @Override
    public Unit getAcademicUnit() {
        return this.getExternalCurricularCourse().getAcademicUnit();
    }

    @Override
    public String getGradeValue() {
        return this.getGrade().getValue();
    }

    @Override
    public Grade getEctsGrade(StudentCurricularPlan scp, DateTime processingDate) {
        Grade grade = this.getGrade();
        HashSet<Dismissal> dismissals = new HashSet<Dismissal>();
        for (EnrolmentWrapper wrapper : this.getEnrolmentWrappersSet()) {
            if (!wrapper.getCredits().getStudentCurricularPlan().equals((Object)scp)) continue;
            for (Dismissal dismissal : wrapper.getCredits().getDismissalsSet()) {
                dismissals.add(dismissal);
            }
        }
        Dismissal dismissal = (Dismissal)dismissals.iterator().next();
        if (dismissals.size() == 1) {
            if (dismissal instanceof OptionalDismissal || dismissal instanceof CreditsDismissal) {
                return EctsTableIndex.convertGradeToEcts(scp.getDegree(), (CurriculumLine)((Object)dismissal), grade, processingDate);
            }
            CurricularCourse curricularCourse = dismissal.getCurricularCourse();
            if (curricularCourse != null) {
                return EctsTableIndex.convertGradeToEcts(curricularCourse, (CurriculumLine)((Object)dismissal), grade, processingDate);
            }
            return EctsTableIndex.convertGradeToEcts(scp.getDegree(), (CurriculumLine)((Object)dismissal), grade, processingDate);
        }
        return EctsTableIndex.convertGradeToEcts(scp.getDegree(), (CurriculumLine)((Object)dismissal), grade, processingDate);
    }

    @Override
    public final BigDecimal getEctsCreditsForCurriculum() {
        return BigDecimal.valueOf(this.getEctsCredits());
    }

    @Override
    public Double getWeigth() {
        return this.getEctsCredits();
    }

    @Override
    public final BigDecimal getWeigthForCurriculum() {
        return BigDecimal.valueOf(this.getWeigth());
    }

    @Override
    public Thesis getThesis() {
        return null;
    }

    public boolean isResultOfMobility() {
        if (!this.hasExecutionPeriod()) {
            return false;
        }
        return this.getRegistration().getRegistrationStatesTypes(this.getExecutionYear()).contains((Object)RegistrationStateType.MOBILITY);
    }

    @Override
    public boolean isAnual() {
        return this.getRegime() != null ? this.getRegime() == RegimeType.ANUAL : false;
    }

    @Override
    public String getEnrolmentTypeName() {
        return "COMPULSORY_ENROLMENT";
    }

    @Override
    public MultiLanguageString getPresentationName() {
        return this.getName();
    }

    @Deprecated
    public Date getCreationDate() {
        DateTime dt = this.getCreationDateDateTime();
        return dt == null ? null : new Date(dt.getMillis());
    }

    @Deprecated
    public void setCreationDate(Date date) {
        if (date == null) {
            this.setCreationDateDateTime(null);
        } else {
            this.setCreationDateDateTime(new DateTime(date.getTime()));
        }
    }

    @Override
    public boolean hasExecutionPeriod() {
        return this.getExecutionPeriod() != null;
    }
}

