/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.studentCurriculum;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.IEnrolment;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.curriculum.Curriculum;
import org.fenixedu.academic.domain.student.curriculum.ICurriculumEntry;
import org.fenixedu.academic.domain.studentCurriculum.Credits_Base;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.Dismissal;
import org.fenixedu.academic.domain.studentCurriculum.EnrolmentWrapper;
import org.fenixedu.academic.dto.administrativeOffice.dismissal.DismissalBean;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.CreditsPredicates;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;

public class Credits
extends Credits_Base {
    public Credits() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public Credits(StudentCurricularPlan studentCurricularPlan, Collection<DismissalBean.SelectedCurricularCourse> dismissals, Collection<IEnrolment> enrolments, ExecutionSemester executionSemester) {
        this();
        this.init(studentCurricularPlan, dismissals, enrolments, executionSemester);
    }

    public Credits(StudentCurricularPlan studentCurricularPlan, CourseGroup courseGroup, Collection<IEnrolment> enrolments, Collection<CurricularCourse> noEnrolCurricularCourses, Double credits, ExecutionSemester executionSemester) {
        this();
        this.init(studentCurricularPlan, courseGroup, enrolments, noEnrolCurricularCourses, credits, executionSemester);
    }

    public Credits(StudentCurricularPlan studentCurricularPlan, CurriculumGroup curriculumGroup, Collection<IEnrolment> enrolments, Double credits, ExecutionSemester executionSemester) {
        this();
        this.init(studentCurricularPlan, curriculumGroup, enrolments, new HashSet<CurricularCourse>(0), credits, executionSemester);
    }

    protected final void initExecutionPeriod(ExecutionSemester executionSemester) {
        if (executionSemester == null) {
            throw new DomainException("error.credits.wrong.arguments", new String[0]);
        }
        this.setExecutionPeriod(executionSemester);
    }

    protected void init(StudentCurricularPlan studentCurricularPlan, CourseGroup courseGroup, Collection<IEnrolment> enrolments, Collection<CurricularCourse> noEnrolCurricularCourses, Double credits, ExecutionSemester executionSemester) {
        if (studentCurricularPlan == null || courseGroup == null || credits == null) {
            throw new DomainException("error.credits.wrong.arguments", new String[0]);
        }
        this.checkGivenCredits(studentCurricularPlan, courseGroup, credits, executionSemester);
        this.initExecutionPeriod(executionSemester);
        this.setStudentCurricularPlan(studentCurricularPlan);
        this.setGivenCredits(credits);
        this.addEnrolments(enrolments);
        Dismissal.createNewDismissal(this, studentCurricularPlan, courseGroup, noEnrolCurricularCourses);
    }

    protected void init(StudentCurricularPlan studentCurricularPlan, CurriculumGroup curriculumGroup, Collection<IEnrolment> enrolments, Collection<CurricularCourse> noEnrolCurricularCourses, Double credits, ExecutionSemester executionSemester) {
        if (studentCurricularPlan == null || curriculumGroup == null || credits == null) {
            throw new DomainException("error.credits.wrong.arguments", new String[0]);
        }
        this.initExecutionPeriod(executionSemester);
        this.setStudentCurricularPlan(studentCurricularPlan);
        this.setGivenCredits(credits);
        this.addEnrolments(enrolments);
        Dismissal.createNewDismissal(this, studentCurricularPlan, curriculumGroup, noEnrolCurricularCourses);
    }

    private void checkGivenCredits(StudentCurricularPlan studentCurricularPlan, CourseGroup courseGroup, Double credits, ExecutionSemester executionSemester) {
        if (courseGroup.isBolonhaDegree() && !this.allowsEctsCredits(studentCurricularPlan, courseGroup, executionSemester, credits)) {
            throw new DomainException("error.credits.invalid.credits", credits.toString());
        }
    }

    private boolean allowsEctsCredits(StudentCurricularPlan studentCurricularPlan, CourseGroup courseGroup, ExecutionSemester executionSemester, double ectsCredits) {
        double ectsCreditsForCourseGroup = studentCurricularPlan.getCreditsConcludedForCourseGroup(courseGroup);
        if (ectsCredits + ectsCreditsForCourseGroup > courseGroup.getMaxEctsCredits(executionSemester)) {
            return false;
        }
        if (courseGroup.isCycleCourseGroup() || courseGroup.isRoot()) {
            return true;
        }
        for (Context context : courseGroup.getParentContextsSet()) {
            if (!context.isOpen(executionSemester) || !this.allowsEctsCredits(studentCurricularPlan, context.getParentCourseGroup(), executionSemester, ectsCredits)) continue;
            return true;
        }
        return false;
    }

    protected void init(StudentCurricularPlan studentCurricularPlan, Collection<DismissalBean.SelectedCurricularCourse> dismissals, Collection<IEnrolment> enrolments, ExecutionSemester executionSemester) {
        if (studentCurricularPlan == null || dismissals == null || dismissals.isEmpty()) {
            throw new DomainException("error.credits.wrong.arguments", new String[0]);
        }
        this.initExecutionPeriod(executionSemester);
        this.setStudentCurricularPlan(studentCurricularPlan);
        this.addEnrolments(enrolments);
        for (DismissalBean.SelectedCurricularCourse selectedCurricularCourse : dismissals) {
            if (selectedCurricularCourse.isOptional()) {
                DismissalBean.SelectedOptionalCurricularCourse selectedOptionalCurricularCourse = (DismissalBean.SelectedOptionalCurricularCourse)selectedCurricularCourse;
                Dismissal.createNewOptionalDismissal(this, studentCurricularPlan, selectedOptionalCurricularCourse.getCurriculumGroup(), selectedOptionalCurricularCourse.getCurricularCourse(), selectedOptionalCurricularCourse.getCredits());
                continue;
            }
            Dismissal.createNewDismissal(this, studentCurricularPlan, selectedCurricularCourse.getCurriculumGroup(), selectedCurricularCourse.getCurricularCourse());
        }
    }

    private void addEnrolments(Collection<IEnrolment> enrolments) {
        if (enrolments != null) {
            for (IEnrolment enrolment : enrolments) {
                EnrolmentWrapper.create(this, enrolment);
            }
        }
    }

    protected static boolean isBefore(IEnrolment enrolment, ExecutionYear year) {
        return year == null || enrolment.getExecutionYear() == null || enrolment.getExecutionYear().isBefore(year);
    }

    protected Set<EnrolmentWrapper> getEnrolmentsSetBefore(ExecutionYear executionYear) {
        HashSet result = Sets.newHashSet();
        for (EnrolmentWrapper wrapper : this.getEnrolmentsSet()) {
            IEnrolment enrolment = wrapper.getIEnrolment();
            if (enrolment == null || !Credits.isBefore(enrolment, executionYear)) continue;
            result.add(wrapper);
        }
        return result;
    }

    public final Collection<IEnrolment> getIEnrolments() {
        HashSet<IEnrolment> result = new HashSet<IEnrolment>();
        for (EnrolmentWrapper enrolmentWrapper : this.getEnrolmentsSet()) {
            IEnrolment enrolment = enrolmentWrapper.getIEnrolment();
            if (enrolment == null) continue;
            result.add(enrolmentWrapper.getIEnrolment());
        }
        return result;
    }

    public final boolean hasIEnrolments(IEnrolment iEnrolment) {
        for (EnrolmentWrapper enrolmentWrapper : this.getEnrolmentsSet()) {
            if (enrolmentWrapper.getIEnrolment() != iEnrolment) continue;
            return true;
        }
        return false;
    }

    public final boolean hasAnyIEnrolments() {
        return !this.getEnrolmentsSet().isEmpty();
    }

    public final Double getGivenCredits() {
        if (super.getGivenCredits() == null) {
            BigDecimal bigDecimal = BigDecimal.ZERO;
            for (Dismissal dismissal : this.getDismissalsSet()) {
                bigDecimal = bigDecimal.add(new BigDecimal(dismissal.getEctsCredits()));
            }
            return bigDecimal.doubleValue();
        }
        return super.getGivenCredits();
    }

    public String getGivenGrade() {
        return null;
    }

    public Grade getGrade() {
        return null;
    }

    public final void delete() {
        AccessControl.check(this, CreditsPredicates.DELETE);
        this.disconnect();
        super.deleteDomainObject();
    }

    protected void disconnect() {
        while (!this.getDismissalsSet().isEmpty()) {
            ((Dismissal)this.getDismissalsSet().iterator().next()).deleteFromCredits();
        }
        while (!this.getEnrolmentsSet().isEmpty()) {
            ((EnrolmentWrapper)((Object)this.getEnrolmentsSet().iterator().next())).delete();
        }
        this.setStudentCurricularPlan(null);
        this.setRootDomainObject(null);
        this.setExecutionPeriod(null);
    }

    public final Double getEnrolmentsEcts() {
        Double result = 0.0;
        for (IEnrolment enrolment : this.getIEnrolments()) {
            result = result + enrolment.getEctsCredits();
        }
        return result;
    }

    public final boolean hasGivenCredits() {
        return this.getGivenCredits() != null;
    }

    public final boolean hasGivenCredits(Double ectsCredits) {
        return this.hasGivenCredits() && this.getGivenCredits().equals(ectsCredits);
    }

    public boolean isTemporary() {
        return false;
    }

    public boolean isCredits() {
        return true;
    }

    public boolean isSubstitution() {
        return false;
    }

    public boolean isInternalSubstitution() {
        return false;
    }

    public boolean isEquivalence() {
        return false;
    }

    public boolean hasAnyDismissalInCurriculum() {
        for (Dismissal dismissal : this.getDismissalsSet()) {
            if (dismissal.parentCurriculumGroupIsNoCourseGroupCurriculumGroup()) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyDismissalInCycle(CycleType cycleType) {
        for (Dismissal dismissal : this.getDismissalsSet()) {
            CycleCurriculumGroup cycle = dismissal.getParentCycleCurriculumGroup();
            if (cycle == null || !cycle.getCycleType().equals((Object)cycleType)) continue;
            return true;
        }
        return false;
    }

    protected Curriculum getCurriculum(Dismissal dismissal, DateTime when, ExecutionYear year) {
        return new Curriculum((CurriculumModule)((Object)dismissal), year, Collections.emptySet(), this.getAverageEntries(dismissal, year), Collections.singleton(dismissal));
    }

    protected Collection<ICurriculumEntry> getAverageEntries(Dismissal dismissal, ExecutionYear executionYear) {
        return Collections.emptyList();
    }

    public String getDescription() {
        return BundleUtil.getString((String)"resources.StudentResources", (String)"label.dismissal.Credits", (String[])new String[0]);
    }

    public boolean isAllEnrolmentsAreExternal() {
        if (this.getEnrolmentsSet().isEmpty()) {
            return false;
        }
        for (EnrolmentWrapper wrapper : this.getEnrolmentsSet()) {
            if (wrapper.getIEnrolment().isExternalEnrolment()) continue;
            return false;
        }
        return true;
    }
}

