/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.fenixedu.academic.domain.AcademicProgram;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.events.serviceRequests.AcademicServiceRequestEvent;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.documents.GeneratedDocument;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest$callable$cancel;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest$callable$conclude;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest$callable$delivered;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest$callable$process;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest$callable$receivedFromExternalEntity;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest$callable$reject;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest$callable$sendToExternalEntity;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequestSituation;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequestSituationType;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequestYear;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest_Base;
import org.fenixedu.academic.domain.serviceRequests.IAcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.ServiceRequestType;
import org.fenixedu.academic.domain.serviceRequests.SpecialSeasonRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.AcademicServiceRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequest;
import org.fenixedu.academic.domain.treasury.IAcademicServiceRequestAndAcademicTaxTreasuryEvent;
import org.fenixedu.academic.domain.treasury.TreasuryBridgeAPIFactory;
import org.fenixedu.academic.domain.util.email.Message;
import org.fenixedu.academic.domain.util.email.Recipient;
import org.fenixedu.academic.domain.util.email.ReplyTo;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.academic.dto.serviceRequests.AcademicServiceRequestBean;
import org.fenixedu.academic.dto.serviceRequests.AcademicServiceRequestCreateBean;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.UserGroup;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.signals.DomainObjectEvent;
import org.fenixedu.bennu.signals.Signal;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.YearMonthDay;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public abstract class AcademicServiceRequest
extends AcademicServiceRequest_Base
implements IAcademicServiceRequest {
    private static final String SERVICE_REQUEST_NUMBER_YEAR_SEPARATOR = "/";
    public static final Comparator<AcademicServiceRequest> COMPARATOR_BY_NUMBER;
    public static final Comparator<AcademicServiceRequest> EXECUTION_YEAR_COMPARATOR;
    public static final Comparator<AcademicServiceRequest> EXECUTION_YEAR_AND_OID_COMPARATOR;
    public static final Advice advice$process;
    public static final Advice advice$sendToExternalEntity;
    public static final Advice advice$receivedFromExternalEntity;
    public static final Advice advice$reject;
    public static final Advice advice$cancel;
    public static final Advice advice$conclude;
    public static final Advice advice$delivered;

    protected AcademicServiceRequest() {
        super.setRootDomainObject(Bennu.getInstance());
    }

    protected void init(AcademicServiceRequestCreateBean bean, AdministrativeOffice office) {
        this.checkParameters(bean);
        super.setAdministrativeOffice(office);
        super.setAcademicServiceRequestYear(AcademicServiceRequestYear.readByYear(bean.getRequestDate().year().get(), true));
        super.setServiceRequestNumber(this.getAcademicServiceRequestYear().generateServiceRequestNumber());
        super.setRequestDate(bean.getRequestDate());
        super.setRequestedCycle(bean.getRequestedCycle());
        super.setDetailed(bean.getDetailed());
        if (bean.getHasCycleTypeDependency()) {
            if (bean.getRequestedCycle() == null) {
                throw new DomainException("error.registryDiploma.requestedCycleMustBeGiven", new String[0]);
            }
            if (!bean.getRegistration().getDegreeType().getCycleTypes().contains((Object)bean.getRequestedCycle())) {
                throw new DomainException("error.registryDiploma.requestedCycleTypeIsNotAllowedForGivenStudentCurricularPlan", new String[0]);
            }
            super.setRequestedCycle(bean.getRequestedCycle());
        } else if (bean.getRegistration().getDegreeType().hasExactlyOneCycleType()) {
            super.setRequestedCycle(bean.getRegistration().getDegreeType().getCycleType());
        }
        super.setUrgentRequest(bean.getUrgentRequest());
        super.setFreeProcessed(bean.getFreeProcessed());
        super.setExecutionYear(bean.getExecutionYear());
        super.setLanguage(bean.getLanguage());
        this.setServiceRequestType(ServiceRequestType.findUnique(this));
        AcademicServiceRequestBean situationBean = new AcademicServiceRequestBean(AcademicServiceRequestSituationType.NEW, AccessControl.getPerson());
        situationBean.setSituationDate(this.getRequestDate().toYearMonthDay());
        this.createAcademicServiceRequestSituations(situationBean);
    }

    private int getServiceRequestYear() {
        return this.getAcademicServiceRequestYear().getYear();
    }

    private void checkParameters(AcademicServiceRequestCreateBean bean) {
        if (bean.getRequestDate() == null || bean.getRequestDate().isAfterNow()) {
            throw new DomainException("error.serviceRequests.AcademicServiceRequest.invalid.requestDate", new String[0]);
        }
        if (bean.getUrgentRequest() == null) {
            throw new DomainException("error.serviceRequests.AcademicServiceRequest.urgentRequest.cannot.be.null", new String[0]);
        }
        if (bean.getFreeProcessed() == null) {
            throw new DomainException("error.serviceRequests.AcademicServiceRequest.freeProcessed.cannot.be.null", new String[0]);
        }
        if (bean.getLanguage() == null) {
            throw new DomainException("error.serviceRequests.AcademicServiceRequest.language.cannot.be.null", new String[0]);
        }
    }

    public final void setUrgentRequest(Boolean urgentRequest) {
        throw new DomainException("error.serviceRequests.AcademicServiceRequest.cannot.modify.urgentRequest", new String[0]);
    }

    public final void setFreeProcessed(Boolean freeProcessed) {
        throw new DomainException("error.serviceRequests.AcademicServiceRequest.cannot.modify.freeProcessed", new String[0]);
    }

    public final void setExecutionYear(ExecutionYear executionYear) {
        throw new DomainException("error.serviceRequests.AcademicServiceRequest.cannot.modify.executionYear", new String[0]);
    }

    public final void setRequestDate(DateTime requestDate) {
        super.setRequestDate(requestDate);
    }

    @Override
    public boolean isUrgentRequest() {
        return this.getUrgentRequest();
    }

    public boolean isFreeProcessed() {
        return this.getFreeProcessed();
    }

    public boolean isFree() {
        return !this.isPayable() || this.isFreeProcessed();
    }

    protected final boolean isPayable() {
        return ServiceRequestType.findUnique(this) != null && ServiceRequestType.findUnique(this).isPayable();
    }

    protected boolean isPayed() {
        if (!this.isPayable()) {
            return true;
        }
        IAcademicServiceRequestAndAcademicTaxTreasuryEvent event = TreasuryBridgeAPIFactory.implementation().academicTreasuryEventForAcademicServiceRequest(this);
        return event != null && event.isPayed();
    }

    public final boolean getIsPayed() {
        return this.isPayed();
    }

    public abstract boolean isPayedUponCreation();

    public boolean isPaymentsAccessible() {
        return AcademicAccessRule.getProgramsAccessibleToFunction(AcademicOperationType.MANAGE_STUDENT_PAYMENTS, Authenticate.getUser()).collect(Collectors.toSet()).contains((Object)this.getAcademicProgram()) && TreasuryBridgeAPIFactory.implementation().academicTreasuryEventForAcademicServiceRequest(this) != null;
    }

    public String getPaymentURL() {
        IAcademicServiceRequestAndAcademicTaxTreasuryEvent event = TreasuryBridgeAPIFactory.implementation().academicTreasuryEventForAcademicServiceRequest(this);
        return event != null ? event.getDebtAccountURL() : null;
    }

    public boolean isRegistrationAccessible() {
        return AcademicAccessRule.getProgramsAccessibleToFunction(AcademicOperationType.MANAGE_REGISTRATIONS, Authenticate.getUser()).collect(Collectors.toSet()).contains((Object)this.getAcademicProgram());
    }

    protected String getDescription(AcademicServiceRequestType academicServiceRequestType, String specificServiceType) {
        StringBuilder result = new StringBuilder();
        if (this.getServiceRequestType() != null && !this.getServiceRequestType().isLegacy()) {
            return this.getServiceRequestType().getName().getContent();
        }
        result.append(BundleUtil.getString((String)"resources.EnumerationResources", (String)academicServiceRequestType.getQualifiedName(), (String[])new String[0]));
        if (specificServiceType != null) {
            result.append(": ");
            result.append(BundleUtil.getString((String)"resources.EnumerationResources", (String)specificServiceType, (String[])new String[0]));
        }
        return result.toString();
    }

    protected String getDescription(AcademicServiceRequestType academicServiceRequestType) {
        return this.getDescription(academicServiceRequestType, null);
    }

    @Override
    public String getDescription() {
        return this.getDescription(this.getAcademicServiceRequestType());
    }

    public final void process() throws DomainException {
        Object object = advice$process.perform((Callable)new AcademicServiceRequest$callable$process(this));
    }

    static final /* synthetic */ void advised$process(AcademicServiceRequest this_) throws DomainException {
        this_.process(AccessControl.getPerson());
        Signal.emit((String)"ACADEMIC_SERVICE_REQUEST_NEW_SITUATION_EVENT", (Object)new DomainObjectEvent((DomainObject)this_));
    }

    public final void process(Person responsible) throws DomainException {
        this.edit(new AcademicServiceRequestBean(AcademicServiceRequestSituationType.PROCESSING, responsible));
    }

    public final void process(Person responsible, YearMonthDay situationDate) throws DomainException {
        this.edit(new AcademicServiceRequestBean(AcademicServiceRequestSituationType.PROCESSING, responsible, situationDate, ""));
    }

    public final void process(YearMonthDay situationDate) throws DomainException {
        this.process(AccessControl.getPerson(), situationDate);
    }

    public void sendToExternalEntity(YearMonthDay yearMonthDay, String string) {
        Object object = advice$sendToExternalEntity.perform((Callable)new AcademicServiceRequest$callable$sendToExternalEntity(this, yearMonthDay, string));
    }

    static /* synthetic */ void advised$sendToExternalEntity(AcademicServiceRequest this_, YearMonthDay sendDate, String description) {
        this_.edit(new AcademicServiceRequestBean(AcademicServiceRequestSituationType.SENT_TO_EXTERNAL_ENTITY, AccessControl.getPerson(), sendDate, description));
    }

    public final void receivedFromExternalEntity(YearMonthDay yearMonthDay, String string) {
        Object object = advice$receivedFromExternalEntity.perform((Callable)new AcademicServiceRequest$callable$receivedFromExternalEntity(this, yearMonthDay, string));
    }

    static final /* synthetic */ void advised$receivedFromExternalEntity(AcademicServiceRequest this_, YearMonthDay receivedDate, String description) {
        this_.edit(new AcademicServiceRequestBean(AcademicServiceRequestSituationType.RECEIVED_FROM_EXTERNAL_ENTITY, AccessControl.getPerson(), receivedDate, description));
        Signal.emit((String)"ACADEMIC_SERVICE_REQUEST_NEW_SITUATION_EVENT", (Object)new DomainObjectEvent((DomainObject)this_));
    }

    public final void reject(String string) {
        Object object = advice$reject.perform((Callable)new AcademicServiceRequest$callable$reject(this, string));
    }

    static final /* synthetic */ void advised$reject(AcademicServiceRequest this_, String justification) {
        this_.edit(new AcademicServiceRequestBean(AcademicServiceRequestSituationType.REJECTED, AccessControl.getPerson(), justification));
        Signal.emit((String)"ACADEMIC_SERVICE_REQUEST_REJECT_OR_CANCEL_EVENT", (Object)new DomainObjectEvent((DomainObject)this_));
    }

    public final void cancel(String string) {
        Object object = advice$cancel.perform((Callable)new AcademicServiceRequest$callable$cancel(this, string));
    }

    static final /* synthetic */ void advised$cancel(AcademicServiceRequest this_, String justification) {
        this_.edit(new AcademicServiceRequestBean(AcademicServiceRequestSituationType.CANCELLED, AccessControl.getPerson(), justification));
        Signal.emit((String)"ACADEMIC_SERVICE_REQUEST_REJECT_OR_CANCEL_EVENT", (Object)new DomainObjectEvent((DomainObject)this_));
    }

    public final void concludeServiceRequest() {
        this.conclude(AccessControl.getPerson());
    }

    @Deprecated
    public final void conclude() {
        this.conclude(AccessControl.getPerson());
    }

    @Deprecated
    public final void conclude(Person responsible) {
        this.edit(new AcademicServiceRequestBean(AcademicServiceRequestSituationType.CONCLUDED, responsible));
    }

    @Deprecated
    public final void conclude(YearMonthDay situationDate, String justification) {
        this.conclude(AccessControl.getPerson(), situationDate, justification);
        Signal.emit((String)"ACADEMIC_SERVICE_REQUEST_NEW_SITUATION_EVENT", (Object)new DomainObjectEvent((DomainObject)this));
    }

    @Deprecated
    public final void conclude(Person responsible, YearMonthDay situationDate) {
        this.conclude(responsible, situationDate, "");
    }

    @Deprecated
    public final void conclude(Person responsible, YearMonthDay situationDate, String justification) {
        this.edit(new AcademicServiceRequestBean(AcademicServiceRequestSituationType.CONCLUDED, responsible, situationDate, justification));
    }

    @Deprecated
    public final void conclude(YearMonthDay yearMonthDay, String string, boolean bl) {
        Object object = advice$conclude.perform((Callable)new AcademicServiceRequest$callable$conclude(this, yearMonthDay, string, bl));
    }

    static final /* synthetic */ void advised$conclude(AcademicServiceRequest this_, YearMonthDay situationDate, String justification, boolean sendEmail2) {
        this_.conclude(AccessControl.getPerson(), situationDate, justification);
        if (sendEmail2) {
            this_.sendConcludeEmail();
        }
        Signal.emit((String)"ACADEMIC_SERVICE_REQUEST_NEW_SITUATION_EVENT", (Object)new DomainObjectEvent((DomainObject)this_));
    }

    private void sendConcludeEmail() {
        String body = BundleUtil.getString((String)"resources.ApplicationResources", (String)"mail.academicServiceRequest.concluded.message1", (String[])new String[0]);
        body = body + " " + this.getServiceRequestNumberYear();
        body = body + " " + BundleUtil.getString((String)"resources.ApplicationResources", (String)"mail.academicServiceRequest.concluded.message2", (String[])new String[0]);
        body = body + " '" + this.getDescription();
        body = body + "' " + BundleUtil.getString((String)"resources.ApplicationResources", (String)"mail.academicServiceRequest.concluded.message3", (String[])new String[0]);
        if (this.getAcademicServiceRequestType() == AcademicServiceRequestType.SPECIAL_SEASON_REQUEST) {
            if (((SpecialSeasonRequest)((Object)this)).getDeferred() == null) {
                throw new DomainException("special.season.request.deferment.cant.be.null", new String[0]);
            }
            body = ((SpecialSeasonRequest)((Object)this)).getDeferred() == true ? body + "\n" + BundleUtil.getString((String)"resources.ApplicationResources", (String)"mail.academicServiceRequest.concluded.messageSSR4A", (String[])new String[0]) : body + "\n" + BundleUtil.getString((String)"resources.ApplicationResources", (String)"mail.academicServiceRequest.concluded.messageSSR4B", (String[])new String[0]);
            body = body + "\n\n" + BundleUtil.getString((String)"resources.ApplicationResources", (String)"mail.academicServiceRequest.concluded.messageSSR5", (String[])new String[0]);
        } else {
            body = body + "\n\n" + BundleUtil.getString((String)"resources.ApplicationResources", (String)"mail.academicServiceRequest.concluded.message4", (String[])new String[0]);
        }
        Sender sender = (Sender)((Object)this.getAdministrativeOffice().getUnit().getUnitBasedSenderSet().iterator().next());
        Recipient recipient = new Recipient(UserGroup.of((User[])new User[]{this.getPerson().getUser()}));
        new Message(sender, (Collection<? extends ReplyTo>)sender.getReplyTosSet(), recipient.asCollection(), this.getDescription(), body, "");
    }

    public final void delivered() {
        Object object = advice$delivered.perform((Callable)new AcademicServiceRequest$callable$delivered(this));
    }

    static final /* synthetic */ void advised$delivered(AcademicServiceRequest this_) {
        this_.delivered(AccessControl.getPerson());
        Signal.emit((String)"ACADEMIC_SERVICE_REQUEST_NEW_SITUATION_EVENT", (Object)new DomainObjectEvent((DomainObject)this_));
    }

    private final void delivered(Person responsible) {
        this.edit(new AcademicServiceRequestBean(AcademicServiceRequestSituationType.DELIVERED, responsible));
    }

    public final void delivered(Person responsible, YearMonthDay situationDate) {
        this.edit(new AcademicServiceRequestBean(AcademicServiceRequestSituationType.DELIVERED, responsible, situationDate, ""));
        Signal.emit((String)"ACADEMIC_SERVICE_REQUEST_NEW_SITUATION_EVENT", (Object)new DomainObjectEvent((DomainObject)this));
    }

    public final void delete() {
        this.checkRulesToDelete();
        this.disconnect();
        super.deleteDomainObject();
    }

    protected void disconnect() {
        while (!this.getAcademicServiceRequestSituationsSet().isEmpty()) {
            this.getAcademicServiceRequestSituationsSet().iterator().next().delete();
        }
        super.setAdministrativeOffice(null);
        super.setExecutionYear(null);
        super.setRootDomainObject(null);
        super.setAcademicServiceRequestYear(null);
    }

    protected void checkRulesToDelete() {
    }

    public void cloneAttributes(AcademicServiceRequest original) {
        this.setRootDomainObject(original.getRootDomainObject());
        super.setAdministrativeOffice(original.getAdministrativeOffice());
        this.setAcademicServiceRequestYear(original.getAcademicServiceRequestYear());
        super.setServiceRequestNumber(original.getServiceRequestNumber());
        this.setRequestDate(original.getRequestDate());
    }

    public void setAdministrativeOffice(AdministrativeOffice administrativeOffice) {
        throw new DomainException("error.serviceRequests.RegistrationAcademicServiceRequest.cannot.modify.administrativeOffice", new String[0]);
    }

    public final void setServiceRequestNumber(Integer serviceRequestNumber) {
        throw new DomainException("error.serviceRequests.AcademicServiceRequest.cannot.modify.serviceRequestNumber", new String[0]);
    }

    public final String getServiceRequestNumberYear() {
        return this.getServiceRequestNumber() + SERVICE_REQUEST_NUMBER_YEAR_SEPARATOR + this.getServiceRequestYear();
    }

    public final void addAcademicServiceRequestSituations(AcademicServiceRequestSituation academicServiceRequestSituation) {
        throw new DomainException("error.serviceRequests.AcademicServiceRequest.cannot.add.academicServiceRequestSituation", new String[0]);
    }

    public final void setEvent(AcademicServiceRequestEvent event) {
        throw new DomainException("error.serviceRequests.AcademicServiceRequest.cannot.modify.event", new String[0]);
    }

    public final Set<AcademicServiceRequestSituation> getAcademicServiceRequestSituationsSet() {
        return Collections.unmodifiableSet(super.getAcademicServiceRequestSituationsSet());
    }

    public final void removeAcademicServiceRequestSituations(AcademicServiceRequestSituation academicServiceRequestSituation) {
        throw new DomainException("error.serviceRequests.AcademicServiceRequest.cannot.remove.academicServiceRequestSituation", new String[0]);
    }

    public final AcademicServiceRequestSituation getActiveSituation() {
        return !this.getAcademicServiceRequestSituationsSet().isEmpty() ? Collections.min(this.getAcademicServiceRequestSituationsSet(), AcademicServiceRequestSituation.COMPARATOR_BY_MOST_RECENT_SITUATION_DATE_AND_ID) : null;
    }

    public final DateTime getActiveSituationDate() {
        return this.getActiveSituation().getSituationDate();
    }

    public final AcademicServiceRequestSituation getConclusionSituation() {
        return this.getSituationByType(AcademicServiceRequestSituationType.CONCLUDED);
    }

    public AcademicServiceRequestSituation getSituationByType(AcademicServiceRequestSituationType type) {
        for (AcademicServiceRequestSituation situation : this.getAcademicServiceRequestSituationsSet()) {
            if (!situation.getAcademicServiceRequestSituationType().equals((Object)type)) continue;
            return situation;
        }
        return null;
    }

    public final AcademicServiceRequestSituationType getAcademicServiceRequestSituationType() {
        return this.getActiveSituation().getAcademicServiceRequestSituationType();
    }

    public void edit(AcademicServiceRequestBean academicServiceRequestBean) {
        if (!this.isEditable()) {
            throw new DomainException("error.serviceRequests.AcademicServiceRequest.is.not.editable", new String[0]);
        }
        if (this.getAcademicServiceRequestSituationType() != academicServiceRequestBean.getAcademicServiceRequestSituationType()) {
            this.checkRulesToChangeState(academicServiceRequestBean.getAcademicServiceRequestSituationType());
            this.internalChangeState(academicServiceRequestBean);
            this.createAcademicServiceRequestSituations(academicServiceRequestBean);
        } else {
            this.getActiveSituation().edit(academicServiceRequestBean);
        }
    }

    protected void checkRulesToChangeState(AcademicServiceRequestSituationType situationType) {
        if (!this.isAcceptedSituationType(situationType)) {
            String sourceState = this.getActiveSituation().getAcademicServiceRequestSituationType().getLocalizedName();
            String targetState = situationType.getLocalizedName();
            throw new DomainException("error.serviceRequests.AcademicServiceRequest.cannot.change.from.source.state.to.target.state", sourceState, targetState);
        }
    }

    protected final boolean isAcceptedSituationType(AcademicServiceRequestSituationType situationType) {
        return this.getAcceptedSituationTypes(this.getAcademicServiceRequestSituationType()).contains((Object)situationType);
    }

    public final boolean isCancelledSituationAccepted() {
        return this.isAcceptedSituationType(AcademicServiceRequestSituationType.CANCELLED);
    }

    public final boolean isRejectedSituationAccepted() {
        return this.isAcceptedSituationType(AcademicServiceRequestSituationType.REJECTED);
    }

    public final boolean isProcessingSituationAccepted() {
        return this.isAcceptedSituationType(AcademicServiceRequestSituationType.PROCESSING);
    }

    public final boolean isSendToExternalEntitySituationAccepted() {
        return this.isAcceptedSituationType(AcademicServiceRequestSituationType.SENT_TO_EXTERNAL_ENTITY);
    }

    public final boolean isReceivedSituationAccepted() {
        return this.isAcceptedSituationType(AcademicServiceRequestSituationType.RECEIVED_FROM_EXTERNAL_ENTITY);
    }

    public final boolean isConcludedSituationAccepted() {
        return this.isAcceptedSituationType(AcademicServiceRequestSituationType.CONCLUDED);
    }

    public final boolean isDeliveredSituationAccepted() {
        return this.isAcceptedSituationType(AcademicServiceRequestSituationType.DELIVERED);
    }

    public boolean isDownloadPossible() {
        return false;
    }

    public final boolean isRePrintPossible() {
        return this.finishedSuccessfully() && this.isToPrint();
    }

    private List<AcademicServiceRequestSituationType> getAcceptedSituationTypes(AcademicServiceRequestSituationType situationType) {
        switch (situationType) {
            case NEW: {
                return this.getNewSituationAcceptedSituationsTypes();
            }
            case PROCESSING: {
                return this.getProcessingSituationAcceptedSituationsTypes();
            }
            case SENT_TO_EXTERNAL_ENTITY: {
                return this.getSentToExternalEntitySituationAcceptedSituationsTypes();
            }
            case RECEIVED_FROM_EXTERNAL_ENTITY: {
                return this.getReceivedFromExternalEntitySituationAcceptedSituationsTypes();
            }
            case CONCLUDED: {
                return this.getConcludedSituationAcceptedSituationsTypes();
            }
        }
        return Collections.emptyList();
    }

    protected List<AcademicServiceRequestSituationType> getNewSituationAcceptedSituationsTypes() {
        return Collections.unmodifiableList(Arrays.asList(AcademicServiceRequestSituationType.CANCELLED, AcademicServiceRequestSituationType.REJECTED, AcademicServiceRequestSituationType.PROCESSING));
    }

    protected List<AcademicServiceRequestSituationType> getProcessingSituationAcceptedSituationsTypes() {
        if (this.isPossibleToSendToOtherEntity()) {
            return Collections.unmodifiableList(Arrays.asList(AcademicServiceRequestSituationType.CANCELLED, AcademicServiceRequestSituationType.REJECTED, AcademicServiceRequestSituationType.SENT_TO_EXTERNAL_ENTITY));
        }
        return Collections.unmodifiableList(Arrays.asList(AcademicServiceRequestSituationType.CANCELLED, AcademicServiceRequestSituationType.REJECTED, AcademicServiceRequestSituationType.CONCLUDED));
    }

    protected List<AcademicServiceRequestSituationType> getSentToExternalEntitySituationAcceptedSituationsTypes() {
        return Collections.unmodifiableList(Collections.singletonList(AcademicServiceRequestSituationType.RECEIVED_FROM_EXTERNAL_ENTITY));
    }

    protected List<AcademicServiceRequestSituationType> getReceivedFromExternalEntitySituationAcceptedSituationsTypes() {
        return Collections.unmodifiableList(Arrays.asList(AcademicServiceRequestSituationType.CANCELLED, AcademicServiceRequestSituationType.REJECTED, AcademicServiceRequestSituationType.CONCLUDED));
    }

    protected List<AcademicServiceRequestSituationType> getConcludedSituationAcceptedSituationsTypes() {
        return Collections.unmodifiableList(Arrays.asList(AcademicServiceRequestSituationType.CANCELLED, AcademicServiceRequestSituationType.DELIVERED));
    }

    protected void internalChangeState(AcademicServiceRequestBean academicServiceRequestBean) {
        this.verifyIsToProcessAndHasPersonalInfo(academicServiceRequestBean);
        this.verifyIsToDeliveredAndIsPayed(academicServiceRequestBean);
        if (!academicServiceRequestBean.isToCancelOrReject()) {
            this.assertPayedEvents();
        }
    }

    protected void assertPayedEvents() {
        if (TreasuryBridgeAPIFactory.implementation().isAcademicalActsBlocked(this.getPerson(), new LocalDate())) {
            throw new DomainException("DocumentRequest.student.has.not.payed.debts", new String[0]);
        }
    }

    protected void verifyIsToDeliveredAndIsPayed(AcademicServiceRequestBean academicServiceRequestBean) {
        if (academicServiceRequestBean.isToDeliver()) {
            // empty if block
        }
    }

    protected void verifyIsToProcessAndHasPersonalInfo(AcademicServiceRequestBean academicServiceRequestBean) {
        if (academicServiceRequestBean.isToProcess() && this.hasPersonalInfo() && this.hasMissingPersonalInfo()) {
            throw new DomainException("AcademicServiceRequest.has.missing.personal.info", new String[0]);
        }
    }

    protected void createAcademicServiceRequestSituations(AcademicServiceRequestBean academicServiceRequestBean) {
        AcademicServiceRequestSituation.create(this, academicServiceRequestBean);
    }

    public boolean isPiggyBackedOnRegistry() {
        return false;
    }

    public final boolean isNewRequest() {
        return this.getAcademicServiceRequestSituationType() == AcademicServiceRequestSituationType.NEW;
    }

    public final boolean isProcessing() {
        return this.getAcademicServiceRequestSituationType() == AcademicServiceRequestSituationType.PROCESSING;
    }

    public final boolean hasProcessed() {
        return this.getSituationByType(AcademicServiceRequestSituationType.PROCESSING) != null;
    }

    public final boolean isSentToExternalEntity() {
        return this.getAcademicServiceRequestSituationType() == AcademicServiceRequestSituationType.SENT_TO_EXTERNAL_ENTITY;
    }

    public final boolean isReceivedFromExternalEntity() {
        return this.getAcademicServiceRequestSituationType() == AcademicServiceRequestSituationType.RECEIVED_FROM_EXTERNAL_ENTITY;
    }

    public final boolean isConcluded() {
        return this.getAcademicServiceRequestSituationType() == AcademicServiceRequestSituationType.CONCLUDED;
    }

    public final boolean hasConcluded() {
        return this.getSituationByType(AcademicServiceRequestSituationType.CONCLUDED) != null;
    }

    public final boolean isDelivered() {
        return this.getAcademicServiceRequestSituationType() == AcademicServiceRequestSituationType.DELIVERED;
    }

    public final boolean isRejected() {
        return this.getAcademicServiceRequestSituationType() == AcademicServiceRequestSituationType.REJECTED;
    }

    public final boolean isCancelled() {
        return this.getAcademicServiceRequestSituationType() == AcademicServiceRequestSituationType.CANCELLED;
    }

    public final boolean isHistorical() {
        return this.isDelivered() || this.isRejected() || this.isCancelled();
    }

    public final boolean isEditable() {
        return !this.isRejected() && !this.isCancelled() && !this.isDelivered();
    }

    public final boolean finishedSuccessfully() {
        return this.isConcluded() || this.isDelivered();
    }

    public final boolean finishedUnsuccessfully() {
        return this.isRejected() || this.isCancelled();
    }

    public final boolean isDocumentRequest() {
        return this instanceof DocumentRequest;
    }

    public abstract boolean isToPrint();

    public abstract boolean isPossibleToSendToOtherEntity();

    public abstract boolean isManagedWithRectorateSubmissionBatch();

    public boolean isCanGenerateRegistryCode() {
        return false;
    }

    public final boolean createdByStudent() {
        return this.getSituationByType(AcademicServiceRequestSituationType.NEW).getCreator() == null;
    }

    @Deprecated
    public final boolean getLoggedPersonCanCancel() {
        return this.isCancelledSituationAccepted() && (this.createdByStudent() && !this.isConcluded() || AcademicAccessRule.isProgramAccessibleToFunction(AcademicOperationType.SERVICE_REQUESTS, this.getAcademicProgram(), Authenticate.getUser()));
    }

    public final DateTime getCreationDate() {
        return this.getSituationByType(AcademicServiceRequestSituationType.NEW).getCreationDate();
    }

    public final DateTime getProcessingDate() {
        AcademicServiceRequestSituation state = this.getSituationByType(AcademicServiceRequestSituationType.PROCESSING);
        return state != null ? state.getCreationDate() : null;
    }

    public final DateTime getRequestConclusionDate() {
        AcademicServiceRequestSituation conclusionSituation = this.getConclusionSituation();
        return conclusionSituation != null ? conclusionSituation.getCreationDate() : null;
    }

    public boolean isRequestForPerson() {
        return false;
    }

    @Override
    public boolean isRequestForPhd() {
        return false;
    }

    @Override
    public boolean isRequestForRegistration() {
        return false;
    }

    public boolean isFor(ExecutionYear executionYear) {
        return this.getExecutionYear() != null && this.getExecutionYear().equals(executionYear);
    }

    @Override
    public abstract Person getPerson();

    public abstract EventType getEventType();

    public abstract AcademicServiceRequestType getAcademicServiceRequestType();

    public abstract boolean hasPersonalInfo();

    protected boolean hasMissingPersonalInfo() {
        return Strings.isNullOrEmpty((String)this.getPerson().getName()) || this.getPerson().getDateOfBirthYearMonthDay() == null || Strings.isNullOrEmpty((String)this.getPerson().getDocumentIdNumber()) || this.getPerson().getIdDocumentType() == null;
    }

    public void revertToProcessingState() {
        throw new DomainException("error.serviceRequests.AcademicServiceRequest.cannot.revert.to.processing.state", new String[0]);
    }

    protected void internalRevertToProcessingState() {
        AcademicServiceRequestSituation activeSituation = this.getActiveSituation();
        if (activeSituation == null || activeSituation.isProcessing() || activeSituation.isNew()) {
            throw new DomainException("error.serviceRequests.AcademicServiceRequest.revert.to.processing.in.only.possibile.from.later.states", new String[0]);
        }
        if (activeSituation.isCancelled()) {
            throw new DomainException("error.serviceRequests.AcademicServiceRequest.cancelled.requests.cannot.be.reverted", new String[0]);
        }
        if (this.getAcademicServiceRequestSituationsSet().size() <= 1) {
            throw new DomainException("error.serviceRequests.AcademicServiceRequest.revert.is.requires.more.than.one.state", new String[0]);
        }
        while (this.getAcademicServiceRequestSituationsSet().size() > 1 && !activeSituation.isProcessing()) {
            activeSituation.delete(false);
            activeSituation = this.getActiveSituation();
        }
    }

    public boolean isDiploma() {
        return false;
    }

    public boolean isPastDiploma() {
        return false;
    }

    public boolean isRegistryDiploma() {
        return false;
    }

    public boolean isDiplomaSupplement() {
        return false;
    }

    public GeneratedDocument getLastGeneratedDocument() {
        DateTime last = null;
        GeneratedDocument lastDoc = null;
        for (GeneratedDocument document : this.getDocumentSet()) {
            if (last != null && !document.getCreationDate().isAfter((ReadableInstant)last)) continue;
            last = document.getCreationDate();
            lastDoc = document;
        }
        return lastDoc;
    }

    public boolean isBatchSet() {
        return this.getRectorateSubmissionBatch() != null;
    }

    @Override
    public abstract AcademicProgram getAcademicProgram();

    public boolean hasExecutionYear() {
        return this.getExecutionYear() != null;
    }

    @Override
    public boolean hasRegistryCode() {
        return this.getRegistryCode() != null;
    }

    @Override
    public boolean isRequestedWithCycle() {
        return this.getRequestedCycle() != null;
    }

    public static Set<AcademicServiceRequest> getAcademicServiceRequests(Person person, Integer year, AcademicServiceRequestSituationType situation, Interval interval) {
        HashSet<AcademicServiceRequest> serviceRequests = new HashSet<AcademicServiceRequest>();
        Set programs = AcademicAccessRule.getProgramsAccessibleToFunction(AcademicOperationType.SERVICE_REQUESTS, person.getUser()).collect(Collectors.toSet());
        Collection<Object> possible = null;
        possible = year != null ? AcademicServiceRequestYear.getAcademicServiceRequests(year) : Bennu.getInstance().getAcademicServiceRequestsSet();
        for (AcademicServiceRequest academicServiceRequest : possible) {
            if (!programs.contains((Object)academicServiceRequest.getAcademicProgram()) || situation != null && !academicServiceRequest.getAcademicServiceRequestSituationType().equals((Object)situation) || interval != null && !interval.contains((ReadableInstant)academicServiceRequest.getActiveSituationDate())) continue;
            serviceRequests.add(academicServiceRequest);
        }
        return serviceRequests;
    }

    @Override
    public boolean isDetailed() {
        return this.getDetailed();
    }

    static {
        advice$process = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$sendToExternalEntity = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$receivedFromExternalEntity = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$reject = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$cancel = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$conclude = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$delivered = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATOR_BY_NUMBER = new Comparator<AcademicServiceRequest>(){

            @Override
            public int compare(AcademicServiceRequest o1, AcademicServiceRequest o2) {
                return o1.getServiceRequestNumber().compareTo(o2.getServiceRequestNumber());
            }
        };
        EXECUTION_YEAR_COMPARATOR = new Comparator<AcademicServiceRequest>(){

            @Override
            public int compare(AcademicServiceRequest o1, AcademicServiceRequest o2) {
                if (o1.getExecutionYear() == null && o2.getExecutionYear() == null) {
                    return 0;
                }
                if (o1.getExecutionYear() != null && o2.getExecutionYear() == null) {
                    return 1;
                }
                if (o1.getExecutionYear() == null && o2.getExecutionYear() != null) {
                    return -1;
                }
                return ExecutionYear.COMPARATOR_BY_YEAR.compare(o1.getExecutionYear(), o2.getExecutionYear());
            }
        };
        EXECUTION_YEAR_AND_OID_COMPARATOR = new Comparator<AcademicServiceRequest>(){

            @Override
            public int compare(AcademicServiceRequest o1, AcademicServiceRequest o2) {
                ComparatorChain comparatorChain = new ComparatorChain();
                comparatorChain.addComparator(EXECUTION_YEAR_COMPARATOR);
                comparatorChain.addComparator(DomainObjectUtil.COMPARATOR_BY_ID);
                return comparatorChain.compare((Object)o1, (Object)o2);
            }
        };
    }
}

