/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.photograph;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.photograph.AspectRatio;
import org.fenixedu.academic.domain.photograph.PictureMode;
import org.fenixedu.academic.domain.photograph.PictureSize;
import org.fenixedu.academic.domain.photograph.Picture_Base;
import org.fenixedu.academic.util.ContentType;
import org.imgscalr.Scalr;

public abstract class Picture
extends Picture_Base {
    public void delete() {
        super.deleteDomainObject();
    }

    public byte[] getBytes() {
        return this.getPictureData();
    }

    public void setupPictureMetadata(byte[] pictureData) {
        BufferedImage buffer = Picture.readImage(pictureData);
        this.setWidth(buffer.getWidth());
        this.setHeight(buffer.getHeight());
    }

    public static BufferedImage readImage(byte[] imageData) {
        ByteArrayInputStream bais = new ByteArrayInputStream(imageData);
        try {
            return ImageIO.read(bais);
        }
        catch (IOException ioe) {
            throw new DomainException("error.photograph.imageio.failedReadingImageFromByteArray", ioe, new String[0]);
        }
    }

    public static byte[] writeImageAsBytes(BufferedImage image, ContentType fileFormat) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, fileFormat.getFileExtention(), out);
            return out.toByteArray();
        }
        catch (IOException ioe) {
            throw new DomainException("error.photograph.imageio.failedWritingImageToByteArray", ioe, new String[0]);
        }
    }

    public static byte[] writeImage(BufferedImage image, ContentType fileFormat) {
        return Picture.writeImageAsBytes(image, fileFormat);
    }

    public static BufferedImage transformFit(BufferedImage source, int xRatio, int yRatio) {
        BufferedImage finale;
        if (1.0 * (double)source.getWidth() / (double)source.getHeight() < 1.0 * (double)xRatio / (double)yRatio) {
            int destH = source.getHeight();
            int destW = (int)Math.round((double)(destH * xRatio) * 1.0 / ((double)yRatio * 1.0));
            BufferedImage scaled = Scalr.resize((BufferedImage)source, (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.FIT_TO_HEIGHT, (int)destW, (int)destH, (BufferedImageOp[])new BufferedImageOp[0]);
            int padding = (int)Math.round((double)(destW - source.getWidth()) / 2.0);
            BufferedImage padded = padding != 0 ? Scalr.pad((BufferedImage)scaled, (int)padding, (Color)new Color(255, 255, 255, 0), (BufferedImageOp[])new BufferedImageOp[0]) : scaled;
            finale = Scalr.crop((BufferedImage)padded, (int)0, (int)padding, (int)destW, (int)destH, (BufferedImageOp[])new BufferedImageOp[0]);
        } else {
            int destW = source.getWidth();
            int destH = (int)Math.round((double)(destW * yRatio) * 1.0 / ((double)xRatio * 1.0));
            BufferedImage scaled = Scalr.resize((BufferedImage)source, (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.FIT_TO_WIDTH, (int)destW, (int)destH, (BufferedImageOp[])new BufferedImageOp[0]);
            int padding = (int)Math.round((double)(destH - source.getHeight()) / 2.0);
            BufferedImage padded = padding != 0 ? Scalr.pad((BufferedImage)scaled, (int)padding, (Color)new Color(255, 255, 255, 0), (BufferedImageOp[])new BufferedImageOp[0]) : scaled;
            finale = Scalr.crop((BufferedImage)padded, (int)padding, (int)0, (int)destW, (int)destH, (BufferedImageOp[])new BufferedImageOp[0]);
        }
        return finale;
    }

    public static BufferedImage transformZoom(BufferedImage source, int xRatio, int yRatio) {
        BufferedImage finale;
        if (1.0 * (double)source.getWidth() / (double)source.getHeight() > 1.0 * (double)xRatio / (double)yRatio) {
            int destH = source.getHeight();
            int destW = (int)Math.round((double)(destH * xRatio) * 1.0 / ((double)yRatio * 1.0));
            int padding = (int)Math.round((double)(source.getWidth() - destW) / 2.0);
            finale = Scalr.crop((BufferedImage)source, (int)padding, (int)0, (int)destW, (int)destH, (BufferedImageOp[])new BufferedImageOp[0]);
        } else {
            int destW = source.getWidth();
            int destH = (int)Math.round((double)(destW * yRatio) * 1.0 / ((double)xRatio * 1.0));
            int padding = (int)Math.round((double)(source.getHeight() - destH) / 2.0);
            finale = Scalr.crop((BufferedImage)source, (int)0, (int)padding, (int)destW, (int)destH, (BufferedImageOp[])new BufferedImageOp[0]);
        }
        return finale;
    }

    public static BufferedImage transform(BufferedImage source, AspectRatio aspectRatio, PictureMode pictureMode) {
        switch (pictureMode) {
            case FIT: {
                return Picture.transformFit(source, aspectRatio.getXRatio(), aspectRatio.getYRatio());
            }
            case ZOOM: {
                return Picture.transformZoom(source, aspectRatio.getXRatio(), aspectRatio.getYRatio());
            }
        }
        return Picture.transformFit(source, aspectRatio.getXRatio(), aspectRatio.getYRatio());
    }

    public static BufferedImage fitTo(BufferedImage source, int width, int height) {
        Scalr.Mode mode = source.getHeight() > source.getWidth() ? Scalr.Mode.FIT_TO_HEIGHT : Scalr.Mode.FIT_TO_WIDTH;
        return Scalr.resize((BufferedImage)source, (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)mode, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[0]);
    }

    public static BufferedImage fitTo(BufferedImage source, PictureSize pictureSize) {
        return Picture.fitTo(source, pictureSize.getWidth(), pictureSize.getHeight());
    }
}

