/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.thesis.activities;

import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.caseHandling.PreConditionNotValidException;
import org.fenixedu.academic.domain.phd.PhdProgramDocumentUploadBean;
import org.fenixedu.academic.domain.phd.alert.AlertService;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcess;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessBean;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessStateType;
import org.fenixedu.academic.domain.phd.thesis.activities.PhdThesisActivity;
import org.fenixedu.bennu.core.domain.User;

public class SubmitJuryElementsDocuments
extends PhdThesisActivity {
    @Override
    protected void activityPreConditions(PhdThesisProcess process2, User userView) {
        if (process2.isAllowedToManageProcess(userView)) {
            return;
        }
        if (process2.isJuryValidated()) {
            throw new PreConditionNotValidException();
        }
        if (!process2.hasState(PhdThesisProcessStateType.WAITING_FOR_JURY_CONSTITUTION)) {
            throw new PreConditionNotValidException();
        }
        if (userView.getPerson() != null && process2.getIndividualProgramProcess().isCoordinatorForPhdProgram(userView.getPerson())) {
            return;
        }
        throw new PreConditionNotValidException();
    }

    @Override
    protected PhdThesisProcess executeActivity(PhdThesisProcess process2, User userView, Object object) {
        PhdThesisProcessBean bean = (PhdThesisProcessBean)object;
        boolean anyDocumentSubmitted = false;
        process2.setWhenJuryDesignated(bean.getWhenJuryDesignated());
        for (PhdProgramDocumentUploadBean each : bean.getDocuments()) {
            if (!each.hasAnyInformation()) continue;
            process2.addDocument(each, userView.getPerson());
            if (bean.getGenerateAlert().booleanValue()) {
                this.alertIfNecessary(bean, process2, each, userView.getPerson());
            }
            anyDocumentSubmitted = true;
        }
        if (anyDocumentSubmitted && !process2.hasState(PhdThesisProcessStateType.JURY_WAITING_FOR_VALIDATION)) {
            process2.createState(PhdThesisProcessStateType.JURY_WAITING_FOR_VALIDATION, userView.getPerson(), bean.getRemarks());
        }
        return process2;
    }

    private void alertIfNecessary(PhdThesisProcessBean bean, PhdThesisProcess process2, PhdProgramDocumentUploadBean each, Person person) {
        switch (each.getType()) {
            case JURY_PRESIDENT_ELEMENT: {
                if (!bean.getGenerateAlert().booleanValue()) break;
                AlertService.alertCoordinators(process2.getIndividualProgramProcess(), "message.phd.alert.request.jury.president.subject", "message.phd.alert.request.jury.president.body");
                break;
            }
            case JURY_ELEMENTS: {
                if (!process2.getIndividualProgramProcess().isCoordinatorForPhdProgram(person)) break;
                AlertService.alertAcademicOffice(process2.getIndividualProgramProcess(), AcademicOperationType.VIEW_PHD_THESIS_ALERTS, "message.phd.alert.jury.elements.submitted.subject", "message.phd.alert.jury.elements.submitted.body");
            }
        }
    }
}

