/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.serviceRequests;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.serviceRequests.IPhdAcademicServiceRequest;
import org.fenixedu.academic.domain.phd.serviceRequests.PhdAcademicServiceRequest;
import org.fenixedu.academic.domain.phd.serviceRequests.PhdAcademicServiceRequestBean$callable$handleNewSituation;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequestSituationType;
import org.fenixedu.academic.predicate.AccessControl;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PhdAcademicServiceRequestBean
implements Serializable,
IPhdAcademicServiceRequest {
    private static final long serialVersionUID = 1L;
    private PhdAcademicServiceRequest academicServiceRequest;
    private AcademicServiceRequestSituationType situationType;
    private DateTime whenNewSituationOccured = new DateTime();
    private String justification;
    public static final Advice advice$handleNewSituation = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public PhdAcademicServiceRequestBean(PhdAcademicServiceRequest request) {
        this.academicServiceRequest = request;
    }

    public PhdAcademicServiceRequest getAcademicServiceRequest() {
        return this.academicServiceRequest;
    }

    public void setAcademicServiceRequest(PhdAcademicServiceRequest academicServiceRequest) {
        this.academicServiceRequest = academicServiceRequest;
    }

    public AcademicServiceRequestSituationType getSituationType() {
        return this.situationType;
    }

    public void setSituationType(AcademicServiceRequestSituationType situationType) {
        this.situationType = situationType;
    }

    public DateTime getWhenNewSituationOccured() {
        return this.whenNewSituationOccured;
    }

    public void setWhenNewSituationOccured(DateTime whenNewSituationOccured) {
        this.whenNewSituationOccured = whenNewSituationOccured;
    }

    public String getJustification() {
        return this.justification;
    }

    public void setJustification(String justification) {
        this.justification = justification;
    }

    public void handleNewSituation() {
        Object object = advice$handleNewSituation.perform((Callable)new PhdAcademicServiceRequestBean$callable$handleNewSituation(this));
    }

    static /* synthetic */ void advised$handleNewSituation(PhdAcademicServiceRequestBean this_) {
        switch (this_.getSituationType()) {
            case PROCESSING: {
                this_.getAcademicServiceRequest().process(this_.getWhenNewSituationOccured().toYearMonthDay());
                break;
            }
            case CANCELLED: {
                this_.getAcademicServiceRequest().cancel(this_.getJustification());
                break;
            }
            case REJECTED: {
                this_.getAcademicServiceRequest().reject(this_.getJustification());
                break;
            }
            case RECEIVED_FROM_EXTERNAL_ENTITY: {
                this_.getAcademicServiceRequest().receivedFromExternalEntity(this_.getWhenNewSituationOccured().toYearMonthDay(), this_.getJustification());
                break;
            }
            case CONCLUDED: {
                this_.getAcademicServiceRequest().conclude(this_.getWhenNewSituationOccured().toYearMonthDay(), this_.getJustification());
                break;
            }
            case SENT_TO_EXTERNAL_ENTITY: {
                this_.getAcademicServiceRequest().sendToExternalEntity(this_.getWhenNewSituationOccured().toYearMonthDay(), this_.getJustification());
                break;
            }
            case DELIVERED: {
                this_.getAcademicServiceRequest().delivered(AccessControl.getPerson(), this_.getWhenNewSituationOccured().toYearMonthDay());
                break;
            }
            default: {
                throw new DomainException("error.PhdAcademicServiceRequestBean.unknown.situation.type", new String[0]);
            }
        }
    }

    @Override
    public PhdIndividualProgramProcess getPhdIndividualProgramProcess() {
        return this.academicServiceRequest.getPhdIndividualProgramProcess();
    }
}

