/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.candidacy.feedbackRequest;

import java.util.List;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdProcessStateType;
import org.fenixedu.academic.domain.phd.candidacy.feedbackRequest.PhdCandidacyFeedbackRequestProcess;
import org.fenixedu.academic.domain.phd.candidacy.feedbackRequest.PhdCandidacyFeedbackStateType;
import org.fenixedu.academic.domain.phd.candidacy.feedbackRequest.PhdCandidacyFeedbackState_Base;
import org.fenixedu.academic.domain.phd.exceptions.PhdDomainOperationException;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.RolePredicates;
import org.joda.time.DateTime;

public class PhdCandidacyFeedbackState
extends PhdCandidacyFeedbackState_Base {
    private PhdCandidacyFeedbackState() {
    }

    protected PhdCandidacyFeedbackState(PhdCandidacyFeedbackRequestProcess process2, PhdCandidacyFeedbackStateType type, Person person, String remarks, DateTime stateDate) {
        this();
        this.init(process2, type, person, remarks, stateDate);
    }

    protected void init(Person person, String remarks, DateTime stateDate) {
        throw new RuntimeException("invoke other init");
    }

    private void init(PhdCandidacyFeedbackRequestProcess process2, PhdCandidacyFeedbackStateType type, Person person, String remarks, DateTime stateDate) {
        this.check(process2, type);
        this.setProcess(process2);
        super.init(person, remarks, stateDate, (PhdProcessStateType)type);
        this.setType(type);
    }

    private void check(PhdCandidacyFeedbackRequestProcess process2, PhdCandidacyFeedbackStateType type) {
        String[] args = new String[]{};
        if (process2 == null) {
            throw new DomainException("error.PhdCandidacyProcessState.invalid.process", args);
        }
        String[] args1 = new String[]{};
        if (type == null) {
            throw new DomainException("error.PhdCandidacyProcessState.invalid.type", args1);
        }
        this.checkType(process2, type);
    }

    private void checkType(PhdCandidacyFeedbackRequestProcess process2, PhdCandidacyFeedbackStateType type) {
        PhdCandidacyFeedbackStateType currentType = process2.getActiveState();
        if (currentType != null && currentType.equals(type)) {
            throw new PhdDomainOperationException("error.PhdCandidacyProcessState.equals.previous.state", type.getLocalizedName());
        }
    }

    protected void disconnect() {
        this.setProcess(null);
        super.disconnect();
    }

    public static PhdCandidacyFeedbackState create(PhdCandidacyFeedbackRequestProcess process2, PhdCandidacyFeedbackStateType type) {
        AccessControl.check(RolePredicates.MANAGER_PREDICATE);
        PhdCandidacyFeedbackState result = new PhdCandidacyFeedbackState();
        result.check(process2, type);
        result.setProcess(process2);
        result.setType(type);
        return result;
    }

    public boolean isLast() {
        return this.getProcess().getMostRecentState() == this;
    }

    public PhdCandidacyFeedbackState createWithInferredStateDate(PhdCandidacyFeedbackRequestProcess process2, PhdCandidacyFeedbackStateType type, Person person, String remarks) {
        return this.createWithGivenStateDate(process2, type, person, remarks, new DateTime());
    }

    public PhdCandidacyFeedbackState createWithGivenStateDate(PhdCandidacyFeedbackRequestProcess process2, PhdCandidacyFeedbackStateType type, Person person, String remarks, DateTime stateDate) {
        List<PhdCandidacyFeedbackStateType> possibleNextStates = PhdCandidacyFeedbackStateType.getPossibleNextStates(type);
        if (!possibleNextStates.contains(type)) {
            String description = PhdCandidacyFeedbackState.buildExpectedStatesDescription(possibleNextStates);
            throw new PhdDomainOperationException("error.phd.candidacy.feedbackRequest.PhdCandidacyFeedbackState.invalid.state", type.getLocalizedName(), description);
        }
        return new PhdCandidacyFeedbackState(process2, type, person, remarks, stateDate);
    }
}

