/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.alert;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.fenixedu.academic.domain.AcademicProgram;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accessControl.AcademicAuthorizationGroup;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.phd.InternalPhdParticipant;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdParticipant;
import org.fenixedu.academic.domain.phd.PhdProgram;
import org.fenixedu.academic.domain.phd.alert.PhdCustomAlert;
import org.fenixedu.academic.domain.phd.alert.PhdCustomAlertBean;
import org.fenixedu.academic.domain.util.email.Message;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.academic.domain.util.email.UnitBasedSender;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.groups.UserGroup;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.LocalDate;
import pt.ist.fenixframework.DomainObject;

public class AlertService {
    private static final String PREFIX_PHD_LABEL = "label.phds";

    public static String getSubjectPrefixed(PhdIndividualProgramProcess process2, String subjectKey) {
        return AlertService.getProcessNumberPrefix(process2) + AlertService.getMessageFromResource(subjectKey);
    }

    public static String getProcessNumberPrefix(PhdIndividualProgramProcess process2) {
        return "[" + AlertService.getMessageFromResource(PREFIX_PHD_LABEL) + " - " + process2.getProcessNumber() + "] ";
    }

    public static String getMessageFromResource(String key) {
        return BundleUtil.getString((String)"resources.PhdResources", (String)key, (String[])new String[0]);
    }

    private static String getBodyCommonText(PhdIndividualProgramProcess process2) {
        StringBuilder builder = new StringBuilder();
        builder.append("------------------------------------------------------\n");
        if (process2.getPerson().getStudent() != null) {
            builder.append(AlertService.getSlotLabel(PhdIndividualProgramProcess.class, "student.number"));
            builder.append(": ").append(process2.getPerson().getStudent().getNumber());
        }
        builder.append("\n");
        builder.append(AlertService.getSlotLabel(PhdIndividualProgramProcess.class, "processNumber"));
        builder.append(": ").append(process2.getPhdIndividualProcessNumber().getFullProcessNumber()).append("\n");
        builder.append(AlertService.getSlotLabel(PhdIndividualProgramProcess.class, "person.name"));
        builder.append(": ").append(process2.getPerson().getName()).append("\n");
        builder.append(AlertService.getSlotLabel(PhdIndividualProgramProcess.class, "phdProgram"));
        if (process2.getPhdProgram() != null) {
            builder.append(": ").append(process2.getPhdProgram().getName());
        }
        builder.append("\n");
        builder.append(AlertService.getSlotLabel(PhdIndividualProgramProcess.class, "activeState"));
        builder.append(": ").append(process2.getActiveState().getLocalizedName()).append("\n");
        if (process2.getCandidacyProcess() != null) {
            builder.append(AlertService.getMessageFromResource("label.phd.candidacy")).append(": ");
            builder.append(process2.getCandidacyProcess().getActiveState().getLocalizedName()).append("\n");
        }
        if (process2.getSeminarProcess() != null) {
            builder.append(AlertService.getMessageFromResource("label.phd.publicPresentationSeminar")).append(": ");
            builder.append(process2.getSeminarProcess().getActiveState().getLocalizedName()).append("\n");
        }
        if (process2.getThesisProcess() != null) {
            builder.append(AlertService.getMessageFromResource("label.phd.thesis")).append(": ");
            builder.append(process2.getThesisProcess().getActiveState().getLocalizedName()).append("\n");
        }
        builder.append(AlertService.getSlotLabel(PhdIndividualProgramProcess.class, "executionYear"));
        builder.append(": ").append(process2.getExecutionYear().getQualifiedName()).append("\n");
        builder.append("------------------------------------------------------\n\n");
        return builder.toString();
    }

    public static String getBodyText(PhdIndividualProgramProcess process2, String bodyText) {
        return AlertService.getBodyCommonText(process2) + AlertService.getMessageFromResource(bodyText);
    }

    private static String getSlotLabel(Class<? extends DomainObject> clazz, String slotName) {
        return AlertService.getMessageFromResource("label." + clazz.getName() + "." + slotName);
    }

    public static void alertStudent(PhdIndividualProgramProcess process2, String subjectKey, String bodyKey) {
        PhdCustomAlertBean alertBean = new PhdCustomAlertBean(process2, true, false, false);
        alertBean.setSubject(AlertService.getSubjectPrefixed(process2, subjectKey));
        alertBean.setBody(AlertService.getBodyText(process2, bodyKey));
        alertBean.setFireDate(new LocalDate());
        alertBean.setTargetGroup(UserGroup.of((User[])new User[]{process2.getPerson().getUser()}));
        new PhdCustomAlert(alertBean);
    }

    public static void alertStudent(PhdIndividualProgramProcess process2, AlertMessage subject, AlertMessage body) {
        PhdCustomAlertBean alertBean = new PhdCustomAlertBean(process2, true, false, false);
        alertBean.setSubject(AlertService.getSubjectPrefixed(process2, subject));
        alertBean.setBody(AlertService.getBodyText(process2, body));
        alertBean.setFireDate(new LocalDate());
        alertBean.setTargetGroup(UserGroup.of((User[])new User[]{process2.getPerson().getUser()}));
        new PhdCustomAlert(alertBean);
    }

    public static void alertGuiders(PhdIndividualProgramProcess process2, String subjectKey, String bodyKey) {
        HashSet<Person> toNotify = new HashSet<Person>();
        for (PhdParticipant guiding : process2.getGuidingsAndAssistantGuidings()) {
            if (guiding.isInternal()) {
                toNotify.add(((InternalPhdParticipant)((Object)guiding)).getPerson());
                continue;
            }
            guiding.ensureExternalAccess();
            new Message((Sender)((Object)Bennu.getInstance().getSystemSender()), Collections.emptyList(), Collections.emptyList(), AlertService.getSubjectPrefixed(process2, subjectKey), AlertService.getBodyText(process2, bodyKey), Collections.singleton(guiding.getEmail()));
        }
        PhdCustomAlertBean alertBean = new PhdCustomAlertBean(process2, true, false, false);
        alertBean.setSubject(AlertService.getSubjectPrefixed(process2, subjectKey));
        alertBean.setBody(AlertService.getBodyText(process2, bodyKey));
        alertBean.setFireDate(new LocalDate());
        alertBean.setTargetGroup(UserGroup.of(Person.convertToUsers(toNotify)));
        new PhdCustomAlert(alertBean);
    }

    public static void alertGuiders(PhdIndividualProgramProcess process2, AlertMessage subjectMessage, AlertMessage bodyMessage) {
        HashSet<Person> toNotify = new HashSet<Person>();
        for (PhdParticipant guiding : process2.getGuidingsAndAssistantGuidings()) {
            if (guiding.isInternal()) {
                toNotify.add(((InternalPhdParticipant)((Object)guiding)).getPerson());
                continue;
            }
            guiding.ensureExternalAccess();
            new Message((Sender)((Object)Bennu.getInstance().getSystemSender()), Collections.emptyList(), Collections.emptyList(), AlertService.getSubjectPrefixed(process2, subjectMessage), AlertService.getBodyText(process2, bodyMessage), Collections.singleton(guiding.getEmail()));
        }
        PhdCustomAlertBean alertBean = new PhdCustomAlertBean(process2, true, false, false);
        alertBean.setSubject(AlertService.getSubjectPrefixed(process2, subjectMessage));
        alertBean.setBody(AlertService.getBodyText(process2, bodyMessage));
        alertBean.setFireDate(new LocalDate());
        alertBean.setTargetGroup(UserGroup.of(Person.convertToUsers(toNotify)));
        new PhdCustomAlert(alertBean);
    }

    public static void alertAcademicOffice(PhdIndividualProgramProcess process2, String subjectKey, String bodyKey) {
        PhdCustomAlertBean alertBean = new PhdCustomAlertBean(process2, true, false, true);
        alertBean.setSubject(AlertService.getSubjectPrefixed(process2, subjectKey));
        alertBean.setBody(AlertService.getBodyText(process2, bodyKey));
        alertBean.setFireDate(new LocalDate());
        alertBean.setTargetGroup((Group)AcademicAuthorizationGroup.get(AcademicOperationType.MANAGE_PHD_PROCESSES, (AcademicProgram)((Object)process2.getPhdProgram())));
        new PhdCustomAlert(alertBean);
    }

    public static void alertAcademicOffice(PhdIndividualProgramProcess process2, AcademicOperationType permissionType, String subjectKey, String bodyKey) {
        PhdCustomAlertBean alertBean = new PhdCustomAlertBean(process2, true, false, true);
        alertBean.setSubject(AlertService.getSubjectPrefixed(process2, subjectKey));
        alertBean.setBody(AlertService.getBodyText(process2, bodyKey));
        alertBean.setFireDate(new LocalDate());
        alertBean.setTargetGroup(AlertService.getTargetGroup(permissionType, process2.getPhdProgram()));
        new PhdCustomAlert(alertBean);
    }

    public static void alertAcademicOffice(PhdIndividualProgramProcess process2, AcademicOperationType permissionType, AlertMessage subjectMessage, AlertMessage bodyMessage) {
        PhdCustomAlertBean alertBean = new PhdCustomAlertBean(process2, true, false, true);
        alertBean.setSubject(AlertService.getSubjectPrefixed(process2, subjectMessage));
        alertBean.setBody(AlertService.getBodyText(process2, bodyMessage));
        alertBean.setFireDate(new LocalDate());
        alertBean.setTargetGroup(AlertService.getTargetGroup(permissionType, process2.getPhdProgram()));
        new PhdCustomAlert(alertBean);
    }

    private static Group getTargetGroup(AcademicOperationType permissionType, PhdProgram program) {
        return AcademicAuthorizationGroup.get(permissionType, (AcademicProgram)((Object)program));
    }

    public static void alertCoordinators(PhdIndividualProgramProcess process2, String subjectKey, String bodyKey) {
        AlertService.alertCoordinators(process2, process2.getCoordinatorsFor(ExecutionYear.readCurrentExecutionYear()), subjectKey, bodyKey);
    }

    private static void alertCoordinators(PhdIndividualProgramProcess process2, Set<Person> persons, String subjectKey, String bodyKey) {
        PhdCustomAlertBean alertBean = new PhdCustomAlertBean(process2, true, false, false);
        alertBean.setSubject(AlertService.getSubjectPrefixed(process2, subjectKey));
        alertBean.setBody(AlertService.getBodyText(process2, bodyKey));
        alertBean.setTargetGroup(UserGroup.of(Person.convertToUsers(persons)));
        alertBean.setFireDate(new LocalDate());
        new PhdCustomAlert(alertBean);
    }

    public static void alertCoordinators(PhdIndividualProgramProcess process2, AlertMessage subject, AlertMessage body) {
        AlertService.alertCoordinators(process2, process2.getCoordinatorsFor(ExecutionYear.readCurrentExecutionYear()), subject, body);
    }

    public static void alertResponsibleCoordinators(PhdIndividualProgramProcess process2, AlertMessage subject, AlertMessage body) {
        AlertService.alertCoordinators(process2, process2.getResponsibleCoordinatorsFor(ExecutionYear.readCurrentExecutionYear()), subject, body);
    }

    private static void alertCoordinators(PhdIndividualProgramProcess process2, Set<Person> persons, AlertMessage subject, AlertMessage body) {
        PhdCustomAlertBean alertBean = new PhdCustomAlertBean(process2, true, false, false);
        alertBean.setSubject(AlertService.getSubjectPrefixed(process2, subject));
        alertBean.setBody(AlertService.getBodyText(process2, body));
        alertBean.setTargetGroup(UserGroup.of(Person.convertToUsers(persons)));
        alertBean.setFireDate(new LocalDate());
        new PhdCustomAlert(alertBean);
    }

    public static String getSubjectPrefixed(PhdIndividualProgramProcess process2, AlertMessage message) {
        return (message.withPrefix() ? AlertService.getProcessNumberPrefix(process2) : "") + message.getMessage();
    }

    public static String getBodyText(PhdIndividualProgramProcess process2, AlertMessage body) {
        return (body.withPrefix() ? AlertService.getBodyCommonText(process2) : "") + body.getMessage();
    }

    public static void alertParticipants(PhdIndividualProgramProcess process2, AlertMessage subject, AlertMessage body, PhdParticipant ... participants) {
        HashSet<Person> toNotify = new HashSet<Person>();
        for (PhdParticipant participant : participants) {
            if (participant.isInternal()) {
                toNotify.add(((InternalPhdParticipant)((Object)participant)).getPerson());
                continue;
            }
            Unit unit = process2.getAdministrativeOffice().getUnit();
            UnitBasedSender sender = (UnitBasedSender)((Object)unit.getUnitBasedSenderSet().iterator().next());
            new Message((Sender)((Object)sender), Collections.emptyList(), Collections.emptyList(), AlertService.getSubjectPrefixed(process2, subject), AlertService.getBodyText(process2, body), Collections.singleton(participant.getEmail()));
        }
        if (!toNotify.isEmpty()) {
            PhdCustomAlertBean alertBean = new PhdCustomAlertBean(process2, true, false, false);
            alertBean.setSubject(AlertService.getSubjectPrefixed(process2, subject));
            alertBean.setBody(AlertService.getBodyText(process2, body));
            alertBean.setTargetGroup(UserGroup.of(Person.convertToUsers(toNotify)));
            alertBean.setFireDate(new LocalDate());
            new PhdCustomAlert(alertBean);
        }
    }

    public static class AlertMessage {
        private String label;
        private Object[] args;
        private boolean isKey = true;
        private boolean withPrefix = true;

        public AlertMessage label(String label) {
            this.label = label;
            return this;
        }

        public AlertMessage args(Object ... args) {
            this.args = args;
            return this;
        }

        public AlertMessage isKey(boolean value) {
            this.isKey = value;
            return this;
        }

        protected boolean withPrefix() {
            return this.withPrefix;
        }

        public AlertMessage withPrefix(boolean value) {
            this.withPrefix = value;
            return this;
        }

        public String getMessage() {
            return this.isKey ? MessageFormat.format(AlertService.getMessageFromResource(this.label), this.args) : this.label;
        }

        public static AlertMessage create(String label, Object ... args) {
            return new AlertMessage().label(label).args(args);
        }

        public static String get(String label, Object ... args) {
            return new AlertMessage().label(label).args(args).getMessage();
        }
    }
}

