/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.curricularRules.CreditsLimit;
import org.fenixedu.academic.domain.curricularRules.CurricularRule;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleType;
import org.fenixedu.academic.domain.curricularRules.DegreeModulesSelectionLimit;
import org.fenixedu.academic.domain.curricularRules.Exclusiveness;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.PreviousYearsEnrolmentCurricularRule;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleLevel;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.EnrolmentResultType;
import org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors.VerifyRuleLevel;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;

public class PreviousYearsEnrolmentByYearExecutor
extends CurricularRuleExecutor {
    private static SkipCollectCurricularCoursesPredicate SKIP_COLLECT_CURRICULAR_COURSES_PREDICATE = (courseGroup, enrolmentContext) -> true;

    @Override
    protected RuleResult executeEnrolmentVerificationWithRules(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        if (this.isEnrollingInCourseGroupsOnly(enrolmentContext, sourceDegreeModuleToEvaluate)) {
            return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        PreviousYearsEnrolmentCurricularRule previousYearsEnrolmentCurricularRule = (PreviousYearsEnrolmentCurricularRule)curricularRule;
        Map<Integer, Set<CurricularCourse>> curricularCoursesToEnrolByYear = this.getCurricularCoursesToEnrolByYear(previousYearsEnrolmentCurricularRule, enrolmentContext, sourceDegreeModuleToEvaluate, false);
        return this.hasAnyCurricularCoursesToEnrolInPreviousYears(enrolmentContext, curricularCoursesToEnrolByYear, sourceDegreeModuleToEvaluate);
    }

    private boolean isEnrollingInCourseGroupsOnly(EnrolmentContext enrolmentContext, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate) {
        for (IDegreeModuleToEvaluate degreeModuleToEvaluate : enrolmentContext.getAllChildDegreeModulesToEvaluateFor(sourceDegreeModuleToEvaluate.getDegreeModule())) {
            if (!degreeModuleToEvaluate.isLeaf()) continue;
            return false;
        }
        return true;
    }

    private Map<Integer, Set<CurricularCourse>> getCurricularCoursesToEnrolByYear(PreviousYearsEnrolmentCurricularRule previousYearsEnrolmentCurricularRule, EnrolmentContext enrolmentContext, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, boolean withTemporaryEnrolments) {
        HashMap<Integer, Set<CurricularCourse>> result = new HashMap<Integer, Set<CurricularCourse>>();
        for (CourseGroup courseGroup : this.getCourseGroupsToEvaluate(previousYearsEnrolmentCurricularRule.getDegreeModuleToApplyRule(), enrolmentContext)) {
            this.collectCourseGroupCurricularCoursesToEnrol(result, courseGroup, enrolmentContext, sourceDegreeModuleToEvaluate, withTemporaryEnrolments);
        }
        return result;
    }

    private Collection<CourseGroup> getCourseGroupsToEvaluate(CourseGroup courseGroup, EnrolmentContext enrolmentContext) {
        if (courseGroup.isRoot()) {
            HashSet<CourseGroup> res = new HashSet<CourseGroup>();
            for (CycleType cycleType : enrolmentContext.getStudentCurricularPlan().getDegreeType().getCycleTypes()) {
                CycleCurriculumGroup cycleCurriculumGroup = enrolmentContext.getStudentCurricularPlan().getRoot().getCycleCurriculumGroup(cycleType);
                if (cycleCurriculumGroup == null) continue;
                if (cycleCurriculumGroup.isExternal()) {
                    throw new DomainException("error.cycleCurriculumGroup.cannot.be.external", new String[0]);
                }
                res.add((CourseGroup)((Object)cycleCurriculumGroup.getDegreeModule()));
            }
            return res;
        }
        return Collections.singleton(courseGroup);
    }

    private void collectCourseGroupCurricularCoursesToEnrol(Map<Integer, Set<CurricularCourse>> result, CourseGroup courseGroup, EnrolmentContext enrolmentContext, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, boolean withTemporaryEnrolments) {
        if (!this.isToCollectCurricularCourses(courseGroup, enrolmentContext, sourceDegreeModuleToEvaluate, withTemporaryEnrolments)) {
            return;
        }
        int childDegreeModulesCount = this.getChildDegreeModulesCount(courseGroup, enrolmentContext);
        this.collectCurricularCoursesToEnrol(result, courseGroup, enrolmentContext, sourceDegreeModuleToEvaluate, withTemporaryEnrolments);
        int minModules = this.getMinModules(courseGroup, enrolmentContext.getExecutionYear());
        int maxModules = this.getMaxModules(courseGroup, enrolmentContext.getExecutionYear());
        if (minModules == maxModules) {
            if (maxModules == childDegreeModulesCount) {
                this.collectChildCourseGroupsCurricularCoursesToEnrol(result, courseGroup, enrolmentContext, sourceDegreeModuleToEvaluate, withTemporaryEnrolments);
            } else if (this.getSelectedChildDegreeModules(courseGroup, enrolmentContext).size() < minModules) {
                this.collectChildCourseGroupsCurricularCoursesToEnrol(result, courseGroup, enrolmentContext, sourceDegreeModuleToEvaluate, withTemporaryEnrolments);
            } else {
                this.collectSelectedChildCourseGroupsCurricularCoursesToEnrol(result, courseGroup, enrolmentContext, sourceDegreeModuleToEvaluate, withTemporaryEnrolments);
            }
        } else if (this.getSelectedChildDegreeModules(courseGroup, enrolmentContext).size() < minModules) {
            this.collectChildCourseGroupsCurricularCoursesToEnrol(result, courseGroup, enrolmentContext, sourceDegreeModuleToEvaluate, withTemporaryEnrolments);
        } else {
            this.collectSelectedChildCourseGroupsCurricularCoursesToEnrol(result, courseGroup, enrolmentContext, sourceDegreeModuleToEvaluate, withTemporaryEnrolments);
        }
    }

    private void collectChildCourseGroupsCurricularCoursesToEnrol(Map<Integer, Set<CurricularCourse>> result, CourseGroup courseGroup, EnrolmentContext enrolmentContext, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, boolean withTemporaryEnrolments) {
        for (DegreeModule childDegreeModule : courseGroup.getChildDegreeModulesValidOn(enrolmentContext.getExecutionYear())) {
            if (!childDegreeModule.isCourseGroup()) continue;
            this.collectCourseGroupCurricularCoursesToEnrol(result, (CourseGroup)((Object)childDegreeModule), enrolmentContext, sourceDegreeModuleToEvaluate, withTemporaryEnrolments);
        }
    }

    private Set<DegreeModule> getSelectedChildDegreeModules(CourseGroup courseGroup, EnrolmentContext enrolmentContext) {
        HashSet<DegreeModule> result = new HashSet<DegreeModule>();
        for (DegreeModule degreeModule : courseGroup.getChildDegreeModulesValidOn(enrolmentContext.getExecutionYear())) {
            CurriculumLine curriculumLine;
            StudentCurricularPlan studentCurricularPlan = enrolmentContext.getStudentCurricularPlan();
            if (!degreeModule.isLeaf()) {
                if (!studentCurricularPlan.hasDegreeModule(degreeModule)) continue;
                result.add(degreeModule);
                continue;
            }
            CurricularCourse curricularCourse = (CurricularCourse)((Object)degreeModule);
            if (!studentCurricularPlan.isApproved(curricularCourse) || (curriculumLine = studentCurricularPlan.getApprovedCurriculumLine(curricularCourse)).getCurriculumGroup().getDegreeModule() == null || curriculumLine.getCurriculumGroup().getDegreeModule() != courseGroup) continue;
            result.add(degreeModule);
        }
        for (IDegreeModuleToEvaluate degreeModuleToEvaluate : enrolmentContext.getDegreeModulesToEvaluate()) {
            if (degreeModuleToEvaluate.getCurriculumGroup() == null || degreeModuleToEvaluate.getCurriculumGroup().getDegreeModule() != courseGroup) continue;
            result.add(degreeModuleToEvaluate.getDegreeModule());
        }
        return result;
    }

    private void collectSelectedChildCourseGroupsCurricularCoursesToEnrol(Map<Integer, Set<CurricularCourse>> result, CourseGroup courseGroup, EnrolmentContext enrolmentContext, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, boolean withTemporaryEnrolments) {
        for (DegreeModule degreeModule : this.getSelectedChildDegreeModules(courseGroup, enrolmentContext)) {
            if (!degreeModule.isCourseGroup()) continue;
            this.collectCourseGroupCurricularCoursesToEnrol(result, (CourseGroup)((Object)degreeModule), enrolmentContext, sourceDegreeModuleToEvaluate, withTemporaryEnrolments);
        }
    }

    private int getMinModules(CourseGroup courseGroup, ExecutionYear executionYear) {
        DegreeModulesSelectionLimit degreeModulesSelectionLimit = courseGroup.getDegreeModulesSelectionLimitRule(executionYear.getFirstExecutionPeriod());
        if (degreeModulesSelectionLimit != null) {
            return degreeModulesSelectionLimit.getMinimumLimit();
        }
        CreditsLimit creditsLimit = courseGroup.getCreditsLimitRule(executionYear.getFirstExecutionPeriod());
        if (creditsLimit != null) {
            DegreeModule degreeModule;
            TreeSet<DegreeModule> sortedChilds = new TreeSet<DegreeModule>(new DegreeModule.ComparatorByMinEcts(executionYear.getFirstExecutionPeriod()));
            sortedChilds.addAll(courseGroup.getChildDegreeModulesValidOn(executionYear));
            int counter = 0;
            double total = 0.0;
            Iterator iterator = sortedChilds.iterator();
            while (iterator.hasNext() && !((total += (degreeModule = (DegreeModule)((Object)iterator.next())).getMinEctsCredits().doubleValue()) > creditsLimit.getMinimumCredits())) {
                ++counter;
            }
            return counter;
        }
        return courseGroup.getChildDegreeModulesValidOn(executionYear).size();
    }

    private int getMaxModules(CourseGroup courseGroup, ExecutionYear executionYear) {
        DegreeModulesSelectionLimit degreeModulesSelectionLimit = courseGroup.getDegreeModulesSelectionLimitRule(executionYear.getFirstExecutionPeriod());
        if (degreeModulesSelectionLimit != null) {
            return degreeModulesSelectionLimit.getMaximumLimit();
        }
        CreditsLimit creditsLimit = courseGroup.getCreditsLimitRule(executionYear.getFirstExecutionPeriod());
        if (creditsLimit != null) {
            DegreeModule degreeModule;
            TreeSet<DegreeModule> sortedChilds = new TreeSet<DegreeModule>(new DegreeModule.ComparatorByMinEcts(executionYear.getFirstExecutionPeriod()));
            sortedChilds.addAll(courseGroup.getChildDegreeModulesValidOn(executionYear));
            int counter = 0;
            double total = 0.0;
            Iterator iterator = sortedChilds.iterator();
            while (iterator.hasNext() && !((total += (degreeModule = (DegreeModule)((Object)iterator.next())).getMaxEctsCredits().doubleValue()) > creditsLimit.getMaximumCredits())) {
                ++counter;
            }
            return counter;
        }
        return courseGroup.getChildDegreeModulesValidOn(executionYear).size();
    }

    private boolean isToCollectCurricularCourses(CourseGroup courseGroup, EnrolmentContext enrolmentContext, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, boolean withTemporaryEnrolments) {
        return !this.isConcluded(courseGroup, enrolmentContext, sourceDegreeModuleToEvaluate, withTemporaryEnrolments) && !this.isExclusiveWithExisting(courseGroup, enrolmentContext) && !PreviousYearsEnrolmentByYearExecutor.hasRuleBypassingPreviousYearsEnrolmentCurricularRule(courseGroup, enrolmentContext) && !this.isConcludedByModules(courseGroup, enrolmentContext) && !PreviousYearsEnrolmentByYearExecutor.getSkipCollectCurricularCoursesPredicate().skip(courseGroup, enrolmentContext);
    }

    public static SkipCollectCurricularCoursesPredicate getSkipCollectCurricularCoursesPredicate() {
        return SKIP_COLLECT_CURRICULAR_COURSES_PREDICATE;
    }

    public static void setSkipCollectCurricularCoursesPredicate(SkipCollectCurricularCoursesPredicate input) {
        if (input != null) {
            SKIP_COLLECT_CURRICULAR_COURSES_PREDICATE = input;
        } else {
            System.out.println("Could not set SKIP_COLLECT_CURRICULAR_COURSES_PREDICATE to null");
        }
    }

    private boolean isConcludedByModules(CourseGroup courseGroup, EnrolmentContext enrolmentContext) {
        int enroledModules;
        CurriculumGroup curriculumGroup = enrolmentContext.getStudentCurricularPlan().findCurriculumGroupFor(courseGroup);
        if (curriculumGroup == null) {
            return false;
        }
        DegreeModulesSelectionLimit degreeModulesSelectionLimit = (DegreeModulesSelectionLimit)((Object)curriculumGroup.getMostRecentActiveCurricularRule(CurricularRuleType.DEGREE_MODULES_SELECTION_LIMIT, enrolmentContext.getExecutionYear()));
        if (degreeModulesSelectionLimit == null) {
            return false;
        }
        int minModulesToApprove = degreeModulesSelectionLimit.getMinimumLimit();
        int approvedModules = curriculumGroup.getCurriculumModulesSet().stream().filter(x -> x.isConcluded(enrolmentContext.getExecutionYear()).value()).collect(Collectors.toSet()).size();
        return approvedModules + (enroledModules = enrolmentContext.getDegreeModulesToEvaluate().stream().filter(x -> x.isLeaf() && x.getCurriculumGroup() == curriculumGroup).collect(Collectors.toSet()).size()) >= minModulesToApprove;
    }

    private boolean isExclusiveWithExisting(CourseGroup courseGroup, EnrolmentContext enrolmentContext) {
        for (Exclusiveness exclusiveness : courseGroup.getExclusivenessRules(enrolmentContext.getExecutionPeriod())) {
            if (!this.isEnroled(enrolmentContext, exclusiveness.getExclusiveDegreeModule())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasRuleBypassingPreviousYearsEnrolmentCurricularRule(CourseGroup courseGroup, EnrolmentContext enrolmentContext) {
        List<CurricularRuleType> bypassing = Arrays.asList(CurricularRuleType.ENROLMENT_TO_BE_APPROVED_BY_COORDINATOR);
        for (CurricularRule curricularRule : courseGroup.getCurricularRules(enrolmentContext.getExecutionPeriod())) {
            if (!bypassing.contains((Object)curricularRule.getCurricularRuleType())) continue;
            return true;
        }
        return false;
    }

    private boolean isConcluded(CourseGroup courseGroup, EnrolmentContext enrolmentContext, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, boolean withTemporaryEnrolments) {
        CurriculumGroup curriculumGroup = enrolmentContext.getStudentCurricularPlan().findCurriculumGroupFor(courseGroup);
        if (curriculumGroup == null) {
            return false;
        }
        double minEctsToApprove = curriculumGroup.getDegreeModule().getMinEctsCredits();
        double totalEcts = this.calculateTotalEctsInGroup(enrolmentContext, curriculumGroup, withTemporaryEnrolments);
        return totalEcts >= minEctsToApprove;
    }

    private int getChildDegreeModulesCount(CourseGroup courseGroup, EnrolmentContext enrolmentContext) {
        int childDegreeModulesCount = 0;
        for (Context context : courseGroup.getChildContextsSet()) {
            if (!context.isOpen(enrolmentContext.getExecutionYear())) continue;
            ++childDegreeModulesCount;
        }
        return childDegreeModulesCount;
    }

    private void collectCurricularCoursesToEnrol(Map<Integer, Set<CurricularCourse>> result, CourseGroup courseGroup, EnrolmentContext enrolmentContext, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, boolean withTemporaryEnrolments) {
        SortedSet<Context> sortedCurricularCoursesContexts = this.getChildCurricularCoursesContextsToEvaluate(courseGroup, enrolmentContext);
        this.removeApprovedOrEnrolledOrEnrollingOrNotSatifyingCurricularRules(sortedCurricularCoursesContexts, enrolmentContext, sourceDegreeModuleToEvaluate, withTemporaryEnrolments);
        this.addValidCurricularCourses(result, sortedCurricularCoursesContexts, courseGroup, enrolmentContext.getExecutionYear());
    }

    private void removeApprovedOrEnrolledOrEnrollingOrNotSatifyingCurricularRules(SortedSet<Context> sortedCurricularCoursesContexts, EnrolmentContext enrolmentContext, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, boolean withTemporaryEnrolments) {
        Iterator iterator = sortedCurricularCoursesContexts.iterator();
        while (iterator.hasNext()) {
            Context context = (Context)iterator.next();
            CurricularCourse curricularCourse = (CurricularCourse)((Object)context.getChildDegreeModule());
            if (this.isApproved(enrolmentContext, curricularCourse)) {
                iterator.remove();
                continue;
            }
            if (this.isEnroled(enrolmentContext, curricularCourse, withTemporaryEnrolments) || this.isEnrolling(enrolmentContext, (DegreeModule)((Object)curricularCourse))) {
                iterator.remove();
                continue;
            }
            if (this.isCurricularRulesSatisfied(enrolmentContext, curricularCourse, sourceDegreeModuleToEvaluate)) continue;
            iterator.remove();
        }
    }

    private void addValidCurricularCourses(Map<Integer, Set<CurricularCourse>> result, Set<Context> curricularCoursesContexts, CourseGroup courseGroup, ExecutionYear executionYear) {
        for (Context context : curricularCoursesContexts) {
            if (!context.isValid(executionYear)) continue;
            this.addCurricularCourse(result, context.getCurricularYear(), (CurricularCourse)((Object)context.getChildDegreeModule()));
        }
    }

    private double calculateTotalEctsInGroup(EnrolmentContext enrolmentContext, CurriculumGroup curriculumGroup, boolean withTemporaryEnrolments) {
        double result = curriculumGroup.getCreditsConcluded(enrolmentContext.getExecutionYear());
        result += curriculumGroup.getEnroledEctsCredits(enrolmentContext.getExecutionYear()).doubleValue();
        if (withTemporaryEnrolments) {
            result += curriculumGroup.getEnroledEctsCredits(enrolmentContext.getExecutionYear().getPreviousExecutionYear()).doubleValue();
        }
        return result;
    }

    private boolean isEnroled(EnrolmentContext enrolmentContext, CurricularCourse curricularCourse, boolean withTemporaryEnrolments) {
        if (withTemporaryEnrolments) {
            return this.isEnroled(enrolmentContext, (DegreeModule)((Object)curricularCourse)) || this.isEnroled(enrolmentContext, curricularCourse, enrolmentContext.getExecutionYear().getPreviousExecutionYear());
        }
        return this.isEnroled(enrolmentContext, (DegreeModule)((Object)curricularCourse));
    }

    private boolean isCurricularRulesSatisfied(EnrolmentContext enrolmentContext, CurricularCourse curricularCourse, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate) {
        RuleResult result = RuleResult.createTrue(sourceDegreeModuleToEvaluate.getDegreeModule());
        for (ICurricularRule curricularRule : curricularCourse.getCurricularRules(enrolmentContext.getExecutionPeriod())) {
            result = result.and(curricularRule.verify(this.getVerifyRuleLevel(enrolmentContext), enrolmentContext, (DegreeModule)((Object)curricularCourse), (CourseGroup)((Object)sourceDegreeModuleToEvaluate.getDegreeModule())));
        }
        return result.isTrue();
    }

    private VerifyRuleLevel getVerifyRuleLevel(EnrolmentContext enrolmentContext) {
        return enrolmentContext.getCurricularRuleLevel() == CurricularRuleLevel.ENROLMENT_WITH_RULES_AND_TEMPORARY_ENROLMENT ? VerifyRuleLevel.ENROLMENT_WITH_RULES_AND_TEMPORARY : VerifyRuleLevel.ENROLMENT_WITH_RULES;
    }

    private SortedSet<Context> getChildCurricularCoursesContextsToEvaluate(CourseGroup courseGroup, EnrolmentContext enrolmentContext) {
        ExecutionYear executionYear = enrolmentContext.getExecutionYear();
        TreeSet<Context> result = new TreeSet<Context>(Context.COMPARATOR_BY_CURRICULAR_YEAR);
        int minModules = this.getMinModules(courseGroup, executionYear);
        int maxModules = this.getMaxModules(courseGroup, executionYear);
        int childDegreeModulesCount = this.getChildDegreeModulesCount(courseGroup, enrolmentContext);
        if (minModules == maxModules) {
            if (maxModules == childDegreeModulesCount) {
                result.addAll(this.getActiveChildCurricularCourses(courseGroup, enrolmentContext));
            } else if (this.getSelectedChildDegreeModules(courseGroup, enrolmentContext).size() < minModules) {
                result.addAll(this.getActiveChildCurricularCourses(courseGroup, enrolmentContext));
            } else {
                result.addAll(this.getSelectedChildCurricularCoursesContexts(courseGroup, enrolmentContext));
            }
        } else if (this.getSelectedChildDegreeModules(courseGroup, enrolmentContext).size() < minModules) {
            result.addAll(this.getActiveChildCurricularCourses(courseGroup, enrolmentContext));
        } else {
            result.addAll(this.getSelectedChildCurricularCoursesContexts(courseGroup, enrolmentContext));
        }
        return result;
    }

    private Set<Context> getActiveChildCurricularCourses(CourseGroup courseGroup, EnrolmentContext enrolmentContext) {
        HashSet<Context> result = new HashSet<Context>();
        for (Context context : courseGroup.getChildContextsSet()) {
            if (!context.isOpen(enrolmentContext.getExecutionYear()) || !context.getChildDegreeModule().isCurricularCourse()) continue;
            result.add(context);
        }
        return result;
    }

    private Set<Context> getSelectedChildCurricularCoursesContexts(CourseGroup courseGroup, EnrolmentContext enrolmentContext) {
        HashSet<Context> result = new HashSet<Context>();
        for (Context context : courseGroup.getChildContextsSet()) {
            CurriculumLine approvedLine;
            if (!context.isOpen(enrolmentContext.getExecutionYear()) || !context.getChildDegreeModule().isCurricularCourse()) continue;
            CurricularCourse curricularCourse = (CurricularCourse)((Object)context.getChildDegreeModule());
            StudentCurricularPlan studentCurricularPlan = enrolmentContext.getStudentCurricularPlan();
            if (!studentCurricularPlan.isApproved(curricularCourse) || (approvedLine = studentCurricularPlan.getApprovedCurriculumLine(curricularCourse)).getCurriculumGroup().getDegreeModule() == null || approvedLine.getCurriculumGroup().getDegreeModule() != courseGroup) continue;
            result.add(context);
        }
        for (IDegreeModuleToEvaluate degreeModuleToEvaluate : enrolmentContext.getDegreeModulesToEvaluate()) {
            if (!degreeModuleToEvaluate.isLeaf() || degreeModuleToEvaluate.getCurriculumGroup() == null || degreeModuleToEvaluate.getCurriculumGroup().getDegreeModule() != courseGroup || degreeModuleToEvaluate.isAnnualCurricularCourse(enrolmentContext.getExecutionYear()) && degreeModuleToEvaluate.getContext() == null) continue;
            Context context = degreeModuleToEvaluate.getContext();
            if (context == null) {
                throw new DomainException("error.degreeModuleToEvaluate.has.invalid.context", degreeModuleToEvaluate.getName(), degreeModuleToEvaluate.getExecutionPeriod().getQualifiedName());
            }
            result.add(context);
        }
        return result;
    }

    private void addCurricularCourse(Map<Integer, Set<CurricularCourse>> result, Integer curricularYear, CurricularCourse curricularCourse) {
        Set<CurricularCourse> curricularCourses = result.get(curricularYear);
        if (curricularCourses == null) {
            curricularCourses = new HashSet<CurricularCourse>();
            result.put(curricularYear, curricularCourses);
        }
        curricularCourses.add(curricularCourse);
    }

    @Override
    protected RuleResult executeEnrolmentWithRulesAndTemporaryEnrolment(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        if (this.isEnrollingInCourseGroupsOnly(enrolmentContext, sourceDegreeModuleToEvaluate)) {
            return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        PreviousYearsEnrolmentCurricularRule previousYearsEnrolmentCurricularRule = (PreviousYearsEnrolmentCurricularRule)curricularRule;
        Map<Integer, Set<CurricularCourse>> curricularCoursesToEnrolByYear = this.getCurricularCoursesToEnrolByYear(previousYearsEnrolmentCurricularRule, enrolmentContext, sourceDegreeModuleToEvaluate, false);
        Map<Integer, Set<CurricularCourse>> curricularCoursesToEnrolByYearWithTemporaries = this.getCurricularCoursesToEnrolByYear(previousYearsEnrolmentCurricularRule, enrolmentContext, sourceDegreeModuleToEvaluate, true);
        return this.hasAnyCurricularCoursesToEnrolInPreviousYears(enrolmentContext, curricularCoursesToEnrolByYear, curricularCoursesToEnrolByYearWithTemporaries, sourceDegreeModuleToEvaluate);
    }

    private RuleResult hasAnyCurricularCoursesToEnrolInPreviousYears(EnrolmentContext enrolmentContext, Map<Integer, Set<CurricularCourse>> curricularCoursesToEnrolByYear, Map<Integer, Set<CurricularCourse>> curricularCoursesToEnrolByYearWithTemporaries, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate) {
        RuleResult result = RuleResult.createTrue(sourceDegreeModuleToEvaluate.getDegreeModule());
        for (IDegreeModuleToEvaluate degreeModuleToEvaluate : enrolmentContext.getAllChildDegreeModulesToEvaluateFor(sourceDegreeModuleToEvaluate.getDegreeModule())) {
            if (!degreeModuleToEvaluate.isLeaf() || degreeModuleToEvaluate.isAnnualCurricularCourse(enrolmentContext.getExecutionYear()) && degreeModuleToEvaluate.getContext() == null) continue;
            if (degreeModuleToEvaluate.getContext() == null) {
                throw new DomainException("error.degreeModuleToEvaluate.has.invalid.context", degreeModuleToEvaluate.getName(), degreeModuleToEvaluate.getExecutionPeriod().getQualifiedName());
            }
            if (this.hasCurricularCoursesToEnrolInPreviousYears(curricularCoursesToEnrolByYearWithTemporaries, degreeModuleToEvaluate.getContext().getCurricularYear())) {
                if (degreeModuleToEvaluate.isEnroled()) {
                    result = result.and(this.createImpossibleRuleResult(sourceDegreeModuleToEvaluate, degreeModuleToEvaluate));
                    continue;
                }
                result = result.and(this.createFalseRuleResult(sourceDegreeModuleToEvaluate, degreeModuleToEvaluate));
                continue;
            }
            if (!this.isAnyPreviousYearCurricularCoursesTemporary(curricularCoursesToEnrolByYear, curricularCoursesToEnrolByYearWithTemporaries, degreeModuleToEvaluate.getContext().getCurricularYear())) continue;
            result = result.and(RuleResult.createTrue(EnrolmentResultType.TEMPORARY, degreeModuleToEvaluate.getDegreeModule()));
        }
        return result;
    }

    private boolean isAnyPreviousYearCurricularCoursesTemporary(Map<Integer, Set<CurricularCourse>> curricularCoursesToEnrolByYear, Map<Integer, Set<CurricularCourse>> curricularCoursesToEnrolByYearWithTemporaries, Integer curricularYear) {
        for (int i = curricularYear.intValue(); i > 0; --i) {
            int previousYear = i - 1;
            if (!curricularCoursesToEnrolByYear.containsKey(previousYear) && !curricularCoursesToEnrolByYearWithTemporaries.containsKey(previousYear)) continue;
            if (curricularCoursesToEnrolByYearWithTemporaries.containsKey(previousYear) && !curricularCoursesToEnrolByYear.containsKey(previousYear) || !curricularCoursesToEnrolByYearWithTemporaries.containsKey(previousYear) && curricularCoursesToEnrolByYear.containsKey(previousYear)) {
                return true;
            }
            if (curricularCoursesToEnrolByYear.get(previousYear).size() == curricularCoursesToEnrolByYearWithTemporaries.get(previousYear).size()) continue;
            return true;
        }
        return false;
    }

    private void printCurricularCoursesToEnrol(Map<Integer, Set<CurricularCourse>> curricularCoursesToEnrolByYear) {
        for (Map.Entry<Integer, Set<CurricularCourse>> entry : curricularCoursesToEnrolByYear.entrySet()) {
            System.out.println("Year " + entry.getKey());
            for (CurricularCourse curricularCourse : entry.getValue()) {
                System.out.println(curricularCourse.getName());
            }
            System.out.println("-------------");
        }
    }

    private RuleResult hasAnyCurricularCoursesToEnrolInPreviousYears(EnrolmentContext enrolmentContext, Map<Integer, Set<CurricularCourse>> curricularCoursesToEnrolByYear, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate) {
        RuleResult result = RuleResult.createTrue(sourceDegreeModuleToEvaluate.getDegreeModule());
        for (IDegreeModuleToEvaluate degreeModuleToEvaluate : enrolmentContext.getAllChildDegreeModulesToEvaluateFor(sourceDegreeModuleToEvaluate.getDegreeModule())) {
            if (!degreeModuleToEvaluate.isLeaf() || degreeModuleToEvaluate.isAnnualCurricularCourse(enrolmentContext.getExecutionYear()) && degreeModuleToEvaluate.getContext() == null) continue;
            if (degreeModuleToEvaluate.getContext() == null) {
                throw new DomainException("error.degreeModuleToEvaluate.has.invalid.context", degreeModuleToEvaluate.getName(), degreeModuleToEvaluate.getExecutionPeriod().getQualifiedName());
            }
            if (!this.hasCurricularCoursesToEnrolInPreviousYears(curricularCoursesToEnrolByYear, degreeModuleToEvaluate.getContext().getCurricularYear())) continue;
            if (degreeModuleToEvaluate.isEnroled()) {
                result = result.and(this.createImpossibleRuleResult(sourceDegreeModuleToEvaluate, degreeModuleToEvaluate));
                continue;
            }
            result = result.and(this.createFalseRuleResult(sourceDegreeModuleToEvaluate, degreeModuleToEvaluate));
        }
        return result;
    }

    private boolean hasCurricularCoursesToEnrolInPreviousYears(Map<Integer, Set<CurricularCourse>> curricularCoursesToEnrolByYear, Integer curricularYear) {
        for (int i = curricularYear.intValue(); i > 0; --i) {
            int previousYear = i - 1;
            if (!curricularCoursesToEnrolByYear.containsKey(previousYear) || curricularCoursesToEnrolByYear.get(previousYear).isEmpty()) continue;
            return true;
        }
        return false;
    }

    private RuleResult createFalseRuleResult(IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, IDegreeModuleToEvaluate degreeModuleToEvaluate) {
        return RuleResult.createFalse(degreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.PreviousYearsEnrolmentByYearExecutor", sourceDegreeModuleToEvaluate.getName(), degreeModuleToEvaluate.getContext().getCurricularYear().toString());
    }

    private RuleResult createImpossibleRuleResult(IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, IDegreeModuleToEvaluate degreeModuleToEvaluate) {
        return RuleResult.createImpossible(degreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.PreviousYearsEnrolmentByYearExecutor", sourceDegreeModuleToEvaluate.getName(), degreeModuleToEvaluate.getContext().getCurricularYear().toString());
    }

    @Override
    protected RuleResult executeEnrolmentInEnrolmentEvaluation(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    @Override
    protected boolean canBeEvaluated(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return true;
    }

    public static interface SkipCollectCurricularCoursesPredicate {
        public boolean skip(CourseGroup var1, EnrolmentContext var2);
    }
}

