/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors;

import org.fenixedu.academic.domain.curricularRules.EvenOddRule;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleExecutor;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;

public class EvenOddExecuter
extends CurricularRuleExecutor {
    @Override
    protected RuleResult executeEnrolmentInEnrolmentEvaluation(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    @Override
    protected RuleResult executeEnrolmentVerificationWithRules(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        EvenOddRule evenOddRule = (EvenOddRule)((Object)curricularRule);
        if (!this.canApplyRule(enrolmentContext, (ICurricularRule)((Object)evenOddRule))) {
            return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        Integer studentNumber = enrolmentContext.getRegistration().getStudent().getNumber();
        if (evenOddRule.getEven().booleanValue() && this.isEven(studentNumber) || !evenOddRule.getEven().booleanValue() && this.isOdd(studentNumber)) {
            return RuleResult.createTrue(sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        return this.createFalseRuleResult(evenOddRule, sourceDegreeModuleToEvaluate);
    }

    @Override
    protected RuleResult executeEnrolmentWithRulesAndTemporaryEnrolment(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return this.executeEnrolmentVerificationWithRules(curricularRule, sourceDegreeModuleToEvaluate, enrolmentContext);
    }

    private RuleResult createFalseRuleResult(EvenOddRule rule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate) {
        return RuleResult.createFalse(sourceDegreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.EvenOddExecutor.invalid.number", rule.getEvenOddString(), rule.getDegreeModuleToApplyRule().getName());
    }

    private boolean isEven(int number) {
        return (number & 1) == 0;
    }

    private boolean isOdd(int number) {
        return (number & 1) != 0;
    }

    @Override
    protected boolean canBeEvaluated(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return true;
    }
}

