/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess.degreeTransfer;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.fenixedu.academic.domain.AcademicProgram;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcessDocumentUploadBean;
import org.fenixedu.academic.domain.candidacyProcess.DegreeOfficePublicCandidacyHashCode;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyDocumentFile;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyDocumentFileType;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyState;
import org.fenixedu.academic.domain.candidacyProcess.degreeTransfer.DegreeTransferCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.degreeTransfer.DegreeTransferIndividualCandidacy;
import org.fenixedu.academic.domain.candidacyProcess.degreeTransfer.DegreeTransferIndividualCandidacyProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.degreeTransfer.DegreeTransferIndividualCandidacyProcess_Base;
import org.fenixedu.academic.domain.candidacyProcess.degreeTransfer.DegreeTransferIndividualCandidacyResultBean;
import org.fenixedu.academic.domain.candidacyProcess.degreeTransfer.DegreeTransferIndividualCandidacySeriesGrade;
import org.fenixedu.academic.domain.caseHandling.Activity;
import org.fenixedu.academic.domain.caseHandling.PreConditionNotValidException;
import org.fenixedu.academic.domain.caseHandling.StartActivity;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.PrecedentDegreeInformation;
import org.fenixedu.bennu.core.domain.User;

public class DegreeTransferIndividualCandidacyProcess
extends DegreeTransferIndividualCandidacyProcess_Base {
    private static List<Activity> activities = new ArrayList<Activity>();

    private DegreeTransferIndividualCandidacyProcess() {
    }

    public DegreeTransferIndividualCandidacyProcess(DegreeTransferIndividualCandidacyProcessBean bean) {
        this();
        this.init(bean);
    }

    protected void createIndividualCandidacy(IndividualCandidacyProcessBean bean) {
        new DegreeTransferIndividualCandidacy(this, (DegreeTransferIndividualCandidacyProcessBean)bean);
    }

    protected void checkParameters(CandidacyProcess candidacyProcess) {
        if (candidacyProcess == null || candidacyProcess.getCandidacyPeriod() == null) {
            throw new DomainException("error.DegreeTransferIndividualCandidacyProcess.invalid.candidacy.process", new String[0]);
        }
    }

    public DegreeTransferCandidacyProcess getCandidacyProcess() {
        return (DegreeTransferCandidacyProcess)((Object)super.getCandidacyProcess());
    }

    public DegreeTransferIndividualCandidacy getCandidacy() {
        return (DegreeTransferIndividualCandidacy)((Object)super.getCandidacy());
    }

    public boolean canExecuteActivity(User userView) {
        return DegreeTransferIndividualCandidacyProcess.isAllowedToManageProcess(this, userView);
    }

    public List<Activity> getActivities() {
        return activities;
    }

    public void editCandidacyInformation(DegreeTransferIndividualCandidacyProcessBean bean) {
        this.getCandidacy().editCandidacyInformation(bean);
    }

    public Degree getCandidacySelectedDegree() {
        return this.getCandidacy().getSelectedDegree();
    }

    public PrecedentDegreeInformation getPrecedentDegreeInformation() {
        return this.getCandidacy().getRefactoredPrecedentDegreeInformation();
    }

    public BigDecimal getCandidacyAffinity() {
        return this.getCandidacy().getAffinity();
    }

    public Integer getCandidacyDegreeNature() {
        return this.getCandidacy().getDegreeNature();
    }

    public BigDecimal getCandidacyApprovedEctsRate() {
        return this.getCandidacy().getApprovedEctsRate();
    }

    public BigDecimal getCandidacyGradeRate() {
        return this.getCandidacy().getGradeRate();
    }

    public BigDecimal getCandidacySeriesCandidacyGrade() {
        return this.getCandidacy().getSeriesCandidacyGrade();
    }

    public boolean hasCandidacyForSelectedDegree(Degree degree) {
        return this.getCandidacySelectedDegree() == degree;
    }

    private static boolean isAllowedToManageProcess(DegreeTransferIndividualCandidacyProcess process2, User userView) {
        if (process2 == null || process2.getCandidacy() == null) {
            return false;
        }
        return AcademicAccessRule.isProgramAccessibleToFunction(AcademicOperationType.MANAGE_INDIVIDUAL_CANDIDACIES, (AcademicProgram)((Object)process2.getCandidacy().getSelectedDegree()), userView.getPerson().getUser());
    }

    public Boolean isCandidacyProcessComplete() {
        return null;
    }

    public List<IndividualCandidacyDocumentFileType> getMissingRequiredDocumentFiles() {
        ArrayList<IndividualCandidacyDocumentFileType> missingDocumentFiles = new ArrayList<IndividualCandidacyDocumentFileType>();
        if (this.getActiveFileForType(IndividualCandidacyDocumentFileType.PHOTO) == null) {
            missingDocumentFiles.add(IndividualCandidacyDocumentFileType.PHOTO);
        }
        if (this.getActiveFileForType(IndividualCandidacyDocumentFileType.CV_DOCUMENT) == null) {
            missingDocumentFiles.add(IndividualCandidacyDocumentFileType.CV_DOCUMENT);
        }
        if (!this.getCandidacy().hasStudent() && this.getActiveFileForType(IndividualCandidacyDocumentFileType.HABILITATION_CERTIFICATE_DOCUMENT) == null) {
            missingDocumentFiles.add(IndividualCandidacyDocumentFileType.HABILITATION_CERTIFICATE_DOCUMENT);
        }
        if (this.getActiveFileForType(IndividualCandidacyDocumentFileType.DOCUMENT_IDENTIFICATION) == null) {
            missingDocumentFiles.add(IndividualCandidacyDocumentFileType.DOCUMENT_IDENTIFICATION);
        }
        if (this.getActiveFileForType(IndividualCandidacyDocumentFileType.PAYMENT_DOCUMENT) == null) {
            missingDocumentFiles.add(IndividualCandidacyDocumentFileType.PAYMENT_DOCUMENT);
        }
        if (this.getCandidacy().getRefactoredPrecedentDegreeInformation().isCandidacyExternal() && this.getActiveFileForType(IndividualCandidacyDocumentFileType.REGISTRATION_CERTIFICATE) == null) {
            missingDocumentFiles.add(IndividualCandidacyDocumentFileType.REGISTRATION_CERTIFICATE);
        }
        if (this.getCandidacy().getRefactoredPrecedentDegreeInformation().isCandidacyExternal() && this.getActiveFileForType(IndividualCandidacyDocumentFileType.NO_PRESCRIPTION_CERTIFICATE) == null) {
            missingDocumentFiles.add(IndividualCandidacyDocumentFileType.NO_PRESCRIPTION_CERTIFICATE);
        }
        if (this.getCandidacy().getRefactoredPrecedentDegreeInformation().isCandidacyExternal() && this.getActiveFileForType(IndividualCandidacyDocumentFileType.FIRST_CYCLE_ACCESS_HABILITATION_CERTIFICATE) == null) {
            missingDocumentFiles.add(IndividualCandidacyDocumentFileType.FIRST_CYCLE_ACCESS_HABILITATION_CERTIFICATE);
        }
        if (this.getCandidacy().getRefactoredPrecedentDegreeInformation().isCandidacyInternal() && this.getActiveFileForType(IndividualCandidacyDocumentFileType.GRADES_DOCUMENT) == null) {
            missingDocumentFiles.add(IndividualCandidacyDocumentFileType.GRADES_DOCUMENT);
        }
        return missingDocumentFiles;
    }

    protected void executeOperationsBeforeDocumentFileBinding(IndividualCandidacyDocumentFile documentFile) {
        IndividualCandidacyDocumentFileType type = documentFile.getCandidacyFileType();
        IndividualCandidacyDocumentFile file = this.getActiveFileForType(type);
        if (file == null) {
            return;
        }
        if (IndividualCandidacyDocumentFileType.REPORT_OR_WORK_DOCUMENT.equals((Object)type)) {
            return;
        }
        file.setCandidacyFileActive(false);
    }

    static {
        activities.add(new CandidacyPayment());
        activities.add(new EditCandidacyPersonalInformation());
        activities.add(new EditCandidacyInformation());
        activities.add(new EditCandidacyCurricularCoursesInformation());
        activities.add(new IntroduceCandidacyResult());
        activities.add(new ChangeIndividualCandidacyState());
        activities.add(new CancelCandidacy());
        activities.add(new CreateRegistration());
        activities.add(new EditPublicCandidacyPersonalInformation());
        activities.add(new EditPublicCandidacyHabilitations());
        activities.add(new EditPublicCandidacyDocumentFile());
        activities.add(new SendEmailForApplicationSubmission());
        activities.add(new EditDocuments());
        activities.add(new ChangeProcessCheckedState());
        activities.add(new RevokeDocumentFile());
        activities.add(new ChangePaymentCheckedState());
        activities.add(new RejectCandidacy());
        activities.add(new RevertApplicationToStandBy());
    }

    private static class RevertApplicationToStandBy
    extends Activity<DegreeTransferIndividualCandidacyProcess> {
        private RevertApplicationToStandBy() {
        }

        @Override
        public void checkPreConditions(DegreeTransferIndividualCandidacyProcess process2, User userView) {
            if (!DegreeTransferIndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isCandidacyCancelled() && !process2.isCandidacyRejected()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeTransferIndividualCandidacyProcess executeActivity(DegreeTransferIndividualCandidacyProcess process2, User userView, Object object) {
            process2.getCandidacy().setState(IndividualCandidacyState.STAND_BY);
            return process2;
        }

        @Override
        public Boolean isVisibleForGriOffice() {
            return false;
        }

        @Override
        public Boolean isVisibleForCoordinator() {
            return false;
        }
    }

    private static class RejectCandidacy
    extends Activity<DegreeTransferIndividualCandidacyProcess> {
        private RejectCandidacy() {
        }

        @Override
        public void checkPreConditions(DegreeTransferIndividualCandidacyProcess process2, User userView) {
            if (!DegreeTransferIndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyInStandBy()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeTransferIndividualCandidacyProcess executeActivity(DegreeTransferIndividualCandidacyProcess process2, User userView, Object object) {
            process2.rejectCandidacy(userView.getPerson());
            return process2;
        }
    }

    protected static class RevokeDocumentFile
    extends Activity<DegreeTransferIndividualCandidacyProcess> {
        protected RevokeDocumentFile() {
        }

        @Override
        public void checkPreConditions(DegreeTransferIndividualCandidacyProcess process2, User userView) {
            if (!DegreeTransferIndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeTransferIndividualCandidacyProcess executeActivity(DegreeTransferIndividualCandidacyProcess process2, User userView, Object object) {
            ((CandidacyProcessDocumentUploadBean)object).getDocumentFile().setCandidacyFileActive(Boolean.FALSE);
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return Boolean.FALSE;
        }
    }

    private static class ChangePaymentCheckedState
    extends Activity<DegreeTransferIndividualCandidacyProcess> {
        private ChangePaymentCheckedState() {
        }

        @Override
        public void checkPreConditions(DegreeTransferIndividualCandidacyProcess process2, User userView) {
            if (!DegreeTransferIndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeTransferIndividualCandidacyProcess executeActivity(DegreeTransferIndividualCandidacyProcess process2, User userView, Object object) {
            process2.setPaymentChecked(((IndividualCandidacyProcessBean)object).getPaymentChecked());
            return process2;
        }
    }

    private static class ChangeProcessCheckedState
    extends Activity<DegreeTransferIndividualCandidacyProcess> {
        private ChangeProcessCheckedState() {
        }

        @Override
        public void checkPreConditions(DegreeTransferIndividualCandidacyProcess process2, User userView) {
            if (!DegreeTransferIndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeTransferIndividualCandidacyProcess executeActivity(DegreeTransferIndividualCandidacyProcess process2, User userView, Object object) {
            process2.setProcessChecked(((IndividualCandidacyProcessBean)object).getProcessChecked());
            return process2;
        }
    }

    private static class EditDocuments
    extends Activity<DegreeTransferIndividualCandidacyProcess> {
        private EditDocuments() {
        }

        @Override
        public void checkPreConditions(DegreeTransferIndividualCandidacyProcess process2, User userView) {
            if (!DegreeTransferIndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeTransferIndividualCandidacyProcess executeActivity(DegreeTransferIndividualCandidacyProcess process2, User userView, Object object) {
            CandidacyProcessDocumentUploadBean bean = (CandidacyProcessDocumentUploadBean)object;
            process2.bindIndividualCandidacyDocumentFile(bean);
            return process2;
        }
    }

    private static class EditPublicCandidacyHabilitations
    extends Activity<DegreeTransferIndividualCandidacyProcess> {
        private EditPublicCandidacyHabilitations() {
        }

        @Override
        public void checkPreConditions(DegreeTransferIndividualCandidacyProcess process2, User userView) {
            if (!process2.isCandidacyInStandBy()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeTransferIndividualCandidacyProcess executeActivity(DegreeTransferIndividualCandidacyProcess process2, User userView, Object object) {
            DegreeTransferIndividualCandidacyProcessBean bean = (DegreeTransferIndividualCandidacyProcessBean)object;
            process2.editCandidacyHabilitations(bean);
            process2.getCandidacy().editSelectedDegree(bean.getSelectedDegree());
            process2.getCandidacy().editObservations(bean);
            process2.editPrecedentDegreeInformation(bean);
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return Boolean.FALSE;
        }
    }

    private static class EditPublicCandidacyDocumentFile
    extends Activity<DegreeTransferIndividualCandidacyProcess> {
        private EditPublicCandidacyDocumentFile() {
        }

        @Override
        public void checkPreConditions(DegreeTransferIndividualCandidacyProcess process2, User userView) {
            if (!process2.isCandidacyInStandBy()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeTransferIndividualCandidacyProcess executeActivity(DegreeTransferIndividualCandidacyProcess process2, User userView, Object object) {
            CandidacyProcessDocumentUploadBean bean = (CandidacyProcessDocumentUploadBean)object;
            process2.bindIndividualCandidacyDocumentFile(bean);
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return Boolean.FALSE;
        }
    }

    private static class EditPublicCandidacyPersonalInformation
    extends Activity<DegreeTransferIndividualCandidacyProcess> {
        private EditPublicCandidacyPersonalInformation() {
        }

        @Override
        public void checkPreConditions(DegreeTransferIndividualCandidacyProcess process2, User userView) {
            if (!process2.isCandidacyInStandBy()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeTransferIndividualCandidacyProcess executeActivity(DegreeTransferIndividualCandidacyProcess process2, User userView, Object object) {
            process2.editPersonalCandidacyInformation(((DegreeTransferIndividualCandidacyProcessBean)object).getPersonBean());
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return Boolean.FALSE;
        }
    }

    private static class CreateRegistration
    extends Activity<DegreeTransferIndividualCandidacyProcess> {
        private CreateRegistration() {
        }

        @Override
        public void checkPreConditions(DegreeTransferIndividualCandidacyProcess process2, User userView) {
            if (!DegreeTransferIndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isCandidacyAccepted()) {
                throw new PreConditionNotValidException();
            }
            if (process2.hasRegistrationForCandidacy()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeTransferIndividualCandidacyProcess executeActivity(DegreeTransferIndividualCandidacyProcess process2, User userView, Object object) {
            process2.getCandidacy().createRegistration(this.getDegreeCurricularPlan(process2), CycleType.FIRST_CYCLE, IngressionType.findByPredicate(IngressionType::isTransfer).orElse(null));
            return process2;
        }

        private DegreeCurricularPlan getDegreeCurricularPlan(DegreeTransferIndividualCandidacyProcess process2) {
            return process2.getCandidacySelectedDegree().getLastActiveDegreeCurricularPlan();
        }
    }

    private static class CancelCandidacy
    extends Activity<DegreeTransferIndividualCandidacyProcess> {
        private CancelCandidacy() {
        }

        @Override
        public void checkPreConditions(DegreeTransferIndividualCandidacyProcess process2, User userView) {
            if (!DegreeTransferIndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.hasAnyPaymentForCandidacy() || !process2.isCandidacyInStandBy()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeTransferIndividualCandidacyProcess executeActivity(DegreeTransferIndividualCandidacyProcess process2, User userView, Object object) {
            process2.cancelCandidacy(userView.getPerson());
            return process2;
        }
    }

    private static class ChangeIndividualCandidacyState
    extends Activity<DegreeTransferIndividualCandidacyProcess> {
        private ChangeIndividualCandidacyState() {
        }

        @Override
        public void checkPreConditions(DegreeTransferIndividualCandidacyProcess process2, User userView) {
            if (!DegreeTransferIndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled()) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isCandidacyDebtPayed()) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isSentToCoordinator() && !process2.isSentToScientificCouncil()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeTransferIndividualCandidacyProcess executeActivity(DegreeTransferIndividualCandidacyProcess process2, User userView, Object object) {
            DegreeTransferIndividualCandidacyResultBean bean = (DegreeTransferIndividualCandidacyResultBean)object;
            process2.getCandidacy().setState(bean.getState());
            return process2;
        }
    }

    private static class IntroduceCandidacyResult
    extends Activity<DegreeTransferIndividualCandidacyProcess> {
        private IntroduceCandidacyResult() {
        }

        @Override
        public void checkPreConditions(DegreeTransferIndividualCandidacyProcess process2, User userView) {
            if (!DegreeTransferIndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled() || !process2.isCandidacyDebtPayed()) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isSentToCoordinator()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeTransferIndividualCandidacyProcess executeActivity(DegreeTransferIndividualCandidacyProcess process2, User userView, Object object) {
            DegreeTransferIndividualCandidacyResultBean bean = (DegreeTransferIndividualCandidacyResultBean)object;
            DegreeTransferIndividualCandidacySeriesGrade degreeTransferIndividualCandidacySeriesGrade = process2.getCandidacy().getDegreeTransferIndividualCandidacySeriesGradeForDegree(bean.getDegree());
            degreeTransferIndividualCandidacySeriesGrade.setAffinity(bean.getAffinity());
            degreeTransferIndividualCandidacySeriesGrade.setDegreeNature(bean.getDegreeNature());
            degreeTransferIndividualCandidacySeriesGrade.setApprovedEctsRate(bean.getApprovedEctsRate());
            degreeTransferIndividualCandidacySeriesGrade.setGradeRate(bean.getGradeRate());
            degreeTransferIndividualCandidacySeriesGrade.setSeriesCandidacyGrade(bean.getSeriesCandidacyGrade());
            degreeTransferIndividualCandidacySeriesGrade.setState(bean.getSeriesGradeState());
            return process2;
        }
    }

    private static class EditCandidacyCurricularCoursesInformation
    extends Activity<DegreeTransferIndividualCandidacyProcess> {
        private EditCandidacyCurricularCoursesInformation() {
        }

        @Override
        public void checkPreConditions(DegreeTransferIndividualCandidacyProcess process2, User userView) {
            if (!DegreeTransferIndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled()) {
                throw new PreConditionNotValidException();
            }
            if (process2.isInStandBy()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeTransferIndividualCandidacyProcess executeActivity(DegreeTransferIndividualCandidacyProcess process2, User userView, Object object) {
            return process2;
        }
    }

    private static class EditCandidacyInformation
    extends Activity<DegreeTransferIndividualCandidacyProcess> {
        private EditCandidacyInformation() {
        }

        @Override
        public void checkPreConditions(DegreeTransferIndividualCandidacyProcess process2, User userView) {
            if (!DegreeTransferIndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled() || process2.isCandidacyAccepted() || process2.hasRegistrationForCandidacy()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeTransferIndividualCandidacyProcess executeActivity(DegreeTransferIndividualCandidacyProcess process2, User userView, Object object) {
            process2.editCandidacyHabilitations((DegreeTransferIndividualCandidacyProcessBean)object);
            process2.getCandidacy().editObservations((DegreeTransferIndividualCandidacyProcessBean)object);
            process2.editCandidacyInformation((DegreeTransferIndividualCandidacyProcessBean)object);
            process2.getCandidacy().setUtlStudent(((DegreeTransferIndividualCandidacyProcessBean)object).getUtlStudent());
            return process2;
        }
    }

    private static class EditCandidacyPersonalInformation
    extends Activity<DegreeTransferIndividualCandidacyProcess> {
        private EditCandidacyPersonalInformation() {
        }

        @Override
        public void checkPreConditions(DegreeTransferIndividualCandidacyProcess process2, User userView) {
            if (!DegreeTransferIndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeTransferIndividualCandidacyProcess executeActivity(DegreeTransferIndividualCandidacyProcess process2, User userView, Object object) {
            process2.editPersonalCandidacyInformation(((DegreeTransferIndividualCandidacyProcessBean)object).getPersonBean());
            return process2;
        }
    }

    private static class CandidacyPayment
    extends Activity<DegreeTransferIndividualCandidacyProcess> {
        private CandidacyPayment() {
        }

        @Override
        public void checkPreConditions(DegreeTransferIndividualCandidacyProcess process2, User userView) {
            if (!DegreeTransferIndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeTransferIndividualCandidacyProcess executeActivity(DegreeTransferIndividualCandidacyProcess process2, User userView, Object object) {
            return null;
        }
    }

    public static class SendEmailForApplicationSubmission
    extends Activity<DegreeTransferIndividualCandidacyProcess> {
        @Override
        public void checkPreConditions(DegreeTransferIndividualCandidacyProcess process2, User userView) {
        }

        @Override
        protected DegreeTransferIndividualCandidacyProcess executeActivity(DegreeTransferIndividualCandidacyProcess process2, User userView, Object object) {
            DegreeOfficePublicCandidacyHashCode hashCode = (DegreeOfficePublicCandidacyHashCode)((Object)object);
            hashCode.sendEmailForApplicationSuccessfullySubmited();
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return Boolean.FALSE;
        }
    }

    @StartActivity
    public static class IndividualCandidacyInformation
    extends Activity<DegreeTransferIndividualCandidacyProcess> {
        @Override
        public void checkPreConditions(DegreeTransferIndividualCandidacyProcess process2, User userView) {
        }

        @Override
        protected DegreeTransferIndividualCandidacyProcess executeActivity(DegreeTransferIndividualCandidacyProcess dummy, User userView, Object object) {
            DegreeTransferIndividualCandidacyProcessBean bean = (DegreeTransferIndividualCandidacyProcessBean)object;
            return new DegreeTransferIndividualCandidacyProcess(bean);
        }
    }
}

