/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess;

import java.math.BigDecimal;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.candidacyProcess.ExternalPrecedentDegreeInformation_Base;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacy;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.joda.time.LocalDate;

@Deprecated
public class ExternalPrecedentDegreeInformation
extends ExternalPrecedentDegreeInformation_Base {
    private ExternalPrecedentDegreeInformation() {
    }

    private ExternalPrecedentDegreeInformation(IndividualCandidacy candidacy, String degreeDesignation, LocalDate conclusionDate, Unit sourceInstitution, String conclusionGrade, Country country) {
        this();
        this.checkParameters(candidacy, degreeDesignation, sourceInstitution, conclusionGrade);
        this.setDegreeDesignation(degreeDesignation);
        this.setConclusionDate(conclusionDate);
        this.setSourceInstitution(sourceInstitution);
        this.setConclusionGrade(conclusionGrade);
        this.setCountry(country);
    }

    private void checkParameters(IndividualCandidacy candidacy, String degreeDesignation, Unit sourceInstitution, String conclusionGrade) {
        if (candidacy == null) {
            throw new DomainException("error.ExternalPrecedentDegreeInformation.invalid.candidacy", new String[0]);
        }
        if (degreeDesignation == null || degreeDesignation.length() == 0) {
            throw new DomainException("error.ExternalPrecedentDegreeInformation.invalid.degreeDesignation", new String[0]);
        }
        if (sourceInstitution == null) {
            throw new DomainException("error.ExternalPrecedentDegreeInformation.invalid.institution", new String[0]);
        }
    }

    public boolean isExternal() {
        return true;
    }

    public void init(Integer numberOfEnroledCurricularCourses, Integer numberOfApprovedCurricularCourses, BigDecimal gradeSum, BigDecimal approvedEcts, BigDecimal enroledEcts) {
        this.checkParameters(numberOfEnroledCurricularCourses, numberOfApprovedCurricularCourses, gradeSum, approvedEcts, enroledEcts);
        this.setNumberOfEnroledCurricularCourses(numberOfEnroledCurricularCourses);
        this.setNumberOfApprovedCurricularCourses(numberOfApprovedCurricularCourses);
        this.setGradeSum(gradeSum);
        this.setApprovedEcts(approvedEcts);
        this.setEnroledEcts(enroledEcts);
    }

    private void checkParameters(Integer numberOfEnroledCurricularCourses, Integer numberOfApprovedCurricularCourses, BigDecimal gradeSum, BigDecimal approvedEcts, BigDecimal enroledEcts) {
        if (numberOfEnroledCurricularCourses != null && numberOfEnroledCurricularCourses == 0) {
            throw new DomainException("error.ExternalPrecedentDegreeInformation.invalid.numberOfEnroledCurricularCourses", new String[0]);
        }
        if (numberOfApprovedCurricularCourses != null && numberOfApprovedCurricularCourses == 0) {
            throw new DomainException("error.ExternalPrecedentDegreeInformation.invalid.numberOfApprovedCurricularCourses", new String[0]);
        }
        this.checkBigDecimal(gradeSum, "gradeSum");
        this.checkBigDecimal(approvedEcts, "approvedEcts");
        this.checkBigDecimal(enroledEcts, "enroledEcts");
    }

    private void checkBigDecimal(BigDecimal value, String property) {
        if (value != null && value.signum() == 0) {
            throw new DomainException("error.ExternalPrecedentDegreeInformation.invalid." + property, new String[0]);
        }
    }

    public Integer getConclusionYear() {
        if (super.getConclusionYear() != null) {
            return super.getConclusionYear();
        }
        return this.getConclusionDate() != null ? Integer.valueOf(this.getConclusionDate().getYear()) : null;
    }
}

