/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules.dfa;

import java.util.Collection;
import java.util.Set;
import org.fenixedu.academic.domain.accounting.Account;
import org.fenixedu.academic.domain.accounting.AccountingTransaction;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.events.dfa.DFACandidacyEvent;
import org.fenixedu.academic.domain.accounting.postingRules.FixedAmountWithPenaltyPR;
import org.fenixedu.academic.domain.accounting.postingRules.dfa.DFACandidacyPR_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.accounting.AccountingTransactionDetailDTO;
import org.fenixedu.academic.dto.accounting.EntryDTO;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.DateTime;

public class DFACandidacyPR
extends DFACandidacyPR_Base {
    private DFACandidacyPR() {
    }

    public DFACandidacyPR(DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money fixedAmount, Money fixedAmountPenalty) {
        this();
        super.init(EntryType.CANDIDACY_ENROLMENT_FEE, EventType.CANDIDACY_ENROLMENT, startDate, endDate, serviceAgreementTemplate, fixedAmount, fixedAmountPenalty);
    }

    protected boolean hasPenalty(Event event, DateTime when) {
        DFACandidacyEvent dfaCandidacyEvent = (DFACandidacyEvent)((Object)event);
        return dfaCandidacyEvent.hasCandidacyPeriodInDegreeCurricularPlan() && !dfaCandidacyEvent.getCandidacyPeriodInDegreeCurricularPlan().containsDate(dfaCandidacyEvent.getCandidacyDate());
    }

    public FixedAmountWithPenaltyPR edit(Money fixedAmount, Money penaltyAmount) {
        this.deactivate();
        return new DFACandidacyPR(new DateTime().minus(1000L), null, this.getServiceAgreementTemplate(), fixedAmount, penaltyAmount);
    }

    protected Set<AccountingTransaction> internalProcess(User user, Collection<EntryDTO> entryDTOs, Event event, Account fromAccount, Account toAccount, AccountingTransactionDetailDTO transactionDetail) {
        this.checkPreconditionsToProcess(event);
        return super.internalProcess(user, entryDTOs, event, fromAccount, toAccount, transactionDetail);
    }

    private void checkPreconditionsToProcess(Event event) {
        DFACandidacyEvent dfaCandidacyEvent = (DFACandidacyEvent)((Object)event);
        if (!dfaCandidacyEvent.hasCandidacyPeriodInDegreeCurricularPlan()) {
            throw new DomainException("error.accounting.postingRules.dfa.DFACandidacyPR.cannot.process.without.candidacy.period.defined", new String[0]);
        }
    }
}

