/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.fenixedu.academic.domain.accounting.AccountingTransaction;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.events.AdministrativeOfficeFeeAndInsuranceEvent;
import org.fenixedu.academic.domain.accounting.events.AdministrativeOfficeFeeAndInsurancePenaltyExemption;
import org.fenixedu.academic.domain.accounting.postingRules.AdministrativeOfficeFeePR_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.accounting.EntryDTO;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;

public class AdministrativeOfficeFeePR
extends AdministrativeOfficeFeePR_Base {
    protected AdministrativeOfficeFeePR() {
    }

    public AdministrativeOfficeFeePR(DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money fixedAmount, Money fixedAmountPenalty, YearMonthDay whenToApplyFixedAmountPenalty) {
        this();
        this.init(EntryType.ADMINISTRATIVE_OFFICE_FEE, EventType.ADMINISTRATIVE_OFFICE_FEE, startDate, endDate, serviceAgreementTemplate, fixedAmount, fixedAmountPenalty, whenToApplyFixedAmountPenalty);
    }

    protected boolean hasPenalty(Event event, DateTime when) {
        if (event.hasAnyPenaltyExemptionsFor(AdministrativeOfficeFeeAndInsurancePenaltyExemption.class)) {
            return false;
        }
        AdministrativeOfficeFeeAndInsuranceEvent administrativeOfficeFeeAndInsuranceEvent = (AdministrativeOfficeFeeAndInsuranceEvent)((Object)event);
        YearMonthDay paymentEndDate = administrativeOfficeFeeAndInsuranceEvent.getPaymentEndDate() != null ? administrativeOfficeFeeAndInsuranceEvent.getPaymentEndDate() : this.getWhenToApplyFixedAmountPenalty();
        Money amountPayedUntilEndDate = this.calculateAmountPayedUntilEndDate(administrativeOfficeFeeAndInsuranceEvent, paymentEndDate);
        if (!when.toYearMonthDay().isAfter((ReadablePartial)paymentEndDate)) {
            return false;
        }
        return amountPayedUntilEndDate.lessThan(this.getFixedAmount());
    }

    private Money calculateAmountPayedUntilEndDate(AdministrativeOfficeFeeAndInsuranceEvent event, YearMonthDay paymentEndDate) {
        Money result = Money.ZERO;
        for (AccountingTransaction transaction : event.getNonAdjustingTransactions()) {
            if (transaction.getToAccountEntry().getEntryType() != this.getEntryType() || transaction.getWhenRegistered().toYearMonthDay().isAfter((ReadablePartial)paymentEndDate)) continue;
            result = result.add(transaction.getAmountWithAdjustment());
        }
        return result;
    }

    public AdministrativeOfficeFeePR edit(DateTime startDate, Money fixedAmount, Money penaltyAmount, YearMonthDay whenToApplyFixedAmountPenalty) {
        if (!startDate.isAfter((ReadableInstant)this.getStartDate())) {
            throw new DomainException("error.AdministrativeOfficeFeePR.startDate.is.before.then.start.date.of.previous.posting.rule", new String[0]);
        }
        this.deactivate(startDate);
        return new AdministrativeOfficeFeePR(startDate.minus(1000L), null, this.getServiceAgreementTemplate(), fixedAmount, penaltyAmount, whenToApplyFixedAmountPenalty);
    }

    protected Money subtractFromExemptions(Event event, DateTime when, boolean applyDiscount, Money amountToPay) {
        if (!applyDiscount) {
            return amountToPay;
        }
        AdministrativeOfficeFeeAndInsuranceEvent administrativeOfficeFeeAndInsuranceEvent = (AdministrativeOfficeFeeAndInsuranceEvent)((Object)event);
        return administrativeOfficeFeeAndInsuranceEvent.hasAdministrativeOfficeFeeAndInsuranceExemption() ? Money.ZERO : amountToPay;
    }

    public List<EntryDTO> calculateEntries(Event event, DateTime when) {
        ArrayList<EntryDTO> result = new ArrayList<EntryDTO>(super.calculateEntries(event, when));
        HashMap<EntryType, Money> payedAmounts = new HashMap<EntryType, Money>();
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            EntryDTO entryDTO = (EntryDTO)iterator.next();
            Money payedAmount = (Money)payedAmounts.get((Object)entryDTO.getEntryType());
            if (payedAmount == null) {
                payedAmount = event.getPayedAmountFor(entryDTO.getEntryType());
            }
            entryDTO.setAmountToPay(entryDTO.getAmountToPay().subtract(payedAmount));
            if (!entryDTO.getAmountToPay().isPositive()) {
                iterator.remove();
                payedAmount = entryDTO.getAmountToPay().abs();
                payedAmounts.put(entryDTO.getEntryType(), payedAmount);
                continue;
            }
            payedAmounts.put(entryDTO.getEntryType(), Money.ZERO);
        }
        return result;
    }
}

