/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.accounting.Account;
import org.fenixedu.academic.domain.accounting.AccountingTransaction;
import org.fenixedu.academic.domain.accounting.Entry;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.events.AdministrativeOfficeFeeAndInsuranceEvent;
import org.fenixedu.academic.domain.accounting.events.AnnualEvent;
import org.fenixedu.academic.domain.accounting.postingRules.AdministrativeOfficeFeeAndInsurancePR_Base;
import org.fenixedu.academic.domain.accounting.postingRules.AdministrativeOfficeFeePR;
import org.fenixedu.academic.domain.accounting.postingRules.FixedAmountPR;
import org.fenixedu.academic.domain.accounting.serviceAgreementTemplates.UnitServiceAgreementTemplate;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.accounting.AccountingTransactionDetailDTO;
import org.fenixedu.academic.dto.accounting.EntryDTO;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.DateTime;
import org.joda.time.YearMonthDay;

public class AdministrativeOfficeFeeAndInsurancePR
extends AdministrativeOfficeFeeAndInsurancePR_Base {
    protected AdministrativeOfficeFeeAndInsurancePR() {
    }

    public AdministrativeOfficeFeeAndInsurancePR(DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate) {
        this();
        super.init(EventType.ADMINISTRATIVE_OFFICE_FEE_INSURANCE, startDate, endDate, serviceAgreementTemplate);
    }

    protected Money doCalculationForAmountToPay(Event event, DateTime when, boolean applyDiscount) {
        AnnualEvent annualEvent = (AnnualEvent)((Object)event);
        return this.getPostingRuleForAdministrativeOfficeFee(annualEvent.getStartDate(), annualEvent.getEndDate()).calculateTotalAmountToPay(event, when, applyDiscount).add(this.getPostingRuleForInsurance(annualEvent.getStartDate(), annualEvent.getEndDate()).calculateTotalAmountToPay(event, when, applyDiscount));
    }

    protected Money subtractFromExemptions(Event event, DateTime when, boolean applyDiscount, Money amountToPay) {
        return amountToPay;
    }

    public List<EntryDTO> calculateEntries(Event event, DateTime when) {
        ArrayList<EntryDTO> result = new ArrayList<EntryDTO>();
        AdministrativeOfficeFeeAndInsuranceEvent administrativeOfficeFeeAndInsuranceEvent = (AdministrativeOfficeFeeAndInsuranceEvent)((Object)event);
        AnnualEvent annualEvent = (AnnualEvent)((Object)event);
        if (administrativeOfficeFeeAndInsuranceEvent.hasToPayAdministrativeOfficeFee()) {
            result.addAll(this.getPostingRuleForAdministrativeOfficeFee(annualEvent.getStartDate(), annualEvent.getEndDate()).calculateEntries(event, when));
        }
        if (administrativeOfficeFeeAndInsuranceEvent.hasToPayInsurance()) {
            result.addAll(this.getPostingRuleForInsurance(annualEvent.getStartDate(), annualEvent.getEndDate()).calculateEntries(event, when));
        }
        return result;
    }

    protected Set<AccountingTransaction> internalProcess(User user, Collection<EntryDTO> entryDTOs, Event event, Account fromAccount, Account toAccount, AccountingTransactionDetailDTO transactionDetail) {
        HashSet<AccountingTransaction> result = new HashSet<AccountingTransaction>();
        HashSet createdEntries = new HashSet();
        AnnualEvent annualEvent = (AnnualEvent)((Object)event);
        for (EntryDTO entryDTO : entryDTOs) {
            if (entryDTO.getEntryType() == EntryType.INSURANCE_FEE) {
                createdEntries.addAll(this.getPostingRuleForInsurance(annualEvent.getStartDate(), annualEvent.getEndDate()).process(user, Collections.singletonList(entryDTO), event, fromAccount, toAccount, transactionDetail));
                continue;
            }
            if (entryDTO.getEntryType() == EntryType.ADMINISTRATIVE_OFFICE_FEE) {
                createdEntries.addAll(this.getPostingRuleForAdministrativeOfficeFee(annualEvent.getStartDate(), annualEvent.getEndDate()).process(user, Collections.singletonList(entryDTO), event, fromAccount, toAccount, transactionDetail));
                continue;
            }
            throw new DomainException("error.accounting.postingRules.AdministrativeOfficeFeeAndInsurancePR.invalid.entry.type", new String[0]);
        }
        ((AdministrativeOfficeFeeAndInsuranceEvent)((Object)event)).changePaymentCodeState(transactionDetail.getWhenRegistered(), transactionDetail.getPaymentMode());
        for (Entry entry : createdEntries) {
            result.add(entry.getAccountingTransaction());
        }
        return result;
    }

    private FixedAmountPR getPostingRuleForInsurance(DateTime startDate, DateTime endDate) {
        return (FixedAmountPR)((Object)this.getServiceAgreementTemplateForInsurance().findPostingRuleBy(EventType.INSURANCE, startDate, endDate));
    }

    private AdministrativeOfficeFeePR getPostingRuleForAdministrativeOfficeFee(DateTime startDate, DateTime endDate) {
        return (AdministrativeOfficeFeePR)((Object)this.getServiceAgreementTemplate().findPostingRuleBy(EventType.ADMINISTRATIVE_OFFICE_FEE, startDate, endDate));
    }

    public UnitServiceAgreementTemplate getServiceAgreementTemplateForInsurance() {
        return Bennu.getInstance().getInstitutionUnit().getUnitServiceAgreementTemplate();
    }

    public boolean isVisible() {
        return false;
    }

    public Money getAdministrativeOfficeFeeAmount(DateTime startDate, DateTime endDate) {
        return this.getPostingRuleForAdministrativeOfficeFee(startDate, endDate).getFixedAmount();
    }

    public YearMonthDay getAdministrativeOfficeFeePaymentLimitDate(DateTime startDate, DateTime endDate) {
        return this.getPostingRuleForAdministrativeOfficeFee(startDate, endDate).getWhenToApplyFixedAmountPenalty();
    }

    public Money getAdministrativeOfficeFeePenaltyAmount(DateTime startDate, DateTime endDate) {
        return this.getPostingRuleForAdministrativeOfficeFee(startDate, endDate).getFixedAmountPenalty();
    }

    public Money getInsuranceAmount(DateTime startDate, DateTime endDate) {
        return this.getPostingRuleForInsurance(startDate, endDate).getFixedAmount();
    }

    public AccountingTransaction depositAmount(User responsibleUser, Event event, Account fromAcount, Account toAccount, Money amount, EntryType entryType, AccountingTransactionDetailDTO transactionDetailDTO) {
        AnnualEvent annualEvent = (AnnualEvent)((Object)event);
        if (entryType == EntryType.INSURANCE_FEE) {
            return this.getPostingRuleForInsurance(annualEvent.getStartDate(), annualEvent.getEndDate()).depositAmount(responsibleUser, event, fromAcount, toAccount, amount, transactionDetailDTO);
        }
        if (entryType == EntryType.ADMINISTRATIVE_OFFICE_FEE) {
            return this.getPostingRuleForAdministrativeOfficeFee(annualEvent.getStartDate(), annualEvent.getEndDate()).depositAmount(responsibleUser, event, fromAcount, toAccount, amount, transactionDetailDTO);
        }
        throw new DomainException("error.AdministrativeOfficeFeeAndInsurancePR.unsupported.entry.type", new String[0]);
    }
}

