/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.installments;

import java.math.BigDecimal;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.PaymentPlan;
import org.fenixedu.academic.domain.accounting.installments.InstallmentWithPenalty_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateTime;
import org.joda.time.YearMonthDay;

public abstract class InstallmentWithPenalty
extends InstallmentWithPenalty_Base {
    protected InstallmentWithPenalty() {
    }

    protected void init(PaymentPlan paymentCondition, Money amount, YearMonthDay startDate, YearMonthDay endDate, BigDecimal penaltyPercentage) {
        super.init(paymentCondition, amount, startDate, endDate);
        this.checkParameters(penaltyPercentage);
        super.setPenaltyPercentage(penaltyPercentage);
    }

    private void checkParameters(BigDecimal penaltyPercentage) {
        if (penaltyPercentage == null) {
            throw new DomainException("error.accounting.installments.InstallmentWithPenalty.penaltyPercentage.cannot.be.null", new String[0]);
        }
    }

    public Money calculateAmount(Event event, DateTime when, BigDecimal discountPercentage, boolean applyPenalty) {
        return super.calculateAmount(event, when, discountPercentage, applyPenalty).add(applyPenalty ? this.calculatePenaltyAmount(event, when, discountPercentage) : Money.ZERO);
    }

    protected abstract Money calculatePenaltyAmount(Event var1, DateTime var2, BigDecimal var3);
}

