/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events.serviceRequests;

import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.events.serviceRequests.PhdDiplomaRequestEvent_Base;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.serviceRequests.documentRequests.PhdDiplomaRequest;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.util.LabelFormatter;

public class PhdDiplomaRequestEvent
extends PhdDiplomaRequestEvent_Base {
    protected PhdDiplomaRequestEvent() {
    }

    protected PhdDiplomaRequestEvent(AdministrativeOffice administrativeOffice, EventType eventType, Person person, AcademicServiceRequest academicServiceRequest) {
        this();
        if (!academicServiceRequest.isDiploma()) {
            throw new DomainException("error.PhdRegistryDiplomaRequestEvent.request.is.not.diploma", new String[0]);
        }
        if (!EventType.BOLONHA_PHD_DIPLOMA_REQUEST.equals((Object)eventType)) {
            throw new DomainException("error.PhdRegistryDiplomaRequestEvent.eventType.is.not.phd.diploma", new String[0]);
        }
        super.init(administrativeOffice, eventType, person, academicServiceRequest);
    }

    public static final PhdDiplomaRequestEvent create(AdministrativeOffice administrativeOffice, Person person, PhdDiplomaRequest phdDiplomaRequest) {
        return new PhdDiplomaRequestEvent(administrativeOffice, phdDiplomaRequest.getEventType(), person, (AcademicServiceRequest)((Object)phdDiplomaRequest));
    }

    public LabelFormatter getDescription() {
        LabelFormatter result = super.getDescription();
        this.fillDescription(result);
        return result;
    }

    public final LabelFormatter getDescriptionForEntryType(EntryType entryType) {
        LabelFormatter labelFormatter = new LabelFormatter();
        labelFormatter.appendLabel(entryType.name(), "resources.EnumerationResources");
        this.fillDescription(labelFormatter);
        return labelFormatter;
    }

    private void fillDescription(LabelFormatter labelFormatter) {
        labelFormatter.appendLabel(" (");
        PhdDiplomaRequest request = (PhdDiplomaRequest)((Object)this.getAcademicServiceRequest());
        labelFormatter.appendLabel(request.getPhdIndividualProgramProcess().getPhdProgram().getName().getPreferedContent());
        labelFormatter.appendLabel(")");
    }
}

