/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.DegreeInfo;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear_Base;
import org.fenixedu.academic.domain.accounting.AccountingTransaction;
import org.fenixedu.academic.domain.accounting.events.AnnualEvent;
import org.fenixedu.academic.domain.accounting.events.gratuity.DfaGratuityEvent;
import org.fenixedu.academic.domain.candidacy.StudentCandidacy;
import org.fenixedu.academic.domain.candidacy.degree.ShiftDistribution;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicYearCE;
import org.fenixedu.academic.util.PeriodState;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.Partial;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;
import pt.ist.fenixframework.dml.runtime.RelationAdapter;
import pt.ist.fenixframework.dml.runtime.RelationListener;

public class ExecutionYear
extends ExecutionYear_Base
implements Comparable<ExecutionYear> {
    public static final Comparator<ExecutionYear> COMPARATOR_BY_YEAR;
    public static final Comparator<ExecutionYear> REVERSE_COMPARATOR_BY_YEAR;
    private static final ExecutionYearSearchCache executionYearSearchCache;

    private ExecutionYear() {
        this.setRootDomainObjectForExecutionYear(Bennu.getInstance());
    }

    public ExecutionYear(AcademicInterval academicInterval, String year) {
        this();
        this.setAcademicInterval(academicInterval);
        this.setBeginDateYearMonthDay(academicInterval.getBeginYearMonthDayWithoutChronology());
        this.setEndDateYearMonthDay(academicInterval.getEndYearMonthDayWithoutChronology());
        this.setYear(year);
    }

    public String getYear() {
        return this.getName();
    }

    public void setYear(String year) {
        if (year == null || StringUtils.isEmpty((String)year.trim())) {
            throw new DomainException("error.ExecutionYear.empty.year", new String[0]);
        }
        super.setName(year);
    }

    public String getQualifiedName() {
        return this.getName();
    }

    public Collection<ExecutionDegree> getExecutionDegreesMatching(Predicate<DegreeType> predicate) {
        return this.getExecutionDegreesSet().stream().filter(degree -> predicate.test(degree.getDegreeCurricularPlan().getDegreeType())).collect(Collectors.toList());
    }

    public Collection<ExecutionDegree> getExecutionDegreesByType(DegreeType type) {
        return this.getExecutionDegreesSet().stream().filter(degree -> degree.getDegreeCurricularPlan().getDegreeType() == type).collect(Collectors.toList());
    }

    public ExecutionYear getNextExecutionYear() {
        AcademicYearCE year = this.getAcademicInterval().plusYear(1);
        return ExecutionYear.getExecutionYear(year);
    }

    public ExecutionYear getPreviousExecutionYear() {
        AcademicYearCE year = this.getAcademicInterval().minusYear(1);
        return ExecutionYear.getExecutionYear(year);
    }

    public ExecutionYear getPreviousExecutionYear(Integer previousCivilYears) {
        if (previousCivilYears >= 0) {
            AcademicYearCE year = this.getAcademicInterval().minusYear(previousCivilYears);
            return ExecutionYear.getExecutionYear(year);
        }
        return null;
    }

    public boolean hasPreviousExecutionYear() {
        return this.getPreviousExecutionYear() != null;
    }

    public boolean hasNextExecutionYear() {
        return this.getNextExecutionYear() != null;
    }

    @Override
    public int compareTo(ExecutionYear object) {
        if (object == null) {
            return 1;
        }
        return this.getAcademicInterval().getStartDateTimeWithoutChronology().compareTo((ReadableInstant)object.getAcademicInterval().getStartDateTimeWithoutChronology());
    }

    public boolean isAfter(ExecutionYear executionYear) {
        return this.compareTo(executionYear) > 0;
    }

    public boolean isAfterOrEquals(ExecutionYear executionYear) {
        return this.compareTo(executionYear) >= 0;
    }

    public boolean isBefore(ExecutionYear executionYear) {
        return this.compareTo(executionYear) < 0;
    }

    public boolean isBeforeOrEquals(ExecutionYear executionYear) {
        return this.compareTo(executionYear) <= 0;
    }

    public boolean isInclusivelyBetween(ExecutionYear y1, ExecutionYear y2) {
        return this.isAfterOrEquals(y1) && this.isBeforeOrEquals(y2);
    }

    public boolean isExclusivelyBetween(ExecutionYear y1, ExecutionYear y2) {
        return this.isAfter(y1) && this.isBefore(y2);
    }

    public Collection<ExecutionDegree> getExecutionDegreesSortedByDegreeName() {
        ArrayList<ExecutionDegree> executionDegrees = new ArrayList<ExecutionDegree>(this.getExecutionDegreesSet());
        Collections.sort(executionDegrees, ExecutionDegree.EXECUTION_DEGREE_COMPARATORY_BY_DEGREE_TYPE_AND_NAME);
        return executionDegrees;
    }

    public ExecutionSemester getExecutionSemesterFor(Integer semester) {
        for (ExecutionSemester executionSemester : this.getExecutionPeriodsSet()) {
            if (!executionSemester.isFor(semester)) continue;
            return executionSemester;
        }
        return null;
    }

    public ExecutionSemester getFirstExecutionPeriod() {
        return Collections.min(this.getExecutionPeriodsSet(), ExecutionSemester.COMPARATOR_BY_SEMESTER_AND_YEAR);
    }

    public ExecutionSemester getLastExecutionPeriod() {
        return Collections.max(this.getExecutionPeriodsSet(), ExecutionSemester.COMPARATOR_BY_SEMESTER_AND_YEAR);
    }

    public List<ExecutionSemester> readNotClosedPublicExecutionPeriods() {
        ArrayList<ExecutionSemester> result = new ArrayList<ExecutionSemester>();
        for (ExecutionSemester executionSemester : this.getExecutionPeriodsSet()) {
            if (executionSemester.isClosed() || executionSemester.isNotOpen()) continue;
            result.add(executionSemester);
        }
        return result;
    }

    public ExecutionSemester readExecutionPeriodByName(String name) {
        for (ExecutionSemester executionSemester : this.getExecutionPeriodsSet()) {
            if (!executionSemester.getName().equals(name)) continue;
            return executionSemester;
        }
        return null;
    }

    public String getNextYearsYearString() {
        int yearPart1 = Integer.parseInt(this.getYear().substring(0, 4)) + 1;
        int yearPart2 = Integer.parseInt(this.getYear().substring(5, 9)) + 1;
        return Integer.toString(yearPart1) + this.getYear().charAt(4) + Integer.toString(yearPart2);
    }

    public DegreeInfo getDegreeInfo(Degree degree) {
        for (DegreeInfo degreeInfo : this.getDegreeInfosSet()) {
            if (degreeInfo.getDegree() != degree) continue;
            return degreeInfo;
        }
        return null;
    }

    public boolean containsDate(DateTime dateTime) {
        DateMidnight begin = this.getBeginDateYearMonthDay().toDateMidnight();
        DateMidnight end = this.getEndDateYearMonthDay().plusDays(1).toDateMidnight();
        return new Interval((ReadableInstant)begin, (ReadableInstant)end).contains((ReadableInstant)dateTime);
    }

    public boolean overlapsInterval(Interval interval) {
        DateMidnight begin = this.getBeginDateYearMonthDay().toDateMidnight();
        DateMidnight end = this.getEndDateYearMonthDay().plusDays(1).toDateMidnight();
        return new Interval((ReadableInstant)begin, (ReadableInstant)end).overlaps((ReadableInterval)interval);
    }

    public boolean containsDate(LocalDate date) {
        return !this.getBeginDateYearMonthDay().isAfter((ReadablePartial)date) && !this.getEndDateYearMonthDay().isBefore((ReadablePartial)date);
    }

    public List<ExecutionDegree> getExecutionDegreesFor(Predicate<DegreeType> predicate) {
        ArrayList<ExecutionDegree> result = new ArrayList<ExecutionDegree>();
        for (ExecutionDegree executionDegree : this.getExecutionDegreesSet()) {
            if (!predicate.test(executionDegree.getDegreeCurricularPlan().getDegree().getDegreeType())) continue;
            result.add(executionDegree);
        }
        return result;
    }

    public boolean isCurrent() {
        return this.getState().equals(PeriodState.CURRENT);
    }

    public boolean isOpen() {
        return this.getState().equals(PeriodState.OPEN);
    }

    public boolean isClosed() {
        return this.getState().equals(PeriodState.CLOSED);
    }

    private boolean isNotOpen() {
        return this.getState().equals(PeriodState.NOT_OPEN);
    }

    public boolean isFor(String year) {
        return this.getYear().equals(year);
    }

    public ShiftDistribution createShiftDistribution() {
        return new ShiftDistribution(this);
    }

    public void delete() {
        if (!this.getExecutionDegreesSet().isEmpty()) {
            throw new Error("cannot.delete.execution.year.because.execution.degrees.exist");
        }
        if (!this.getStudentGroupSet().isEmpty()) {
            throw new DomainException("error.executionYear.cannotDeleteExecutionYearUsedInAccessControl", new String[0]);
        }
        if (!this.getTeacherGroupSet().isEmpty()) {
            throw new DomainException("error.executionYear.cannotDeleteExecutionYearUsedInAccessControl", new String[0]);
        }
        if (!this.getStudentsConcludedInExecutionYearGroupSet().isEmpty()) {
            throw new DomainException("error.executionYear.cannotDeleteExecutionYearUsedInAccessControl", new String[0]);
        }
        while (!this.getExecutionPeriodsSet().isEmpty()) {
            ((ExecutionSemester)this.getExecutionPeriodsSet().iterator().next()).delete();
        }
        this.setRootDomainObject(null);
        this.setRootDomainObjectForExecutionYear(null);
        this.deleteDomainObject();
    }

    public boolean belongsToCivilYear(int civilYear) {
        return this.getBeginCivilYear() == civilYear || this.getEndCivilYear() == civilYear;
    }

    public int getBeginCivilYear() {
        return this.getBeginDateYearMonthDay().getYear();
    }

    public int getEndCivilYear() {
        return this.getEndDateYearMonthDay().getYear();
    }

    public boolean belongsToCivilYearInterval(int beginCivilYear, int endCivilYear) {
        for (int year = beginCivilYear; year <= endCivilYear; ++year) {
            if (!this.belongsToCivilYear(year)) continue;
            return true;
        }
        return false;
    }

    public boolean isBeforeCivilYear(int civilYear) {
        return this.getEndCivilYear() < civilYear;
    }

    public boolean isAfterCivilYear(int civilYear) {
        return this.getBeginCivilYear() > civilYear;
    }

    public int getDistanceInCivilYears(ExecutionYear executionYear) {
        if (executionYear == null || executionYear == this) {
            return 0;
        }
        return Math.abs(this.getBeginCivilYear() - executionYear.getBeginCivilYear());
    }

    public Collection<DegreeCurricularPlan> getDegreeCurricularPlans() {
        HashSet<DegreeCurricularPlan> result = new HashSet<DegreeCurricularPlan>();
        for (ExecutionDegree executionDegree : this.getExecutionDegreesSet()) {
            result.add(executionDegree.getDegreeCurricularPlan());
        }
        return result;
    }

    private Set<AccountingTransaction> getPaymentsFor(Class<? extends AnnualEvent> eventClass) {
        HashSet<AccountingTransaction> result = new HashSet<AccountingTransaction>();
        for (AnnualEvent each : this.getAnnualEventsSet()) {
            if (!eventClass.equals(((Object)((Object)each)).getClass()) || each.isCancelled()) continue;
            result.addAll(each.getNonAdjustingTransactions());
        }
        return result;
    }

    public Set<AccountingTransaction> getDFAGratuityPayments() {
        return this.getPaymentsFor(DfaGratuityEvent.class);
    }

    public List<StudentCandidacy> getStudentCandidacies() {
        ArrayList<StudentCandidacy> result = new ArrayList<StudentCandidacy>();
        for (ExecutionDegree executionDegree : this.getExecutionDegreesSet()) {
            result.addAll(executionDegree.getStudentCandidaciesSet());
        }
        return result;
    }

    public ExecutionSemester getExecutionSemester(YearMonthDay date) {
        for (ExecutionSemester semester : this.getExecutionPeriodsSet()) {
            if (!semester.containsDay(date)) continue;
            return semester;
        }
        return null;
    }

    public static ExecutionYear getExecutionYear(AcademicYearCE entry) {
        if (entry != null) {
            entry = (AcademicYearCE)((Object)entry.getOriginalTemplateEntry());
            for (ExecutionYear executionYear : Bennu.getInstance().getExecutionYearsSet()) {
                if (!executionYear.getAcademicInterval().getAcademicCalendarEntry().equals((Object)entry)) continue;
                return executionYear;
            }
        }
        return null;
    }

    public static ExecutionYear readCurrentExecutionYear() {
        ExecutionSemester semester = ExecutionSemester.readActualExecutionSemester();
        if (semester != null) {
            return semester.getExecutionYear();
        }
        return null;
    }

    public static List<ExecutionYear> readOpenExecutionYears() {
        ArrayList<ExecutionYear> result = new ArrayList<ExecutionYear>();
        for (ExecutionYear executionYear : Bennu.getInstance().getExecutionYearsSet()) {
            if (!executionYear.isOpen()) continue;
            result.add(executionYear);
        }
        return result;
    }

    public static List<ExecutionYear> readNotClosedExecutionYears() {
        ArrayList<ExecutionYear> result = new ArrayList<ExecutionYear>();
        for (ExecutionYear executionYear : Bennu.getInstance().getExecutionYearsSet()) {
            if (executionYear.isClosed()) continue;
            result.add(executionYear);
        }
        return result;
    }

    public static List<ExecutionYear> readNotOpenExecutionYears() {
        ArrayList<ExecutionYear> result = new ArrayList<ExecutionYear>();
        for (ExecutionYear executionYear : Bennu.getInstance().getExecutionYearsSet()) {
            if (!executionYear.isNotOpen()) continue;
            result.add(executionYear);
        }
        return result;
    }

    public static List<ExecutionYear> readExecutionYears(ExecutionYear startYear, ExecutionYear endYear) {
        ArrayList<ExecutionYear> result = new ArrayList<ExecutionYear>();
        result.add(startYear);
        for (ExecutionYear year = startYear.getNextExecutionYear(); year != null && year.isBeforeOrEquals(endYear); year = year.getNextExecutionYear()) {
            result.add(year);
        }
        return result;
    }

    public static ExecutionYear readExecutionYearByName(String year) {
        for (ExecutionYear executionYear : Bennu.getInstance().getExecutionYearsSet()) {
            if (!executionYear.isFor(year)) continue;
            return executionYear;
        }
        return null;
    }

    public static ExecutionYear readFirstBolonhaExecutionYear() {
        return ExecutionSemester.readFirstBolonhaExecutionPeriod().getExecutionYear();
    }

    public static ExecutionYear readByDateTime(DateTime dateTime) {
        return executionYearSearchCache.findByDateTime(dateTime);
    }

    public static ExecutionYear readByDateTime(LocalDate localDate) {
        return executionYearSearchCache.findByDateTime(localDate.toDateTimeAtCurrentTime());
    }

    public static ExecutionYear readByPartial(Partial partial) {
        return executionYearSearchCache.findByPartial(partial);
    }

    public static ExecutionYear readBy(YearMonthDay begin, YearMonthDay end) {
        for (ExecutionYear executionYear : Bennu.getInstance().getExecutionYearsSet()) {
            if (!executionYear.getBeginDateYearMonthDay().isEqual((ReadablePartial)begin) || !executionYear.getEndDateYearMonthDay().isEqual((ReadablePartial)end)) continue;
            return executionYear;
        }
        return null;
    }

    public static ExecutionYear getExecutionYearByDate(YearMonthDay date) {
        return ExecutionYear.readByDateTime(date.toDateTimeAtMidnight());
    }

    public static List<ExecutionYear> readExecutionYearsByCivilYear(int civilYear) {
        ArrayList<ExecutionYear> result = new ArrayList<ExecutionYear>();
        for (ExecutionYear executionYear : (Set)executionYearSearchCache.map.get(civilYear)) {
            if (!executionYear.belongsToCivilYear(civilYear)) continue;
            result.add(executionYear);
        }
        return result;
    }

    public static ExecutionYear readFirstExecutionYear() {
        for (ExecutionYear executionYear : Bennu.getInstance().getExecutionYearsSet()) {
            if (executionYear.hasPreviousExecutionYear()) continue;
            return executionYear;
        }
        return null;
    }

    public static ExecutionYear readLastExecutionYear() {
        for (ExecutionYear executionYear : Bennu.getInstance().getExecutionYearsSet()) {
            if (executionYear.hasNextExecutionYear()) continue;
            return executionYear;
        }
        return null;
    }

    public static ExecutionYear readByAcademicInterval(AcademicInterval academicInterval) {
        for (ExecutionYear executionYear : Bennu.getInstance().getExecutionYearsSet()) {
            if (!executionYear.getAcademicInterval().equals(academicInterval)) continue;
            return executionYear;
        }
        return null;
    }

    public ExecutionDegree getExecutionDegreeByAcronym(String acronym) {
        for (ExecutionDegree executionDegree : this.getExecutionDegreesSet()) {
            if (!executionDegree.getDegree().getSigla().equals(acronym)) continue;
            return executionDegree;
        }
        return null;
    }

    public <E extends ExecutionInterval> E convert(Class<E> input) {
        Comparable<ExecutionYear> result = null;
        if (ExecutionYear.class.equals(input)) {
            result = this;
        } else if (ExecutionSemester.class.equals(input)) {
            result = this.getFirstExecutionPeriod();
        }
        return (E)result;
    }

    static {
        ExecutionYear.getRelationExecutionPeriodExecutionYear().addListener((RelationListener)new ExecutionPeriodExecutionYearListener());
        COMPARATOR_BY_YEAR = new Comparator<ExecutionYear>(){

            @Override
            public int compare(ExecutionYear o1, ExecutionYear o2) {
                return o1.getYear().compareTo(o2.getYear());
            }
        };
        REVERSE_COMPARATOR_BY_YEAR = new Comparator<ExecutionYear>(){

            @Override
            public int compare(ExecutionYear o1, ExecutionYear o2) {
                return -COMPARATOR_BY_YEAR.compare(o1, o2);
            }
        };
        executionYearSearchCache = new ExecutionYearSearchCache();
    }

    public static class ExecutionYearSearchCache {
        private final Map<Integer, Set<ExecutionYear>> map = new HashMap<Integer, Set<ExecutionYear>>();

        private Set<ExecutionYear> updateIfNeeded(Integer year) {
            Set<ExecutionYear> result = this.map.get(year);
            if (result == null || result.size() < 2) {
                for (ExecutionYear executionYear : Bennu.getInstance().getExecutionYearsSet()) {
                    this.add(executionYear);
                }
                result = this.map.get(year);
            }
            return result;
        }

        public ExecutionYear findByDateTime(DateTime dateTime) {
            Integer year = dateTime.getYear();
            Set<ExecutionYear> executionYears = this.updateIfNeeded(year);
            if (executionYears != null) {
                for (ExecutionYear executionYear : executionYears) {
                    if (!executionYear.containsDate(dateTime)) continue;
                    return executionYear;
                }
            }
            return null;
        }

        public ExecutionYear findByPartial(Partial partial) {
            Integer year = partial.get(DateTimeFieldType.year());
            Set<ExecutionYear> executionYears = this.updateIfNeeded(year);
            if (executionYears != null) {
                for (ExecutionYear executionYear : executionYears) {
                    if (executionYear.getBeginDateYearMonthDay().getYear() != year.intValue()) continue;
                    return executionYear;
                }
            }
            return null;
        }

        private void add(ExecutionYear executionYear) {
            Integer year1 = executionYear.getBeginDateYearMonthDay().getYear();
            Integer year2 = executionYear.getEndDateYearMonthDay().getYear();
            this.add(executionYear, year1);
            this.add(executionYear, year2);
        }

        private void add(ExecutionYear executionYear, Integer year) {
            Set<ExecutionYear> executionYears = this.map.get(year);
            if (executionYears == null) {
                executionYears = new HashSet<ExecutionYear>();
                this.map.put(year, executionYears);
            }
            executionYears.add(executionYear);
        }
    }

    private static class ExecutionPeriodExecutionYearListener
    extends RelationAdapter<ExecutionYear, ExecutionSemester> {
        private ExecutionPeriodExecutionYearListener() {
        }

        public void beforeAdd(ExecutionYear executionYear, ExecutionSemester executionSemester) {
            if (executionYear != null && executionSemester != null && executionYear.getExecutionPeriodsSet().size() == 2) {
                throw new DomainException("error.ExecutionYear.exceeded.number.of.executionPeriods", executionYear.getYear());
            }
        }
    }
}

