/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.Comparator;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.commons.collections.comparators.NullComparator;
import org.fenixedu.academic.domain.BibliographicReference_Base;
import org.fenixedu.academic.domain.CurricularManagementLog;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class BibliographicReference
extends BibliographicReference_Base {
    public static final Comparator<BibliographicReference> COMPARATOR_BY_ORDER = new Comparator<BibliographicReference>(){
        private ComparatorChain chain = null;

        @Override
        public int compare(BibliographicReference one, BibliographicReference other) {
            if (this.chain == null) {
                this.chain = new ComparatorChain();
                this.chain.addComparator((Comparator)new BeanComparator("referenceOrder", (Comparator)new NullComparator(true)));
                this.chain.addComparator((Comparator)new BeanComparator("title"));
                this.chain.addComparator((Comparator)new BeanComparator("year"));
                this.chain.addComparator(DomainObjectUtil.COMPARATOR_BY_ID);
            }
            return this.chain.compare((Object)one, (Object)other);
        }
    };

    public BibliographicReference() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public void edit(String title, String authors, String reference, String year, Boolean optional) {
        if (title == null || authors == null || reference == null || year == null || optional == null) {
            throw new NullPointerException();
        }
        this.setTitle(title);
        this.setAuthors(authors);
        this.setReference(reference);
        this.setYear(year);
        this.setOptional(optional);
        ExecutionCourse executionCourse = this.getExecutionCourse();
        String type = optional != false ? BundleUtil.getString((String)"resources.ApplicationResources", (String)"option.bibliographicReference.optional", (String[])new String[0]) : BundleUtil.getString((String)"resources.ApplicationResources", (String)"option.bibliographicReference.recommended", (String[])new String[0]);
        CurricularManagementLog.createLog(executionCourse, "resources.MessagingResources", "log.executionCourse.curricular.bibliographic.edited", type, title, executionCourse.getName(), executionCourse.getDegreePresentationString());
    }

    public void delete() {
        ExecutionCourse executionCourse = this.getExecutionCourse();
        String blBibliographicReference = this.getTitle();
        Boolean optional = this.getOptional();
        String type = optional != false ? BundleUtil.getString((String)"resources.ApplicationResources", (String)"option.bibliographicReference.optional", (String[])new String[0]) : BundleUtil.getString((String)"resources.ApplicationResources", (String)"option.bibliographicReference.recommended", (String[])new String[0]);
        CurricularManagementLog.createLog(executionCourse, "resources.MessagingResources", "log.executionCourse.curricular.bibliographic.removed", type, blBibliographicReference, executionCourse.getName(), executionCourse.getDegreePresentationString());
        this.setExecutionCourse(null);
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    public boolean isOptional() {
        return this.getOptional() == null || this.getOptional() != false;
    }
}

