/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.Comparator;
import java.util.Date;
import org.fenixedu.academic.domain.AdHocEvaluation_Base;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.GradeScale;
import org.fenixedu.academic.util.EvaluationType;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class AdHocEvaluation
extends AdHocEvaluation_Base {
    public static final Comparator<AdHocEvaluation> AD_HOC_EVALUATION_CREATION_DATE_COMPARATOR = new Comparator<AdHocEvaluation>(){

        @Override
        public int compare(AdHocEvaluation e1, AdHocEvaluation e2) {
            return e1.getCreationDateTime().compareTo((ReadableInstant)e2.getCreationDateTime());
        }
    };

    public AdHocEvaluation() {
        this.setCreationDateTime(new DateTime());
    }

    public AdHocEvaluation(ExecutionCourse executionCourse, String name, String description, GradeScale gradeScale) {
        this();
        if (name == null || executionCourse == null || gradeScale == null) {
            throw new NullPointerException();
        }
        this.addAssociatedExecutionCourses(executionCourse);
        this.setName(name);
        this.setDescription(description);
        this.setGradeScale(gradeScale);
        this.logCreate();
    }

    public void delete() {
        this.logRemove();
        super.delete();
    }

    public EvaluationType getEvaluationType() {
        return EvaluationType.AD_HOC_TYPE;
    }

    public String getPresentationName() {
        return BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.adHocEvaluation", (String[])new String[0]) + " " + this.getName();
    }

    public void edit(String name, String description, GradeScale gradeScale) {
        if (name == null || gradeScale == null) {
            throw new NullPointerException();
        }
        this.setName(name);
        this.setDescription(description);
        if (this.getGradeScale() != gradeScale) {
            this.setGradeScale(gradeScale);
        }
        this.logEdit();
    }

    @Deprecated
    public Date getCreation() {
        DateTime dt = this.getCreationDateTime();
        return dt == null ? null : new Date(dt.getMillis());
    }

    @Deprecated
    public void setCreation(Date date) {
        if (date == null) {
            this.setCreationDateTime(null);
        } else {
            this.setCreationDateTime(new DateTime(date.getTime()));
        }
    }

    public Date getEvaluationDate() {
        return this.getCreationDateTime().toDate();
    }
}

