/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.utils;

import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.struts.util.LabelValueBean;
import org.fenixedu.academic.dto.InfoDegree;
import org.fenixedu.academic.dto.InfoExecutionDegree;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class RequestUtils {
    public static String getAndSetStringToRequest(HttpServletRequest request, String name) {
        String parameter = request.getParameter(name);
        if (parameter == null) {
            parameter = (String)request.getAttribute(name);
        }
        request.setAttribute(name, (Object)parameter);
        return parameter;
    }

    public static Collection buildExecutionDegreeLabelValueBean(Collection executionDegrees) {
        HashMap<String, Boolean> duplicateDegreesMap = new HashMap<String, Boolean>();
        for (InfoExecutionDegree infoExecutionDegree : executionDegrees) {
            InfoDegree infoDegree = infoExecutionDegree.getInfoDegreeCurricularPlan().getInfoDegree();
            String degreeName = infoDegree.getNome();
            if (duplicateDegreesMap.get(degreeName) == null) {
                duplicateDegreesMap.put(degreeName, new Boolean(false));
                continue;
            }
            duplicateDegreesMap.put(degreeName, new Boolean(true));
        }
        Collection lableValueList = CollectionUtils.collect((Collection)executionDegrees, (Transformer)new Transformer(){

            public Object transform(Object arg0) {
                InfoExecutionDegree infoExecutionDegree = (InfoExecutionDegree)arg0;
                String label = infoExecutionDegree.getInfoDegreeCurricularPlan().getDegreeCurricularPlan().getPresentationName(infoExecutionDegree.getInfoExecutionYear().getExecutionYear());
                String value = infoExecutionDegree.getExternalId().toString();
                return new LabelValueBean(label, value);
            }
        });
        BeanComparator comparator = new BeanComparator("label", (Comparator)Collator.getInstance());
        Collections.sort((List)lableValueList, comparator);
        return lableValueList;
    }

    public static final List<LabelValueBean> buildCurricularYearLabelValueBean() {
        ArrayList<LabelValueBean> curricularYears = new ArrayList<LabelValueBean>();
        curricularYears.add(new LabelValueBean(BundleUtil.getString((String)"resources.RendererResources", (String)"renderers.menu.default.title", (String[])new String[0]), ""));
        curricularYears.add(new LabelValueBean(BundleUtil.getString((String)"resources.EnumerationResources", (String)"1.ordinal.short", (String[])new String[0]), "1"));
        curricularYears.add(new LabelValueBean(BundleUtil.getString((String)"resources.EnumerationResources", (String)"2.ordinal.short", (String[])new String[0]), "2"));
        curricularYears.add(new LabelValueBean(BundleUtil.getString((String)"resources.EnumerationResources", (String)"3.ordinal.short", (String[])new String[0]), "3"));
        curricularYears.add(new LabelValueBean(BundleUtil.getString((String)"resources.EnumerationResources", (String)"4.ordinal.short", (String[])new String[0]), "4"));
        curricularYears.add(new LabelValueBean(BundleUtil.getString((String)"resources.EnumerationResources", (String)"5.ordinal.short", (String[])new String[0]), "5"));
        return curricularYears;
    }

    public static void sendLoginRedirect(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(request.getContextPath() + "/login");
    }
}

