/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.serviceRequests;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.DomainExceptionWithLabelFormatter;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequestSituation;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequestSituationType;
import org.fenixedu.academic.domain.serviceRequests.RegistrationAcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.SpecialSeasonRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.AcademicServiceRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DiplomaRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequest;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.dto.serviceRequests.AcademicServiceRequestBean;
import org.fenixedu.academic.predicate.AcademicPredicates;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.service.factoryExecutors.RegistrationAcademicServiceRequestCreator;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.serviceRequests.SendAcademicServiceRequestToExternalEntity;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AcademicAdministrationApplication;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.serviceRequests.AcademicServiceRequestsManagementDispatchAction$callable$generateRegistryCode;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.serviceRequests.AcademicServiceRequestsManagementDispatchAction$callable$revertRequestToProcessingState;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.util.CollectionPager;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.joda.time.YearMonthDay;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@StrutsFunctionality(app=AcademicAdministrationApplication.AcademicAdminServicesApp.class, path="service-requests", titleKey="label.academic.service.requests", accessGroup="academic(SERVICE_REQUESTS)")
@Mapping(path="/academicServiceRequestsManagement", module="academicAdministration", formBeanClass=AcademicServiceRequestsManagementForm.class)
@Forwards(value={@Forward(name="viewRegistrationAcademicServiceRequestsHistoric", path="/academicAdminOffice/serviceRequests/viewRegistrationAcademicServiceRequestsHistoric.jsp"), @Forward(name="viewAcademicServiceRequest", path="/academicAdminOffice/serviceRequests/viewAcademicServiceRequest.jsp"), @Forward(name="viewRegistrationDetails", path="/academicAdminOffice/student/registration/viewRegistrationDetails.jsp"), @Forward(name="confirmCreateServiceRequest", path="/academicAdminOffice/serviceRequests/confirmCreateServiceRequest.jsp"), @Forward(name="prepareRejectAcademicServiceRequest", path="/academicAdminOffice/serviceRequests/prepareRejectAcademicServiceRequest.jsp"), @Forward(name="prepareSendAcademicServiceRequest", path="/academicAdminOffice/serviceRequests/prepareSendAcademicServiceRequest.jsp"), @Forward(name="prepareReceiveAcademicServiceRequest", path="/academicAdminOffice/serviceRequests/prepareReceiveAcademicServiceRequest.jsp"), @Forward(name="prepareCancelAcademicServiceRequest", path="/academicAdminOffice/serviceRequests/prepareCancelAcademicServiceRequest.jsp"), @Forward(name="prepareConcludeDocumentRequest", path="/academicAdministration/documentRequestsManagement.do?method=prepareConcludeDocumentRequest"), @Forward(name="prepareConcludeServiceRequest", path="/academicAdminOffice/serviceRequests/concludeServiceRequest.jsp"), @Forward(name="prepareCreateServiceRequest", path="/academicAdminOffice/serviceRequests/prepareCreateServiceRequest.jsp"), @Forward(name="searchResults", path="/academicAdminOffice/serviceRequests/searchResults.jsp"), @Forward(name="showCurrentBag", path="/academicAdminOffice/serviceRequests/showCurrentBag.jsp"), @Forward(name="entryPoint", path="/academicAdminOffice/serviceRequests/entryPoint.jsp")})
public class AcademicServiceRequestsManagementDispatchAction
extends FenixDispatchAction {
    private static final int REQUESTS_PER_PAGE = 50;
    private static final String REQUEST_NUMBER_YEAR = "serviceRequestNumberYear";
    private static final String REGISTRATION_NUMBER = "registration.number";
    private static final String DESCRIPTION = "description";
    private static final String EXECUTION_YEAR = "executionYear";
    private static final String URGENT_REQUEST = "urgentRequest";
    private static final String REQUEST_DATE = "requestDate";
    private static final String ACTIVE_SITUATION_DATE = "activeSituationDate";
    private static final String DEFAULT_ORDER_GETTER = "activeSituationDate";
    private static final String ORDER_PARAMETER = "sortBy";
    private static final String ORDER_MARKER = "=";
    public static final String[] ASC_ORDER_DIR;
    public static final String DEFAULT_ORDER_DIR = "desc";
    public static final Advice advice$revertRequestToProcessingState;
    public static final Advice advice$generateRegistryCode;

    @EntryPoint
    public ActionForward entryPoint(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("entryPoint");
    }

    private RegistrationAcademicServiceRequest getAndSetAcademicServiceRequest(HttpServletRequest request) {
        AcademicServiceRequest academicServiceRequest = (AcademicServiceRequest)this.getDomainObject(request, "academicServiceRequestId");
        request.setAttribute("academicServiceRequest", (Object)academicServiceRequest);
        return (RegistrationAcademicServiceRequest)((Object)academicServiceRequest);
    }

    private Registration getAndSetRegistration(HttpServletRequest request) {
        Registration registration = (Registration)((Object)this.getDomainObject(request, "registrationID"));
        request.setAttribute("registration", (Object)registration);
        return registration;
    }

    private String getAndSetUrl(ActionForm actionForm, HttpServletRequest request) {
        StringBuilder result = new StringBuilder();
        if (!StringUtils.isEmpty((String)request.getParameter("backAction"))) {
            result.append("/").append(request.getParameter("backAction")).append(".do?");
            if (!StringUtils.isEmpty((String)request.getParameter("backMethod"))) {
                result.append("method=").append(request.getParameter("backMethod"));
            }
        }
        request.setAttribute("url", (Object)result.toString());
        return result.toString();
    }

    public ActionForward viewRegistrationAcademicServiceRequestsHistoric(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("registration", (Object)this.getAndSetRegistration(request));
        return mapping.findForward("viewRegistrationAcademicServiceRequestsHistoric");
    }

    public ActionForward viewAcademicServiceRequest(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        RegistrationAcademicServiceRequest serviceRequest = this.getAndSetAcademicServiceRequest(request);
        this.getAndSetUrl(form, request);
        request.setAttribute("canRevertToProcessingState", (Object)this.canRevertToProcessingState((AcademicServiceRequest)((Object)serviceRequest)));
        request.setAttribute("serviceRequestSituations", this.getAcademicServiceRequestSituations((AcademicServiceRequest)((Object)serviceRequest)));
        return mapping.findForward("viewAcademicServiceRequest");
    }

    private boolean canRevertToProcessingState(AcademicServiceRequest academicServiceRequest) {
        return AcademicPredicates.SERVICE_REQUESTS_REVERT_TO_PROCESSING_STATE.evaluate(academicServiceRequest) && !academicServiceRequest.isPossibleToSendToOtherEntity();
    }

    private List<AcademicServiceRequestSituation> getAcademicServiceRequestSituations(AcademicServiceRequest serviceRequest) {
        ArrayList<AcademicServiceRequestSituation> result = new ArrayList<AcademicServiceRequestSituation>(serviceRequest.getAcademicServiceRequestSituationsSet());
        Collections.sort(result, AcademicServiceRequestSituation.COMPARATOR_BY_MOST_RECENT_SITUATION_DATE_AND_ID);
        return result;
    }

    public ActionForward revertRequestToProcessingState(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return (ActionForward)advice$revertRequestToProcessingState.perform((Callable)new AcademicServiceRequestsManagementDispatchAction$callable$revertRequestToProcessingState(this, actionMapping, actionForm, httpServletRequest, httpServletResponse));
    }

    static /* synthetic */ ActionForward advised$revertRequestToProcessingState(AcademicServiceRequestsManagementDispatchAction this_, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        RegistrationAcademicServiceRequest academicServiceRequest = this_.getAndSetAcademicServiceRequest(request);
        this_.getAndSetUrl(form, request);
        request.setAttribute("canRevertToProcessingState", (Object)this_.canRevertToProcessingState((AcademicServiceRequest)((Object)academicServiceRequest)));
        try {
            ((AcademicServiceRequest)((Object)academicServiceRequest)).revertToProcessingState();
        }
        catch (DomainException ex) {
            this_.addActionMessage(request, ex.getMessage(), ex.getArgs());
        }
        return mapping.findForward("viewAcademicServiceRequest");
    }

    public ActionForward processNewAcademicServiceRequest(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        RegistrationAcademicServiceRequest academicServiceRequest = this.getAndSetAcademicServiceRequest(request);
        try {
            academicServiceRequest.process();
            this.addActionMessage(request, "academic.service.request.processed.with.success");
        }
        catch (DomainException ex) {
            this.addActionMessage(request, ex.getKey(), ex.getArgs());
            request.setAttribute("failingCondition", (Object)ex.getKey());
            return mapping.findForward("prepareRejectAcademicServiceRequest");
        }
        if (academicServiceRequest.isDocumentRequest() && ((DocumentRequest)((Object)academicServiceRequest)).getDocumentRequestType().isAllowedToQuickDeliver()) {
            return this.prepareConcludeAcademicServiceRequest(mapping, actionForm, request, response);
        }
        if (request.getParameter("academicSituationType") != null) {
            return this.search(mapping, actionForm, request, response);
        }
        request.setAttribute("registration", (Object)academicServiceRequest.getRegistration());
        return mapping.findForward("viewRegistrationDetails");
    }

    public ActionForward prepareSendAcademicServiceRequest(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("serviceRequestBean", (Object)new AcademicServiceRequestBean((AcademicServiceRequest)((Object)this.getAndSetAcademicServiceRequest(request)), AcademicServiceRequestSituationType.SENT_TO_EXTERNAL_ENTITY));
        return mapping.findForward("prepareSendAcademicServiceRequest");
    }

    public ActionForward sendAcademicServiceRequest(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        RegistrationAcademicServiceRequest serviceRequest = this.getAndSetAcademicServiceRequest(request);
        AcademicServiceRequestBean requestBean = (AcademicServiceRequestBean)this.getObjectFromViewState("serviceRequestBean");
        try {
            SendAcademicServiceRequestToExternalEntity.run((AcademicServiceRequest)((Object)serviceRequest), requestBean.getSituationDate(), requestBean.getJustification());
        }
        catch (DomainExceptionWithLabelFormatter ex) {
            this.addActionMessage(request, ex.getKey(), this.solveLabelFormatterArgs(request, ex.getLabelFormatterArgs()));
            request.setAttribute("serviceRequestBean", (Object)requestBean);
            return mapping.findForward("prepareSendAcademicServiceRequest");
        }
        catch (DomainException ex) {
            this.addActionMessage(request, ex.getKey());
            request.setAttribute("serviceRequestBean", (Object)requestBean);
            return mapping.findForward("prepareSendAcademicServiceRequest");
        }
        request.setAttribute("registration", (Object)serviceRequest.getRegistration());
        return mapping.findForward("viewRegistrationDetails");
    }

    public ActionForward prepareReceiveAcademicServiceRequest(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("serviceRequestBean", (Object)new AcademicServiceRequestBean((AcademicServiceRequest)((Object)this.getAndSetAcademicServiceRequest(request)), AcademicServiceRequestSituationType.RECEIVED_FROM_EXTERNAL_ENTITY));
        return mapping.findForward("prepareReceiveAcademicServiceRequest");
    }

    public ActionForward receiveAcademicServiceRequest(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        RegistrationAcademicServiceRequest serviceRequest = this.getAndSetAcademicServiceRequest(request);
        AcademicServiceRequestBean requestBean = (AcademicServiceRequestBean)this.getObjectFromViewState("serviceRequestBean");
        try {
            serviceRequest.receivedFromExternalEntity(requestBean.getSituationDate(), requestBean.getJustification());
        }
        catch (DomainExceptionWithLabelFormatter ex) {
            this.addActionMessage(request, ex.getKey(), this.solveLabelFormatterArgs(request, ex.getLabelFormatterArgs()));
            request.setAttribute("serviceRequestBean", (Object)requestBean);
            return mapping.findForward("prepareReceiveAcademicServiceRequest");
        }
        catch (DomainException ex) {
            this.addActionMessage(request, ex.getKey());
            request.setAttribute("serviceRequestBean", (Object)requestBean);
            return mapping.findForward("prepareReceiveAcademicServiceRequest");
        }
        request.setAttribute("registration", (Object)serviceRequest.getRegistration());
        return mapping.findForward("viewRegistrationDetails");
    }

    public ActionForward prepareRejectAcademicServiceRequest(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        this.getAndSetAcademicServiceRequest(request);
        return mapping.findForward("prepareRejectAcademicServiceRequest");
    }

    public ActionForward rejectAcademicServiceRequest(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        RegistrationAcademicServiceRequest academicServiceRequest = this.getAndSetAcademicServiceRequest(request);
        String justification = ((AcademicServiceRequestsManagementForm)actionForm).getJustification();
        try {
            academicServiceRequest.reject(justification);
        }
        catch (DomainExceptionWithLabelFormatter ex) {
            this.addActionMessage(request, ex.getKey(), this.solveLabelFormatterArgs(request, ex.getLabelFormatterArgs()));
            return mapping.findForward("prepareRejectAcademicServiceRequest");
        }
        catch (DomainException ex) {
            this.addActionMessage(request, ex.getKey());
            return mapping.findForward("prepareRejectAcademicServiceRequest");
        }
        request.setAttribute("registration", (Object)academicServiceRequest.getRegistration());
        return mapping.findForward("viewRegistrationDetails");
    }

    public ActionForward prepareCancelAcademicServiceRequest(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        this.getAndSetAcademicServiceRequest(request);
        return mapping.findForward("prepareCancelAcademicServiceRequest");
    }

    public ActionForward cancelAcademicServiceRequest(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        RegistrationAcademicServiceRequest academicServiceRequest = this.getAndSetAcademicServiceRequest(request);
        String justification = ((AcademicServiceRequestsManagementForm)actionForm).getJustification();
        try {
            academicServiceRequest.cancel(justification);
        }
        catch (DomainExceptionWithLabelFormatter ex) {
            this.addActionMessage(request, ex.getKey(), this.solveLabelFormatterArgs(request, ex.getLabelFormatterArgs()));
            return mapping.findForward("prepareCancelAcademicServiceRequest");
        }
        catch (DomainException ex) {
            this.addActionMessage(request, ex.getKey());
            return mapping.findForward("prepareCancelAcademicServiceRequest");
        }
        request.setAttribute("registration", (Object)academicServiceRequest.getRegistration());
        return mapping.findForward("viewRegistrationDetails");
    }

    public ActionForward prepareConcludeAcademicServiceRequest(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        RegistrationAcademicServiceRequest academicServiceRequest = this.getAndSetAcademicServiceRequest(request);
        AcademicServiceRequestsManagementForm form = (AcademicServiceRequestsManagementForm)actionForm;
        form.setSendEmailToStudent(Boolean.TRUE);
        if (academicServiceRequest.isDocumentRequest()) {
            request.setAttribute("serviceRequestBean", (Object)new AcademicServiceRequestBean((AcademicServiceRequest)((Object)academicServiceRequest), AcademicServiceRequestSituationType.CONCLUDED));
            return mapping.findForward("prepareConcludeDocumentRequest");
        }
        return mapping.findForward("prepareConcludeServiceRequest");
    }

    public ActionForward concludeAcademicServiceRequest(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        Boolean sendEmail2 = true;
        Object academicServiceRequest = this.getAndSetAcademicServiceRequest(request);
        AcademicServiceRequestsManagementForm form = (AcademicServiceRequestsManagementForm)actionForm;
        if (academicServiceRequest.getAcademicServiceRequestType() == AcademicServiceRequestType.SPECIAL_SEASON_REQUEST) {
            if (form.getDeferRequest() == null) {
                return this.prepareConcludeAcademicServiceRequest(mapping, actionForm, request, response);
            }
            SpecialSeasonRequest specialSeasonRequest = (SpecialSeasonRequest)((Object)academicServiceRequest);
            specialSeasonRequest.setDeferment(form.getDeferRequest());
            academicServiceRequest = specialSeasonRequest;
        }
        if (academicServiceRequest.getRegistration().getRegistrationProtocol().isMobilityAgreement()) {
            sendEmail2 = false;
        }
        if (academicServiceRequest.getAcademicServiceRequestType() == AcademicServiceRequestType.DIPLOMA_SUPPLEMENT_REQUEST) {
            sendEmail2 = false;
        }
        try {
            academicServiceRequest.conclude(this.getSituationDate(), this.getJustification(), form.getSendEmailToStudent() != null ? form.getSendEmailToStudent() : sendEmail2);
            this.addActionMessage(request, "academic.service.request.concluded.with.success");
            if (academicServiceRequest.isDocumentRequest() && ((DocumentRequest)academicServiceRequest).getDocumentRequestType().isAllowedToQuickDeliver()) {
                return this.deliveredAcademicServiceRequest(mapping, actionForm, request, response);
            }
        }
        catch (DomainExceptionWithLabelFormatter ex) {
            this.addActionMessage(request, ex.getKey(), this.solveLabelFormatterArgs(request, ex.getLabelFormatterArgs()));
        }
        catch (DomainException ex) {
            this.addActionMessage(request, ex.getKey());
        }
        request.setAttribute("registration", (Object)academicServiceRequest.getRegistration());
        return mapping.findForward("viewRegistrationDetails");
    }

    private YearMonthDay getSituationDate() {
        AcademicServiceRequestBean requestBean = (AcademicServiceRequestBean)this.getObjectFromViewState("serviceRequestBean");
        return requestBean == null ? new YearMonthDay() : requestBean.getSituationDate();
    }

    private String getJustification() {
        AcademicServiceRequestBean requestBean = (AcademicServiceRequestBean)this.getObjectFromViewState("serviceRequestBean");
        return requestBean == null ? null : requestBean.getJustification();
    }

    public ActionForward deliveredAcademicServiceRequest(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        RegistrationAcademicServiceRequest academicServiceRequest = this.getAndSetAcademicServiceRequest(request);
        try {
            academicServiceRequest.delivered();
            this.addActionMessage(request, "academic.service.request.delivered.with.success");
        }
        catch (DomainException ex) {
            this.addActionMessage(request, ex.getKey());
        }
        request.setAttribute("registration", (Object)academicServiceRequest.getRegistration());
        return mapping.findForward("viewRegistrationDetails");
    }

    public ActionForward generateRegistryCode(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return (ActionForward)advice$generateRegistryCode.perform((Callable)new AcademicServiceRequestsManagementDispatchAction$callable$generateRegistryCode(this, actionMapping, actionForm, httpServletRequest, httpServletResponse));
    }

    static /* synthetic */ ActionForward advised$generateRegistryCode(AcademicServiceRequestsManagementDispatchAction this_, ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        RegistrationAcademicServiceRequest academicServiceRequest = this_.getAndSetAcademicServiceRequest(request);
        DiplomaRequest diploma = (DiplomaRequest)((Object)academicServiceRequest);
        diploma.generateRegistryCode();
        this_.addActionMessage(request, "rectorate.code.generated.with.success");
        request.setAttribute("registration", (Object)academicServiceRequest.getRegistration());
        return mapping.findForward("viewRegistrationDetails");
    }

    public ActionForward search(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        AcademicServiceRequestBean bean = this.getOrCreateAcademicServiceRequestBean(request);
        request.setAttribute("bean", (Object)bean);
        Collection<AcademicServiceRequest> remainingRequests = bean.searchAcademicServiceRequests();
        Collection<AcademicServiceRequest> specificRequests = this.getAndRemoveSpecificRequests(bean, remainingRequests);
        TreeSet<AcademicServiceRequest> sorted = new TreeSet<AcademicServiceRequest>(this.getComparator(request));
        sorted.addAll(remainingRequests);
        request.setAttribute("remainingRequests", remainingRequests);
        request.setAttribute("specificRequests", specificRequests);
        CollectionPager pager = new CollectionPager(sorted, 50);
        request.setAttribute("collectionPager", pager);
        request.setAttribute("numberOfPages", (Object)pager.getNumberOfPages());
        String pageParameter = request.getParameter("pageNumber");
        Integer page = StringUtils.isEmpty((String)pageParameter) ? Integer.valueOf(1) : Integer.valueOf(pageParameter);
        request.setAttribute("pageNumber", (Object)page);
        request.setAttribute("resultPage", pager.getPage(page));
        return mapping.findForward("searchResults");
    }

    private AcademicServiceRequestBean getOrCreateAcademicServiceRequestBean(HttpServletRequest request) {
        AcademicServiceRequestBean bean = (AcademicServiceRequestBean)this.getObjectFromViewState("bean");
        if (bean == null) {
            Integer year = this.getIntegerFromRequest(request, "serviceRequestYear");
            if (year == null) {
                year = new YearMonthDay().getYear();
            }
            bean = new AcademicServiceRequestBean(AcademicServiceRequestSituationType.valueOf(request.getParameter("academicSituationType")), AccessControl.getPerson(), year);
        }
        return bean;
    }

    private Comparator getComparator(HttpServletRequest request) {
        String orderParameter = request.getParameter(ORDER_PARAMETER);
        String orderGetter = StringUtils.isEmpty((String)orderParameter) ? "activeSituationDate" : orderParameter.substring(0, orderParameter.indexOf(ORDER_MARKER));
        String orderDir = StringUtils.isEmpty((String)orderParameter) ? DEFAULT_ORDER_DIR : orderParameter.substring(orderParameter.indexOf(ORDER_MARKER) + 1, orderParameter.length());
        boolean orderAsc = Arrays.asList(ASC_ORDER_DIR).contains(orderDir);
        if (orderGetter.equals(REQUEST_NUMBER_YEAR)) {
            return orderAsc ? AcademicServiceRequest.COMPARATOR_BY_NUMBER : new ReverseComparator(AcademicServiceRequest.COMPARATOR_BY_NUMBER);
        }
        if (orderGetter.equals(EXECUTION_YEAR)) {
            return orderAsc ? AcademicServiceRequest.EXECUTION_YEAR_AND_OID_COMPARATOR : new ReverseComparator(AcademicServiceRequest.EXECUTION_YEAR_AND_OID_COMPARATOR);
        }
        if (orderGetter.equals(REGISTRATION_NUMBER) || orderGetter.equals(DESCRIPTION) || orderGetter.equals(URGENT_REQUEST) || orderGetter.equals(REGISTRATION_NUMBER) || orderGetter.equals(REQUEST_DATE) || orderGetter.equals("activeSituationDate")) {
            ComparatorChain chain = new ComparatorChain();
            chain.addComparator((Comparator)(orderAsc ? new BeanComparator(orderGetter) : new ReverseComparator((Comparator)new BeanComparator(orderGetter))));
            chain.addComparator(DomainObjectUtil.COMPARATOR_BY_ID);
            return chain;
        }
        return null;
    }

    private Collection<AcademicServiceRequest> getAndRemoveSpecificRequests(AcademicServiceRequestBean bean, Collection<AcademicServiceRequest> remainingRequests) {
        HashSet<AcademicServiceRequest> result = new HashSet<AcademicServiceRequest>();
        Iterator<AcademicServiceRequest> iter = remainingRequests.iterator();
        while (iter.hasNext()) {
            AcademicServiceRequest academicServiceRequest = iter.next();
            if (bean.getAcademicServiceRequestSituationType() == AcademicServiceRequestSituationType.NEW) {
                if (academicServiceRequest.getActiveSituation().getCreator() != null && !academicServiceRequest.getActiveSituation().getCreator().equals((Object)academicServiceRequest.getPerson())) continue;
                iter.remove();
                result.add(academicServiceRequest);
                continue;
            }
            if (!AccessControl.getPerson().equals((Object)academicServiceRequest.getActiveSituation().getCreator())) continue;
            iter.remove();
            result.add(academicServiceRequest);
        }
        return result;
    }

    public ActionForward chooseServiceRequestType(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("academicServiceRequestCreateBean", (Object)new RegistrationAcademicServiceRequestCreator(this.getAndSetRegistration(request)));
        return mapping.findForward("prepareCreateServiceRequest");
    }

    public ActionForward chooseServiceRequestTypePostBack(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("academicServiceRequestCreateBean", this.getRenderedObject("academicServiceRequestCreateBean"));
        RenderUtils.invalidateViewState();
        return mapping.findForward("prepareCreateServiceRequest");
    }

    public ActionForward chooseServiceRequestTypeInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("academicServiceRequestCreateBean", this.getRenderedObject("academicServiceRequestCreateBean"));
        return mapping.findForward("prepareCreateServiceRequest");
    }

    public ActionForward backToViewRegistration(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.getAndSetRegistration(request);
        return mapping.findForward("viewRegistrationDetails");
    }

    public ActionForward confirmCreateServiceRequest(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("academicServiceRequestCreateBean", this.getRenderedObject("academicServiceRequestCreateBean"));
        return mapping.findForward("confirmCreateServiceRequest");
    }

    public ActionForward createServiceRequest(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        try {
            this.executeFactoryMethod();
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
            return this.confirmCreateServiceRequest(mapping, actionForm, request, response);
        }
        RegistrationAcademicServiceRequestCreator bean = (RegistrationAcademicServiceRequestCreator)this.getRenderedObject("academicServiceRequestCreateBean");
        request.setAttribute("registration", (Object)bean.getRegistration());
        return mapping.findForward("viewRegistrationDetails");
    }

    static {
        advice$revertRequestToProcessingState = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$generateRegistryCode = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        ASC_ORDER_DIR = new String[]{"ascending", "asc"};
    }

    public static class AcademicServiceRequestsManagementForm
    extends ActionForm {
        private static final long serialVersionUID = 1L;
        private String justification;
        private Integer numberOfPages;
        private Boolean sendEmailToStudent;
        private Boolean deferRequest;

        public String getJustification() {
            return this.justification;
        }

        public void setJustification(String justification) {
            this.justification = justification;
        }

        public Integer getNumberOfPages() {
            return this.numberOfPages;
        }

        public void setNumberOfPages(Integer numberOfPages) {
            this.numberOfPages = numberOfPages;
        }

        public Boolean getSendEmailToStudent() {
            return this.sendEmailToStudent;
        }

        public void setSendEmailToStudent(Boolean sendEmailToStudent) {
            this.sendEmailToStudent = sendEmailToStudent;
        }

        public Boolean getDeferRequest() {
            return this.deferRequest;
        }

        public void setDeferRequest(Boolean deferRequest) {
            this.deferRequest = deferRequest;
        }
    }
}

