/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.servlet.taglib.sop.v3.colorPickers;

import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Lesson;
import org.fenixedu.academic.domain.WrittenEvaluation;
import org.fenixedu.academic.dto.InfoLesson;
import org.fenixedu.academic.dto.InfoLessonInstance;
import org.fenixedu.academic.dto.InfoLessonInstanceAggregation;
import org.fenixedu.academic.dto.InfoShowOccupation;
import org.fenixedu.academic.dto.InfoWrittenEvaluation;
import org.fenixedu.academic.servlet.taglib.sop.v3.ColorPicker;
import pt.ist.fenixframework.DomainObject;

public class ClassTimeTableColorPicker
extends ColorPicker {
    @Override
    protected String getColorKeyFromInfoLesson(InfoShowOccupation infoShowOccupation) {
        if (infoShowOccupation instanceof InfoLesson) {
            return this.key((InfoLesson)infoShowOccupation);
        }
        if (infoShowOccupation instanceof InfoLessonInstance) {
            return this.key((InfoLessonInstance)infoShowOccupation);
        }
        if (infoShowOccupation instanceof InfoLessonInstanceAggregation) {
            return this.key((InfoLessonInstanceAggregation)infoShowOccupation);
        }
        if (infoShowOccupation instanceof InfoWrittenEvaluation) {
            return this.key((InfoWrittenEvaluation)infoShowOccupation);
        }
        return "GenericEvent";
    }

    private String key(Lesson lesson) {
        return lesson.getExecutionCourse().getExternalId();
    }

    private String key(InfoLesson infoLesson) {
        return this.key(infoLesson.getLesson());
    }

    private String key(InfoLessonInstance infoLessonInstance) {
        return this.key(infoLessonInstance.getLessonInstance().getLesson());
    }

    private String key(InfoLessonInstanceAggregation infoLessonInstanceAggregation) {
        return infoLessonInstanceAggregation.getShift().getExecutionCourse().getExternalId();
    }

    private String key(InfoWrittenEvaluation infoWrittenEvaluation) {
        StringBuilder stringBuilder = new StringBuilder();
        WrittenEvaluation writtenEvaluation = infoWrittenEvaluation.getWrittenEvaluation();
        for (ExecutionCourse executionCourse : this.sort(writtenEvaluation.getAssociatedExecutionCoursesSet())) {
            stringBuilder.append(executionCourse.getExternalId());
        }
        return stringBuilder.toString();
    }

    private SortedSet<ExecutionCourse> sort(Set<ExecutionCourse> associatedExecutionCoursesSet) {
        TreeSet<DomainObject> result = new TreeSet<DomainObject>(DomainObjectUtil.COMPARATOR_BY_ID);
        result.addAll(associatedExecutionCoursesSet);
        return result;
    }
}

