/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.enrollment.shift;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.service.ServiceMonitoring;
import org.fenixedu.academic.service.filter.enrollment.ClassEnrollmentAuthorizationFilter;
import org.fenixedu.academic.service.services.enrollment.shift.UnEnrollStudentFromShift$callable$runUnEnrollStudentFromShift;
import org.fenixedu.academic.service.services.enrollment.shift.UnEnrollStudentFromShift$callable$runUnEnrollStudentFromShift$1;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class UnEnrollStudentFromShift {
    private static final UnEnrollStudentFromShift serviceInstance;
    public static final Advice advice$runUnEnrollStudentFromShift;
    public static final Advice advice$runUnEnrollStudentFromShift$1;

    protected void run(Registration registration, String shiftId) throws StudentNotFoundServiceException, ShiftNotFoundServiceException, ShiftEnrolmentNotFoundServiceException, FenixServiceException {
        ServiceMonitoring.logService(this.getClass(), new Object[]{registration, shiftId});
        if (registration == null) {
            throw new StudentNotFoundServiceException();
        }
        if (registration.getPayedTuition() == null || registration.getPayedTuition().equals(Boolean.FALSE)) {
            throw new FenixServiceException("error.exception.notAuthorized.student.warningTuition");
        }
        Shift shift = (Shift)FenixFramework.getDomainObject((String)shiftId);
        if (shift == null) {
            throw new ShiftNotFoundServiceException();
        }
        shift.removeStudents(registration);
    }

    public static void runUnEnrollStudentFromShift(Registration registration, String string) throws StudentNotFoundServiceException, ShiftNotFoundServiceException, ShiftEnrolmentNotFoundServiceException, FenixServiceException, NotAuthorizedException {
        Object object = advice$runUnEnrollStudentFromShift.perform((Callable)new UnEnrollStudentFromShift$callable$runUnEnrollStudentFromShift(registration, string));
    }

    static /* synthetic */ void advised$runUnEnrollStudentFromShift(Registration registration, String shiftId) throws StudentNotFoundServiceException, ShiftNotFoundServiceException, ShiftEnrolmentNotFoundServiceException, FenixServiceException, NotAuthorizedException {
        ClassEnrollmentAuthorizationFilter.instance.execute(registration);
        serviceInstance.run(registration, shiftId);
    }

    public static void runUnEnrollStudentFromShift(Registration registration, String string, ExecutionSemester executionSemester) throws StudentNotFoundServiceException, ShiftNotFoundServiceException, ShiftEnrolmentNotFoundServiceException, FenixServiceException, NotAuthorizedException {
        Object object = advice$runUnEnrollStudentFromShift$1.perform((Callable)new UnEnrollStudentFromShift$callable$runUnEnrollStudentFromShift$1(registration, string, executionSemester));
    }

    static /* synthetic */ void advised$runUnEnrollStudentFromShift(Registration registration, String shiftId, ExecutionSemester executionSemester) throws StudentNotFoundServiceException, ShiftNotFoundServiceException, ShiftEnrolmentNotFoundServiceException, FenixServiceException, NotAuthorizedException {
        ClassEnrollmentAuthorizationFilter.instance.execute(registration, executionSemester);
        serviceInstance.run(registration, shiftId);
    }

    static {
        advice$runUnEnrollStudentFromShift = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$runUnEnrollStudentFromShift$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        serviceInstance = new UnEnrollStudentFromShift();
    }

    public static class ShiftEnrolmentNotFoundServiceException
    extends FenixServiceException {
    }

    public static class ShiftNotFoundServiceException
    extends FenixServiceException {
    }

    public static class StudentNotFoundServiceException
    extends FenixServiceException {
    }
}

