/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.report.phd.registration;

import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.organizationalStructure.UniversityUnit;
import org.fenixedu.academic.domain.person.Gender;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.report.FenixReport;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.I18N;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class PhdSchoolRegistrationDeclarationDocument
extends FenixReport {
    private static final long serialVersionUID = 1L;
    private final PhdIndividualProgramProcess process;

    public PhdSchoolRegistrationDeclarationDocument(PhdIndividualProgramProcess process2) {
        this.process = process2;
        this.fillReport();
    }

    @Override
    protected void fillReport() {
        AdministrativeOffice administrativeOffice = this.process.getPhdProgram().getAdministrativeOffice();
        this.addParameter("administrativeOfficeName", administrativeOffice.getName().getContent());
        this.addParameter("administrativeOfficeCoordinator", administrativeOffice.getCoordinator().getProfile().getDisplayName());
        this.addParameter("institutionName", Bennu.getInstance().getInstitutionUnit().getPartyName().getContent());
        this.addParameter("universityName", UniversityUnit.getInstitutionsUniversityUnit().getPartyName().getContent());
        this.addParameter("studentNumber", this.getStudentNumber());
        this.addParameter("studentName", this.getPerson().getName());
        this.addParameter("documentId", this.getPerson().getDocumentIdNumber());
        this.addParameter("parishOfBirth", this.getPerson().getParishOfBirth());
        this.addParameter("nationality", this.getPerson().getCountry().getCountryNationality().getContent());
        this.addParameter("registrationState", this.getRegistrationStateLabel());
        this.addParameter("executionYear", this.process.getExecutionYear().getName());
        this.addParameter("phdProgramName", this.process.getPhdProgram().getName().getContent());
        this.addParameter("documentDate", new LocalDate().toString("dd MMMM yyyy", I18N.getLocale()));
    }

    private String getStudentNumber() {
        return this.hasRegistration() ? this.getRegistration().getNumber().toString() : this.getStudent().getNumber().toString();
    }

    private String getRegistrationStateLabel() {
        Gender gender = this.getPerson().getGender();
        return gender == Gender.MALE ? BundleUtil.getString((String)"resources.PhdResources", (String)"label.phd.schoolRegistrationDeclaration.registered.male", (String[])new String[0]) : BundleUtil.getString((String)"resources.PhdResources", (String)"label.phd.schoolRegistrationDeclaration.registered.female", (String[])new String[0]);
    }

    private Person getPerson() {
        return this.process.getPerson();
    }

    private Student getStudent() {
        return this.getPerson().getStudent();
    }

    private Registration getRegistration() {
        return this.process.getRegistration();
    }

    private boolean hasRegistration() {
        return this.process.getRegistration() != null;
    }

    @Override
    public String getReportFileName() {
        return "SchoolRegistrationDeclaration-" + new DateTime().toString("yyyyMMddHHmmss");
    }

    @Override
    public String getReportTemplateKey() {
        return super.getReportTemplateKey() + ".pt";
    }
}

