/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.predicate;

import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.accessControl.AcademicAuthorizationGroup;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.predicate.AccessControlPredicate;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;

public class CourseGroupPredicates {
    public static final AccessControlPredicate<CourseGroup> curricularPlanMemberWritePredicate = new AccessControlPredicate<CourseGroup>(){

        @Override
        public boolean evaluate(CourseGroup cg) {
            DegreeCurricularPlan parentDegreeCurricularPlan = cg.getParentDegreeCurricularPlan();
            if (!parentDegreeCurricularPlan.isBolonhaDegree()) {
                return true;
            }
            User user = Authenticate.getUser();
            if (RoleType.SCIENTIFIC_COUNCIL.isMember(user) || RoleType.MANAGER.isMember(user) || AcademicAuthorizationGroup.get(AcademicOperationType.MANAGE_DEGREE_CURRICULAR_PLANS).isMember(user) || RoleType.OPERATOR.isMember(user)) {
                return true;
            }
            return parentDegreeCurricularPlan.getCurricularPlanMembersGroup().isMember(user);
        }
    };
}

