/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.alumni;

import java.io.Serializable;
import org.fenixedu.academic.domain.Alumni;
import org.fenixedu.academic.domain.BusinessArea;
import org.fenixedu.academic.domain.ContractType;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.Job;
import org.fenixedu.academic.domain.JobApplicationType;
import org.fenixedu.academic.domain.SalaryType;
import org.joda.time.LocalDate;

public class AlumniJobBean
implements Serializable {
    private Alumni alumni;
    private String employerName;
    private String city;
    private Country country;
    private BusinessArea parentBusinessArea;
    private BusinessArea childBusinessArea;
    private String position;
    private LocalDate beginDate;
    private LocalDate endDate;
    private String jobId;
    private String schema;
    private JobApplicationType applicationType;
    private ContractType contractType;
    private SalaryType salaryType;
    private Double salary;

    private AlumniJobBean(Alumni alumni, String schema) {
        this.setAlumni(alumni);
        this.setSchema(schema);
    }

    public AlumniJobBean(Alumni alumni) {
        this(alumni, "alumni.public.access.jobContact");
    }

    public AlumniJobBean(Alumni alumni, Job job) {
        this(alumni, "alumni.public.access.jobContact.full");
        this.setEmployerName(job.getEmployerName());
        this.setCity(job.getCity());
        this.setCountry(job.getCountry());
        this.setParentBusinessArea(job.getParentBusinessArea());
        this.setChildBusinessArea(job.getBusinessArea());
        this.setPosition(job.getPosition());
        this.setBeginDateAsDate(job.getBeginDate());
        this.setEndDateAsDate(job.getEndDate());
        this.setApplicationType(job.getJobApplicationType());
        this.setContractType(job.getContractType());
        this.setSalaryType(job.getSalaryType());
        this.setJobId(job.getExternalId());
        this.setSalary(job.getSalary());
    }

    public void setAlumni(Alumni alumni) {
        this.alumni = alumni;
    }

    public Alumni getAlumni() {
        return this.alumni;
    }

    public void setCountry(Country country) {
        this.country = country;
    }

    public Country getCountry() {
        return this.country;
    }

    public String getEmployerName() {
        return this.employerName;
    }

    public void setEmployerName(String employerName) {
        this.employerName = employerName;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String jobPosition) {
        this.position = jobPosition;
    }

    public void setParentBusinessArea(BusinessArea businessArea) {
        this.parentBusinessArea = businessArea;
        if (businessArea == null) {
            this.setChildBusinessArea(null);
        }
    }

    public BusinessArea getParentBusinessArea() {
        return this.parentBusinessArea;
    }

    public void setChildBusinessArea(BusinessArea businessArea) {
        this.childBusinessArea = businessArea;
    }

    public BusinessArea getChildBusinessArea() {
        return this.childBusinessArea;
    }

    public LocalDate getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(LocalDate beginDate) {
        this.beginDate = beginDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void updateSchema() {
        if (this.getParentBusinessArea() == null) {
            this.setSchema("alumni.public.access.jobContact");
        } else {
            this.setSchema("alumni.public.access.jobContact.full");
        }
    }

    private void setBeginDateAsDate(LocalDate beginDate) {
        this.setBeginDate(beginDate);
    }

    private void setEndDateAsDate(LocalDate endDate) {
        this.setEndDate(endDate);
    }

    public LocalDate getBeginDateAsLocalDate() {
        return this.getBeginDate();
    }

    public LocalDate getEndDateAsLocalDate() {
        return this.getEndDate();
    }

    public ContractType getContractType() {
        return this.contractType;
    }

    public void setContractType(ContractType contractType) {
        this.contractType = contractType;
    }

    public JobApplicationType getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(JobApplicationType applicationType) {
        this.applicationType = applicationType;
    }

    public SalaryType getSalaryType() {
        return this.salaryType;
    }

    public void setSalaryType(SalaryType salaryType) {
        this.salaryType = salaryType;
    }

    public Double getSalary() {
        return this.salary;
    }

    public void setSalary(Double salary) {
        this.salary = salary;
    }
}

