/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.studentCurriculum;

import java.util.Collections;
import java.util.Set;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.degreeStructure.BranchCourseGroup;
import org.fenixedu.academic.domain.degreeStructure.BranchType;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.studentCurriculum.BranchCurriculumGroup_Base;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;

public class BranchCurriculumGroup
extends BranchCurriculumGroup_Base {
    protected BranchCurriculumGroup() {
    }

    public BranchCurriculumGroup(CurriculumGroup parentNode, BranchCourseGroup branch) {
        this();
        this.init(parentNode, (CourseGroup)((Object)branch));
    }

    public BranchCurriculumGroup(CurriculumGroup parentNode, BranchCourseGroup branch, ExecutionSemester executionSemester) {
        this.init(parentNode, (CourseGroup)((Object)branch), executionSemester);
    }

    protected void checkInitConstraints(CurriculumGroup parent, CourseGroup courseGroup) {
        super.checkInitConstraints(parent, courseGroup);
        BranchCourseGroup branchCourseGroup = (BranchCourseGroup)((Object)courseGroup);
        CycleCurriculumGroup cycle = parent.getParentCycleCurriculumGroup();
        if (cycle != null && cycle.hasBranchCurriculumGroup(branchCourseGroup.getBranchType())) {
            throw new DomainException("error.BranchCurriculumGroup.parent.cycle.cannot.have.another.branch.with.same.type", new String[0]);
        }
    }

    public boolean isBranchCurriculumGroup() {
        return true;
    }

    public void setDegreeModule(DegreeModule degreeModule) {
        if (degreeModule != null && !(degreeModule instanceof BranchCourseGroup)) {
            throw new DomainException("error.curriculumGroup.BranchParentDegreeModuleCanOnlyBeBranchCourseGroup", new String[0]);
        }
        super.setDegreeModule(degreeModule);
    }

    public BranchCourseGroup getDegreeModule() {
        return (BranchCourseGroup)((Object)super.getDegreeModule());
    }

    public BranchType getBranchType() {
        return this.getDegreeModule().getBranchType();
    }

    public Set<BranchCurriculumGroup> getBranchCurriculumGroups() {
        return Collections.singleton(this);
    }

    public Set<BranchCurriculumGroup> getBranchCurriculumGroups(BranchType branchType) {
        return this.getBranchType() == branchType ? Collections.singleton(this) : Collections.emptySet();
    }

    public BranchCurriculumGroup getParentBranchCurriculumGroup() {
        return this;
    }

    public boolean hasBranchCurriculumGroup(BranchType type) {
        return this.getBranchType() == type;
    }

    public boolean isMajor() {
        return this.getDegreeModule().isMajor();
    }

    public boolean isMinor() {
        return this.getDegreeModule().isMinor();
    }
}

