/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degreeStructure.CycleCourseGroup;
import org.fenixedu.academic.domain.student.AffinityCyclesManagement$callable$createCycleOrRepeateSeparate;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.SeparationCyclesManagement;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class AffinityCyclesManagement {
    private StudentCurricularPlan studentCurricularPlan;
    public static final Advice advice$createCycleOrRepeateSeparate = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public AffinityCyclesManagement(StudentCurricularPlan studentCurricularPlan) {
        this.studentCurricularPlan = studentCurricularPlan;
    }

    private StudentCurricularPlan getStudentCurricularPlan() {
        return this.studentCurricularPlan;
    }

    public Registration enrol(CycleCourseGroup cycleCourseGroup) {
        return this.separateSecondCycle();
    }

    protected Registration separateSecondCycle() {
        return new SeparationCyclesManagement().separateSecondCycle(this.getStudentCurricularPlan());
    }

    public void createCycleOrRepeateSeparate() {
        Object object = advice$createCycleOrRepeateSeparate.perform((Callable)new AffinityCyclesManagement$callable$createCycleOrRepeateSeparate(this));
    }

    static /* synthetic */ void advised$createCycleOrRepeateSeparate(AffinityCyclesManagement this_) {
        if (this_.studentCurricularPlan.isActive() && this_.canSeparate()) {
            if (this_.studentAlreadyHasNewRegistration() && this_.canRepeateSeparate()) {
                new SeparationCyclesManagement().createNewSecondCycle(this_.studentCurricularPlan);
            } else {
                new SeparationCyclesManagement().separateSecondCycle(this_.studentCurricularPlan);
            }
        } else if (this_.studentCurricularPlan.hasRegistration() && this_.getRegistration().isConcluded() && this_.canRepeateSeparate()) {
            new SeparationCyclesManagement().createNewSecondCycle(this_.studentCurricularPlan);
        }
    }

    private Registration getRegistration() {
        return this.studentCurricularPlan.getRegistration();
    }

    private boolean canSeparate() {
        return this.hasFirstCycleConcluded() && this.hasExternalSecondCycle();
    }

    private boolean hasFirstCycleConcluded() {
        CycleCurriculumGroup firstCycle = this.studentCurricularPlan.getFirstCycle();
        return firstCycle != null && firstCycle.isConcluded();
    }

    private boolean hasExternalSecondCycle() {
        CycleCurriculumGroup secondCycle = this.studentCurricularPlan.getSecondCycle();
        return secondCycle != null && secondCycle.isExternal() && secondCycle.hasAnyCurriculumLines();
    }

    private boolean studentAlreadyHasNewRegistration() {
        Student student = this.getRegistration().getStudent();
        return student.hasRegistrationFor(this.studentCurricularPlan.getSecondCycle().getDegreeCurricularPlanOfDegreeModule());
    }

    private boolean canRepeateSeparate() {
        return this.hasFirstCycleConcluded() && this.hasExternalSecondCycleAndNewRegistration();
    }

    private boolean hasExternalSecondCycleAndNewRegistration() {
        CycleCurriculumGroup secondCycle = this.studentCurricularPlan.getSecondCycle();
        if (secondCycle != null && secondCycle.isExternal() && secondCycle.hasAnyCurriculumLines()) {
            Student student = this.getRegistration().getStudent();
            return student.hasActiveRegistrationFor(secondCycle.getDegreeCurricularPlanOfDegreeModule());
        }
        return false;
    }
}

