/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.alert;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.alert.PhdAlert;
import org.fenixedu.academic.domain.phd.alert.PhdAlertMessage$callable$markAsReaded;
import org.fenixedu.academic.domain.phd.alert.PhdAlertMessage$callable$markAsUnread;
import org.fenixedu.academic.domain.phd.alert.PhdAlertMessage_Base;
import org.fenixedu.academic.domain.util.email.Message;
import org.fenixedu.academic.domain.util.email.UnitBasedSender;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PhdAlertMessage
extends PhdAlertMessage_Base {
    public static final Comparator<PhdAlertMessage> COMPARATOR_BY_WHEN_CREATED_AND_ID;
    public static final Advice advice$markAsReaded;
    public static final Advice advice$markAsUnread;

    protected PhdAlertMessage() {
        this.setRootDomainObject(Bennu.getInstance());
        this.setWhenCreated(new DateTime());
    }

    public PhdAlertMessage(PhdIndividualProgramProcess process2, Person person, MultiLanguageString subject, MultiLanguageString body) {
        this();
        this.init(process2, Collections.singletonList(person), subject, body);
    }

    public PhdAlertMessage(PhdIndividualProgramProcess process2, Collection<Person> persons, MultiLanguageString subject, MultiLanguageString body) {
        this();
        this.init(process2, persons, subject, body);
    }

    protected void init(PhdIndividualProgramProcess process2, Collection<Person> persons, MultiLanguageString subject, MultiLanguageString body) {
        this.checkParameters(process2, persons, subject, body);
        super.setProcess(process2);
        super.getPersonsSet().addAll(persons);
        super.setSubject(subject);
        super.setBody(body);
        super.setReaded(Boolean.FALSE);
    }

    private void checkParameters(PhdIndividualProgramProcess process2, Collection<Person> persons, MultiLanguageString subject, MultiLanguageString body) {
        String[] args = new String[]{};
        if (process2 == null) {
            throw new DomainException("error.org.fenixedu.academic.domain.phd.alert.PhdAlertMessage.process.cannot.be.null", args);
        }
        String[] args1 = new String[]{};
        if (persons == null) {
            throw new DomainException("error.phd.alert.PhdAlertMessage.persons.cannot.be.empty", args1);
        }
        String[] args2 = new String[]{};
        if (subject == null) {
            throw new DomainException("error.phd.alert.PhdAlertMessage.subject.cannot.be.null", args2);
        }
        String[] args3 = new String[]{};
        if (body == null) {
            throw new DomainException("error.phd.alert.PhdAlertMessage.body.cannot.be.null", args3);
        }
    }

    public void setProcess(PhdIndividualProgramProcess process2) {
        throw new DomainException("error.org.fenixedu.academic.domain.phd.alert.PhdAlertMessage.cannot.modify.process", new String[0]);
    }

    public void addPersons(Person person) {
        throw new DomainException("error.org.fenixedu.academic.domain.phd.alert.PhdAlertMessage.cannot.add.person", new String[0]);
    }

    public Set<Person> getPersonsSet() {
        return Collections.unmodifiableSet(super.getPersonsSet());
    }

    public void removePersons(Person person) {
        throw new DomainException("error.org.fenixedu.academic.domain.phd.alert.PhdAlertMessage.cannot.remove.person", new String[0]);
    }

    public void setSubject(MultiLanguageString subject) {
        throw new DomainException("error.org.fenixedu.academic.domain.phd.alert.PhdAlertMessage.cannot.modify.subject", new String[0]);
    }

    public void setBody(MultiLanguageString body) {
        throw new DomainException("error.org.fenixedu.academic.domain.phd.alert.PhdAlertMessage.cannot.modify.body", new String[0]);
    }

    public void setReaded(Boolean readed) {
        throw new DomainException("error.org.fenixedu.academic.domain.phd.alert.PhdAlertMessage.cannot.modify.readed", new String[0]);
    }

    public void markAsReaded(Person person) {
        Object object = advice$markAsReaded.perform((Callable)new PhdAlertMessage$callable$markAsReaded(this, person));
    }

    static /* synthetic */ void advised$markAsReaded(PhdAlertMessage this_, Person person) {
        String[] args = new String[]{};
        if (person == null) {
            throw new DomainException("error.org.fenixedu.academic.domain.phd.alert.PhdAlertMessage.personWhoMarkAsReaded.cannot.be.null", args);
        }
        super.setReaded(Boolean.valueOf(true));
        super.setPersonWhoMarkedAsReaded(person);
    }

    public void markAsUnread() {
        Object object = advice$markAsUnread.perform((Callable)new PhdAlertMessage$callable$markAsUnread(this));
    }

    static /* synthetic */ void advised$markAsUnread(PhdAlertMessage this_) {
        super.setReaded(Boolean.valueOf(false));
        this_.setPersonWhoMarkedAsReaded(null);
    }

    public boolean isReaded() {
        return this.getReaded();
    }

    public boolean isFor(Person person) {
        return this.getPersonsSet().contains((Object)person);
    }

    public List<PhdAlert> getAlertsPossibleResponsibleForMessageGeneration() {
        ArrayList<PhdAlert> result = new ArrayList<PhdAlert>();
        Set alerts = this.getProcess().getAlertsSet();
        for (PhdAlert phdAlert : alerts) {
            if (!this.getSubject().getContent().contentEquals(phdAlert.getFormattedSubject().getContent())) continue;
            result.add(phdAlert);
        }
        return result;
    }

    protected UnitBasedSender getSender() {
        AdministrativeOffice administrativeOffice = this.getProcess().getAdministrativeOffice();
        return (UnitBasedSender)((Object)administrativeOffice.getUnit().getUnitBasedSenderSet().iterator().next());
    }

    public List<Message> getEmailsWithMatchWithThisMessage() {
        ArrayList<Message> result = new ArrayList<Message>();
        UnitBasedSender sender = this.getSender();
        Set messages = sender.getMessagesSet();
        for (Message message : messages) {
            if (!this.getSubject().getContent().contentEquals(message.getSubject())) continue;
            result.add(message);
        }
        return result;
    }

    static {
        advice$markAsReaded = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$markAsUnread = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATOR_BY_WHEN_CREATED_AND_ID = new Comparator<PhdAlertMessage>(){

            @Override
            public int compare(PhdAlertMessage m1, PhdAlertMessage m2) {
                int comp = m1.getWhenCreated().compareTo((ReadableInstant)m2.getWhenCreated());
                return comp != 0 ? comp : DomainObjectUtil.COMPARATOR_BY_ID.compare((DomainObject)m1, (DomainObject)m2);
            }
        };
    }
}

