/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.phd.PhdStudyPlan;
import org.fenixedu.academic.domain.phd.PhdStudyPlanEntryType;

public class PhdStudyPlanEntryBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Degree degree;
    private List<CompetenceCourse> competenceCourses;
    private String courseName;
    private PhdStudyPlanEntryType entryType;
    private PhdStudyPlan studyPlan;
    private Boolean internalEntry;

    public PhdStudyPlanEntryBean(PhdStudyPlan studyPlan) {
        this.setStudyPlan(studyPlan);
        this.setInternalEntry(true);
        this.setEntryType(PhdStudyPlanEntryType.NORMAL);
        this.setCompetenceCourses(new ArrayList<CompetenceCourse>());
        this.setDegree(!studyPlan.getDegree().isEmpty() ? studyPlan.getDegree() : null);
    }

    public String getCourseName() {
        return this.courseName;
    }

    public void setCourseName(String courseName) {
        this.courseName = courseName;
    }

    public PhdStudyPlanEntryType getEntryType() {
        return this.entryType;
    }

    public void setEntryType(PhdStudyPlanEntryType entryType) {
        this.entryType = entryType;
    }

    public Boolean getInternalEntry() {
        return this.internalEntry;
    }

    public void setInternalEntry(Boolean internalEntry) {
        this.internalEntry = internalEntry;
    }

    public PhdStudyPlan getStudyPlan() {
        return this.studyPlan;
    }

    public void setStudyPlan(PhdStudyPlan studyPlan) {
        this.studyPlan = studyPlan;
    }

    public Degree getDegree() {
        return this.degree;
    }

    public void setDegree(Degree degree) {
        this.degree = degree;
    }

    public List<CompetenceCourse> getCompetenceCourses() {
        ArrayList<CompetenceCourse> result = new ArrayList<CompetenceCourse>();
        for (CompetenceCourse each : this.competenceCourses) {
            result.add(each);
        }
        return result;
    }

    public void setCompetenceCourses(List<CompetenceCourse> competenceCourses) {
        ArrayList<CompetenceCourse> result = new ArrayList<CompetenceCourse>();
        for (CompetenceCourse each : competenceCourses) {
            result.add(each);
        }
        this.competenceCourses = result;
    }
}

