/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd;

import org.fenixedu.academic.domain.Holiday;
import org.fenixedu.academic.util.WeekDay;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class PhdProgramCalendarUtil {
    public static int countWorkDaysBetween(LocalDate startDate, LocalDate endDate) {
        int result = 0;
        LocalDate current = startDate.plusDays(1);
        while (!current.isAfter((ReadablePartial)endDate)) {
            if (PhdProgramCalendarUtil.isWorkDay(current)) {
                ++result;
            }
            current = current.plusDays(1);
        }
        return result;
    }

    public static LocalDate addWorkDaysTo(LocalDate date, int workDays) {
        int current = workDays;
        LocalDate result = date;
        while (current > 0) {
            if (!PhdProgramCalendarUtil.isWorkDay(result = result.plusDays(1))) continue;
            --current;
        }
        return result;
    }

    private static boolean isWorkDay(LocalDate current) {
        WeekDay dayOfWeek = WeekDay.fromJodaTimeToWeekDay(current.toDateTimeAtStartOfDay());
        return dayOfWeek != WeekDay.SATURDAY && dayOfWeek != WeekDay.SUNDAY && !Holiday.isHoliday(current);
    }
}

