/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.SortedSet;
import jvstm.cps.ConsistencyPredicate;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.ContentManagementLog;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.Lesson;
import org.fenixedu.academic.domain.LessonInstance;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.academic.domain.Summary_Base;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.util.HourMinuteSecond;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.signals.DomainObjectEvent;
import org.fenixedu.bennu.signals.Signal;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.Partial;
import org.joda.time.ReadablePartial;
import org.joda.time.TimeOfDay;
import org.joda.time.YearMonthDay;
import pt.ist.fenixframework.DomainObject;

public class Summary
extends Summary_Base {
    public static final String CREATE_SIGNAL = "academic.summary.create.signal";
    public static final String EDIT_SIGNAL = "academic.summary.edit.signal";
    public static final Comparator<Summary> COMPARATOR_BY_DATE_AND_HOUR = new Comparator<Summary>(){

        @Override
        public int compare(Summary o1, Summary o2) {
            int c1 = o2.getSummaryDateYearMonthDay().compareTo((ReadablePartial)o1.getSummaryDateYearMonthDay());
            if (c1 == 0) {
                int c2 = o2.getSummaryHourHourMinuteSecond().compareTo(o1.getSummaryHourHourMinuteSecond());
                return c2 == 0 ? DomainObjectUtil.COMPARATOR_BY_ID.compare((DomainObject)o1, (DomainObject)o2) : c2;
            }
            return c1;
        }
    };
    public static final Comparator<Summary> COMPARATOR_BY_DATE_AND_HOUR_ASC = new Comparator<Summary>(){

        @Override
        public int compare(Summary o1, Summary o2) {
            int c1 = o2.getSummaryDateYearMonthDay().compareTo((ReadablePartial)o1.getSummaryDateYearMonthDay());
            if (c1 == 0) {
                int c2 = o2.getSummaryHourHourMinuteSecond().compareTo(o1.getSummaryHourHourMinuteSecond());
                return -1 * (c2 == 0 ? DomainObjectUtil.COMPARATOR_BY_ID.compare((DomainObject)o1, (DomainObject)o2) : c2);
            }
            return -1 * c1;
        }
    };

    public Summary(MultiLanguageString title, MultiLanguageString summaryText, Integer studentsNumber, Boolean isExtraLesson, Professorship professorship, String teacherName, Teacher teacher, Shift shift, Lesson lesson, YearMonthDay date, Space room, Partial hour, ShiftType type, Boolean taught) {
        this.setRootDomainObject(Bennu.getInstance());
        this.fillSummaryWithInfo(title, summaryText, studentsNumber, isExtraLesson, professorship, teacherName, teacher, shift, lesson, date, room, hour, type, taught);
        ContentManagementLog.createLog(shift.getExecutionCourse(), "resources.MessagingResources", "log.executionCourse.content.summary.added", title.getContent(), shift.getPresentationName(), shift.getExecutionCourse().getNome(), shift.getExecutionCourse().getDegreePresentationString());
    }

    public void edit(MultiLanguageString title, MultiLanguageString summaryText, Integer studentsNumber, Boolean isExtraLesson, Professorship professorship, String teacherName, Teacher teacher, Shift shift, Lesson lesson, YearMonthDay date, Space room, Partial hour, ShiftType type, Boolean taught) {
        this.fillSummaryWithInfo(title, summaryText, studentsNumber, isExtraLesson, professorship, teacherName, teacher, shift, lesson, date, room, hour, type, taught);
        ContentManagementLog.createLog(shift.getExecutionCourse(), "resources.MessagingResources", "log.executionCourse.content.summary.edited", title.getContent(), shift.getPresentationName(), shift.getExecutionCourse().getNome(), shift.getExecutionCourse().getDegreePresentationString());
        Signal.emit((String)EDIT_SIGNAL, (Object)new DomainObjectEvent((DomainObject)this));
    }

    private void fillSummaryWithInfo(MultiLanguageString title, MultiLanguageString summaryText, Integer studentsNumber, Boolean isExtraLesson, Professorship professorship, String teacherName, Teacher teacher, Shift shift, Lesson lesson, YearMonthDay day, Space room, Partial hour, ShiftType type, Boolean taught) {
        this.setShift(shift);
        this.setSummaryDateYearMonthDay(day);
        this.setExecutionCourse(shift.getExecutionCourse());
        this.setTitle(title);
        this.setSummaryText(summaryText);
        this.setIsExtraLesson(isExtraLesson);
        this.checkSpecialParameters(isExtraLesson, professorship, teacherName, teacher, lesson, hour, type);
        this.checkIfInternalTeacherHasProfessorhipInExecutionCourse(teacher, shift.getExecutionCourse());
        this.checkIfSummaryDateIsValid(day, shift.getExecutionPeriod(), lesson, isExtraLesson);
        this.setStudentsNumber(studentsNumber);
        this.setProfessorship(professorship);
        this.setTeacherName(teacherName);
        this.setTeacher(teacher);
        this.setLastModifiedDateDateTime(new DateTime());
        this.setSummaryType(type);
        this.setTaught(taught);
        if (isExtraLesson.booleanValue()) {
            super.setLessonInstance(null);
            this.setRoom(room);
            HourMinuteSecond hourMinuteSecond = new HourMinuteSecond(hour.get(DateTimeFieldType.hourOfDay()), hour.get(DateTimeFieldType.minuteOfHour()), 0);
            this.setSummaryHourHourMinuteSecond(hourMinuteSecond);
        } else {
            this.setRoom(lesson.getSala());
            this.setSummaryHourHourMinuteSecond(lesson.getBeginHourMinuteSecond());
            this.lessonInstanceManagement(lesson, day, lesson.getSala());
            if (this.getLessonInstance() == null) {
                throw new DomainException("error.Summary.empty.LessonInstances", new String[0]);
            }
        }
    }

    public void delete() {
        ContentManagementLog.createLog(this.getShift().getExecutionCourse(), "resources.MessagingResources", "log.executionCourse.content.summary.removed", this.getTitle().getContent(), this.getShift().getPresentationName(), this.getShift().getExecutionCourse().getNome(), this.getShift().getExecutionCourse().getDegreePresentationString());
        super.setExecutionCourse(null);
        super.setShift(null);
        super.setLessonInstance(null);
        this.setRoom(null);
        this.setProfessorship(null);
        this.setTeacher(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    @ConsistencyPredicate
    protected boolean checkRequiredParameters() {
        return this.getTitle() != null && !this.getTitle().isEmpty() && this.getSummaryText() != null && !this.getSummaryText().isEmpty() && this.getSummaryDateYearMonthDay() != null && this.getSummaryHourHourMinuteSecond() != null && this.getIsExtraLesson() != null;
    }

    private void lessonInstanceManagement(Lesson lesson, YearMonthDay day, Space room) {
        LessonInstance lessonInstance = lesson.getLessonInstanceFor(day);
        if (lessonInstance == null) {
            new LessonInstance(this, lesson);
        } else {
            lessonInstance.summaryAndCourseLoadManagement(this, lesson);
        }
    }

    public Lesson getLesson() {
        return this.getLessonInstance() != null ? this.getLessonInstance().getLesson() : null;
    }

    public void setSummaryHourHourMinuteSecond(HourMinuteSecond summaryHourHourMinuteSecond) {
        if (summaryHourHourMinuteSecond == null) {
            throw new DomainException("error.Summary.empty.time", new String[0]);
        }
        super.setSummaryHourHourMinuteSecond(summaryHourHourMinuteSecond);
    }

    public void setIsExtraLesson(Boolean isExtraLesson) {
        if (isExtraLesson == null) {
            throw new DomainException("error.summary.no.type", new String[0]);
        }
        super.setIsExtraLesson(isExtraLesson);
    }

    public void setExecutionCourse(ExecutionCourse executionCourse) {
        if (executionCourse == null) {
            throw new DomainException("error.summary.no.executionCourse", new String[0]);
        }
        super.setExecutionCourse(executionCourse);
    }

    public void setSummaryDateYearMonthDay(YearMonthDay summaryDateYearMonthDay) {
        if (summaryDateYearMonthDay == null) {
            throw new DomainException("error.summary.no.date", new String[0]);
        }
        super.setSummaryDateYearMonthDay(summaryDateYearMonthDay);
    }

    public void setTitle(MultiLanguageString title) {
        if (title == null || title.getAllContents().isEmpty()) {
            throw new DomainException("error.summary.no.title", new String[0]);
        }
        super.setTitle(title);
    }

    public void setSummaryText(MultiLanguageString summaryText) {
        if (summaryText == null || summaryText.getAllContents().isEmpty()) {
            throw new DomainException("error.summary.no.summaryText", new String[0]);
        }
        super.setSummaryText(summaryText);
    }

    public void setLessonInstance(LessonInstance lessonInstance) {
        if (lessonInstance == null) {
            throw new DomainException("error.Summary.empty.lessonInstance", new String[0]);
        }
        super.setLessonInstance(lessonInstance);
    }

    public void setShift(Shift shift) {
        if (shift == null) {
            throw new DomainException("error.summary.no.shift", new String[0]);
        }
        super.setShift(shift);
    }

    private void checkIfSummaryDateIsValid(YearMonthDay date, ExecutionSemester executionSemester, Lesson lesson, Boolean isExtraLesson) {
        if (!isExtraLesson.booleanValue()) {
            Summary summary = lesson.getSummaryByDate(date);
            if (summary != null && !summary.equals((Object)this)) {
                throw new DomainException("error.summary.already.exists", new String[0]);
            }
            if (!lesson.isDateValidToInsertSummary(date)) {
                throw new DomainException("error.summary.no.valid.date.to.lesson", new String[0]);
            }
            if (!lesson.isTimeValidToInsertSummary(new HourMinuteSecond(), date)) {
                throw new DomainException("error.summary.no.valid.time.to.lesson", new String[0]);
            }
        } else if (!executionSemester.containsDay(date)) {
            throw new DomainException("error.summary.no.valid.date", new String[0]);
        }
    }

    private void checkIfInternalTeacherHasProfessorhipInExecutionCourse(Teacher teacher, ExecutionCourse executionCourse) {
        if (teacher != null && teacher.getProfessorshipByExecutionCourse(executionCourse) != null) {
            throw new DomainException("error.summary.teacher.is.executionCourse.professorship", new String[0]);
        }
    }

    private void checkSpecialParameters(Boolean isExtraLesson, Professorship professorship, String teacherName, Teacher teacher, Lesson lesson, Partial hour, ShiftType type) {
        if (professorship == null && StringUtils.isEmpty((String)teacherName) && teacher == null) {
            throw new DomainException("error.summary.no.teacher", new String[0]);
        }
        if (isExtraLesson.booleanValue()) {
            if (hour == null) {
                throw new DomainException("error.summary.no.hour", new String[0]);
            }
        } else {
            if (lesson == null) {
                throw new DomainException("error.summary.no.lesson", new String[0]);
            }
            if (type == null) {
                throw new DomainException("error.summary.no.shifType", new String[0]);
            }
        }
    }

    public String getOrder() {
        int index;
        SortedSet<YearMonthDay> allLessonDates;
        ArrayList<YearMonthDay> lessonDates;
        StringBuilder stringBuilder = new StringBuilder();
        Lesson lesson = this.getLesson();
        if (lesson != null && !(lessonDates = new ArrayList<YearMonthDay>(allLessonDates = lesson.getAllLessonDates())).isEmpty() && (index = lessonDates.indexOf(this.getSummaryDateYearMonthDay())) != -1) {
            stringBuilder.append("(").append(index + 1).append("/");
            return stringBuilder.append(lessonDates.size()).append(")").toString();
        }
        return "";
    }

    public Space getRoom() {
        if (this.isExtraSummary()) {
            return super.getRoom();
        }
        if (this.getLessonInstance() != null) {
            return this.getLessonInstance().getRoom();
        }
        return null;
    }

    public void moveFromTeacherToProfessorship(Professorship professorship) {
        if (this.getTeacher() != null && professorship != null && professorship.getExecutionCourse().equals((Object)this.getExecutionCourse()) && professorship.getTeacher().equals((Object)this.getTeacher())) {
            this.setTeacher(null);
            this.setProfessorship(professorship);
        }
    }

    public ShiftType getShiftType() {
        return this.getLessonInstance().getCourseLoad().getType();
    }

    public boolean isExtraSummary() {
        return this.getIsExtraLesson();
    }

    public DateTime getSummaryDateTime() {
        HourMinuteSecond time = this.getSummaryHourHourMinuteSecond();
        return this.getSummaryDateYearMonthDay().toDateTime(new TimeOfDay(time.getHour(), time.getMinuteOfHour(), time.getSecondOfMinute(), 0));
    }

    @Deprecated
    public Date getLastModifiedDate() {
        DateTime dt = this.getLastModifiedDateDateTime();
        return dt == null ? null : new Date(dt.getMillis());
    }

    @Deprecated
    public void setLastModifiedDate(Date date) {
        if (date == null) {
            this.setLastModifiedDateDateTime(null);
        } else {
            this.setLastModifiedDateDateTime(new DateTime(date.getTime()));
        }
    }

    @Deprecated
    public Date getSummaryDate() {
        YearMonthDay ymd = this.getSummaryDateYearMonthDay();
        return ymd == null ? null : new Date(ymd.getYear() - 1900, ymd.getMonthOfYear() - 1, ymd.getDayOfMonth());
    }

    @Deprecated
    public void setSummaryDate(Date date) {
        if (date == null) {
            this.setSummaryDateYearMonthDay(null);
        } else {
            this.setSummaryDateYearMonthDay(YearMonthDay.fromDateFields((Date)date));
        }
    }

    @Deprecated
    public Date getSummaryHour() {
        HourMinuteSecond hms = this.getSummaryHourHourMinuteSecond();
        return hms == null ? null : new Date(0, 0, 1, hms.getHour(), hms.getMinuteOfHour(), hms.getSecondOfMinute());
    }

    @Deprecated
    public void setSummaryHour(Date date) {
        if (date == null) {
            this.setSummaryHourHourMinuteSecond(null);
        } else {
            this.setSummaryHourHourMinuteSecond(HourMinuteSecond.fromDateFields(date));
        }
    }
}

